/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.io.Serializable;
import net.sf.okapi.lib.xliff.DataStore;
import net.sf.okapi.lib.xliff.Fragment;
import org.oasisopen.xliff.v2.IExtendedAttributes;
import org.oasisopen.xliff.v2.IWithExtendedAttributes;

public class Part
implements Serializable,
IWithExtendedAttributes {
    private static final long serialVersionUID = 64L;
    private DataStore store;
    private Fragment source;
    private Fragment target;
    private int targetOrder;
    private IExtendedAttributes xattrs;

    public Part(DataStore store) {
        this.store = store;
        this.source = new Fragment(store);
    }

    public Part(DataStore store, String sourceContent) {
        this.store = store;
        this.source = new Fragment(store, false, sourceContent);
    }

    public Fragment getSource() {
        return this.source;
    }

    public void setSource(Fragment fragment) {
        if (this.store != fragment.getDataStore()) {
            throw new RuntimeException("The fragment passed in setSource must use the same codes store.");
        }
        this.source = fragment;
    }

    public void setSource(String plainText) {
        this.source = new Fragment(this.store, false, plainText);
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public Fragment getTarget(boolean createIfNeeded) {
        if (this.target == null && createIfNeeded) {
            this.target = new Fragment(this.store, true);
        }
        return this.target;
    }

    public void setTarget(Fragment fragment) {
        if (this.store != fragment.getDataStore()) {
            throw new RuntimeException("The fragment passed in setTarget must use the same codes store.");
        }
        this.target = fragment;
    }

    public void setTarget(String plainText) {
        this.target = new Fragment(this.store, true, plainText);
    }

    public void setTargetOrder(int targetOrder) {
        this.targetOrder = targetOrder;
    }

    public int getTargetOrder() {
        return this.targetOrder;
    }

    public DataStore getDataStore() {
        return this.store;
    }

    @Override
    public void setExtendedAttributes(IExtendedAttributes attributes) {
        this.xattrs = attributes;
    }

    @Override
    public IExtendedAttributes getExtendedAttributes() {
        return this.xattrs;
    }

    @Override
    public boolean hasExtendedAttribute() {
        if (this.xattrs == null) {
            return false;
        }
        return this.xattrs.size() > 0;
    }
}

