/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.okapi.lib.xliff.DataStore;
import net.sf.okapi.lib.xliff.EventData;
import net.sf.okapi.lib.xliff.Part;
import net.sf.okapi.lib.xliff.Segment;
import org.oasisopen.xliff.v2.ICandidate;
import org.oasisopen.xliff.v2.INote;
import org.oasisopen.xliff.v2.IWithCandidates;
import org.oasisopen.xliff.v2.IWithNotes;

public class Unit
extends EventData
implements Iterable<Part>,
IWithCandidates,
IWithNotes {
    private static final long serialVersionUID = 64L;
    private ArrayList<Part> list;
    private DataStore store;
    private ArrayList<ICandidate> candidates;
    private ArrayList<INote> notes;

    public Unit(String id) {
        this.setId(id);
        this.list = new ArrayList();
        this.store = new DataStore();
    }

    @Override
    public Iterator<Part> iterator() {
        return new Iterator<Part>(){
            int current = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The method remove() not supported.");
            }

            @Override
            public Part next() {
                return (Part)Unit.this.list.get(++this.current - 1);
            }

            @Override
            public boolean hasNext() {
                return !Unit.this.list.isEmpty() && this.current < Unit.this.list.size();
            }
        };
    }

    public int getPartCount() {
        return this.list.size();
    }

    public Segment appendNewSegment() {
        Segment seg = new Segment(this.store);
        this.list.add(seg);
        return seg;
    }

    public Part appendNewIgnorable() {
        Part part = new Part(this.store);
        this.list.add(part);
        return part;
    }

    public Part getPart(int partIndex) {
        return this.list.get(partIndex);
    }

    public DataStore getDataStore() {
        return this.store;
    }

    @Override
    public void addCandidate(ICandidate candidate) {
        if (this.candidates == null) {
            this.candidates = new ArrayList();
        }
        this.candidates.add(candidate);
    }

    @Override
    public List<ICandidate> getCandidates() {
        if (this.candidates == null) {
            return Collections.emptyList();
        }
        return this.candidates;
    }

    @Override
    public int getCandidateCount() {
        if (this.candidates == null) {
            return 0;
        }
        return this.candidates.size();
    }

    @Override
    public void addNote(INote note) {
        if (this.notes == null) {
            this.notes = new ArrayList();
        }
        this.notes.add(note);
    }

    @Override
    public List<INote> getNotes() {
        if (this.notes == null) {
            return Collections.emptyList();
        }
        return this.notes;
    }

    @Override
    public int getNoteCount() {
        if (this.notes == null) {
            return 0;
        }
        return this.notes.size();
    }
}

