/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.batchtranslation;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.batchtranslation.BatchTranslator;
import net.sf.okapi.steps.batchtranslation.Parameters;

@UsingParameters(value=Parameters.class)
public class BatchTranslationStep
extends BasePipelineStep {
    private Parameters params = new Parameters();
    private boolean isDone;
    private BatchTranslator trans;
    private IFilterConfigurationMapper fcMapper;
    private String rootDir;

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @Override
    public String getName() {
        return "Batch Translation";
    }

    @Override
    public String getDescription() {
        return "Creates translations from an external program for a given input document. Expects: raw document. Sends back: raw document.";
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.isDone = true;
        this.trans = new BatchTranslator(this.fcMapper, this.params, this.rootDir);
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        if (this.trans != null) {
            this.trans.endBatch();
        }
        return event;
    }

    @Override
    protected Event handleStartBatchItem(Event event) {
        this.isDone = false;
        return event;
    }

    @Override
    protected Event handleRawDocument(Event event) {
        this.trans.processDocument((RawDocument)event.getResource());
        this.isDone = true;
        return event;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }
}

