/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.codesremoval;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.steps.codesremoval.Parameters;

public class CodesRemover {
    private Parameters params;
    private LocaleId targetLocale;

    public CodesRemover(Parameters params, LocaleId targetLocale) {
        this.params = params;
        this.targetLocale = targetLocale;
    }

    public void processTextUnit(ITextUnit tu) {
        if (!tu.isTranslatable() && !this.params.getIncludeNonTranslatable()) {
            return;
        }
        if (this.params.getStripSource()) {
            this.processContainer(tu.getSource());
        }
        if (this.params.getStripTarget() && tu.hasTarget(this.targetLocale)) {
            this.processContainer(tu.getTarget(this.targetLocale));
        }
    }

    public void processContainer(TextContainer tc) {
        for (TextPart part : tc) {
            this.processFragment(part.text);
        }
    }

    public void processFragment(TextFragment tf) {
        String text = tf.getCodedText();
        List<Code> codes = tf.getCodes();
        StringBuilder tmp = new StringBuilder();
        ArrayList<Code> remaining = new ArrayList<Code>();
        block7: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    switch (this.params.getMode()) {
                        case 1: {
                            Code code = codes.get(TextFragment.toIndex(text.charAt(++i)));
                            code.setData("");
                            remaining.add(code);
                            tmp.append(text.charAt(i - 1));
                            tmp.append(TextFragment.toChar(remaining.size() - 1));
                            continue block7;
                        }
                        case 0: {
                            Code code = codes.get(TextFragment.toIndex(text.charAt(++i)));
                            tmp.append(code.getData());
                            continue block7;
                        }
                    }
                    ++i;
                    continue block7;
                }
                default: {
                    tmp.append(text.charAt(i));
                }
            }
        }
        tf.setCodedText(tmp.toString(), remaining);
    }
}

