/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.rtf;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filterwriter.ILayerProvider;

public class LayerProvider
implements ILayerProvider {
    private CharsetEncoder outputEncoder;
    private String lineBreak;

    @Override
    public String endCode() {
        return "}";
    }

    @Override
    public String endInline() {
        return "}";
    }

    @Override
    public String startCode() {
        return "{\\cs5\\f1\\cf15\\lang1024 ";
    }

    @Override
    public String startInline() {
        return "{\\cs6\\f1\\cf6\\lang1024 ";
    }

    @Override
    public String startSegment() {
        return "{\\cs15\\v\\cf12\\sub\\f2 \\{0>}{\\v\\f1 ";
    }

    @Override
    public String endSegment() {
        return "{\\cs15\\v\\cf12\\sub\\f2 <0\\}}";
    }

    @Override
    public String midSegment(int leverage) {
        return String.format("%s%d%s", "}{\\cs15\\v\\cf12\\sub\\f2 <\\}", leverage, "\\{>}");
    }

    @Override
    public String encode(String text, int context) {
        return Util.escapeToRTF(text, true, context, this.outputEncoder);
    }

    @Override
    public String encode(char value, int context) {
        return Util.escapeToRTF(String.valueOf(value), true, context, this.outputEncoder);
    }

    @Override
    public String encode(int value, int context) {
        if (Character.isSupplementaryCodePoint(value)) {
            return Util.escapeToRTF(new String(Character.toChars(value)), true, context, this.outputEncoder);
        }
        return Util.escapeToRTF(String.valueOf((char)value), true, context, this.outputEncoder);
    }

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
        this.outputEncoder = Charset.forName(encoding).newEncoder();
        this.lineBreak = lineBreak;
    }

    @Override
    public String toNative(String propertyName, String value) {
        return value;
    }

    @Override
    public String getLineBreak() {
        return this.lineBreak;
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        return this.outputEncoder;
    }
}

