/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount.common;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.steps.wordcount.WordCounter;
import net.sf.okapi.steps.wordcount.common.BaseCountStep;

public abstract class AltAnnotationBasedCountStep
extends BaseCountStep {
    protected abstract boolean accept(MatchType var1);

    private boolean acceptATA(AltTranslationsAnnotation ata) {
        if (ata == null) {
            return false;
        }
        for (AltTranslation at : ata) {
            MatchType type;
            if (at == null || !this.accept(type = at.getType())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected long count(TextContainer textContainer, LocaleId locale) {
        long count = WordCounter.getCount(this.getSource());
        if (count == 0L) {
            count = WordCounter.count(this.getSource(), locale);
        }
        return count;
    }

    @Override
    protected long count(Segment segment, LocaleId locale) {
        long count = WordCounter.getCount(segment);
        if (count == 0L) {
            count = WordCounter.count(segment, locale);
        }
        return count;
    }

    @Override
    protected boolean countOnlyTranslatable() {
        return true;
    }

    @Override
    protected long countInTextUnit(ITextUnit textUnit) {
        if (textUnit == null) {
            return 0L;
        }
        LocaleId srcLocale = this.getSourceLocale();
        LocaleId trgLocale = this.getTargetLocale();
        TextContainer source = textUnit.getSource();
        TextContainer target = textUnit.getTarget(trgLocale);
        if (target == null) {
            return 0L;
        }
        long segmentsCount = 0L;
        long textContainerCount = 0L;
        ISegments segs = target.getSegments();
        ISegments srcSegments = source.getSegments();
        if (segs != null) {
            for (Segment seg : segs) {
                if (!this.acceptATA(seg.getAnnotation(AltTranslationsAnnotation.class))) continue;
                Segment srcSeg = srcSegments.get(seg.getId());
                long segCount = this.count(srcSeg, srcLocale);
                segmentsCount += segCount;
                this.saveToMetrics(seg, segCount);
            }
        }
        if (this.acceptATA(target.getAnnotation(AltTranslationsAnnotation.class))) {
            textContainerCount = this.count(source, srcLocale);
            this.saveToMetrics(target, textContainerCount);
        }
        if (textContainerCount > 0L) {
            return textContainerCount;
        }
        if (segmentsCount > 0L) {
            return segmentsCount;
        }
        return 0L;
    }
}

