/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.reader;

import java.net.URI;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.xliffkit.opc.OPCPackageReader;
import net.sf.okapi.steps.xliffkit.reader.Parameters;
import net.sf.okapi.steps.xliffkit.reader.TextUnitMerger;

@UsingParameters
public class XLIFFKitReaderStep
extends BasePipelineStep {
    private OPCPackageReader reader;
    private boolean isDone = true;
    private String outputPath;
    private String outputEncoding;
    private Parameters params = new Parameters();
    private TextUnitMerger merger = new TextUnitMerger();

    public XLIFFKitReaderStep() {
        this.reader = new OPCPackageReader(this.merger);
    }

    @Override
    public String getDescription() {
        return "Reads XLIFF translation kit. Expects: Raw document for T-kit. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "XLIFF Kit Reader";
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputPath = outputURI.getPath();
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_ENCODING)
    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_BATCH: {
                this.isDone = true;
                break;
            }
            case START_BATCH_ITEM: {
                this.isDone = false;
                return event;
            }
            case RAW_DOCUMENT: {
                this.isDone = false;
                RawDocument rd = (RawDocument)event.getResource();
                this.merger.setUseApprovedOnly(this.params.isUseApprovedOnly());
                this.merger.setUpdateApprovedFlag(this.params.isUpdateApprovedFlag());
                if (this.params.isGenerateTargets()) {
                    this.reader.setGeneratorOptions(this.outputEncoding, this.outputPath);
                }
                this.reader.open(rd);
                return this.reader.next();
            }
        }
        if (this.isDone) {
            return event;
        }
        Event e = this.reader.next();
        this.isDone = !this.reader.hasNext();
        return e;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public void destroy() {
        this.reader.close();
    }

    @Override
    public void cancel() {
        this.reader.cancel();
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }
}

