/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffsplitter;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=XliffJoinerParameters.class)
public class XliffJoinerParameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String INPUTFILEMARKER = "inputFileMarker";
    private static final String OUTPUTFILEMARKER = "outputFileMarker";
    private String inputFileMarker;
    private String outputFileMarker;

    public XliffJoinerParameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.inputFileMarker = "_PART";
        this.outputFileMarker = "_CONCAT";
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.inputFileMarker = this.buffer.getString(INPUTFILEMARKER, this.inputFileMarker);
        this.outputFileMarker = this.buffer.getString(OUTPUTFILEMARKER, this.outputFileMarker);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString(INPUTFILEMARKER, this.inputFileMarker);
        this.buffer.setString(OUTPUTFILEMARKER, this.outputFileMarker);
        return this.buffer.toString();
    }

    public String getInputFileMarker() {
        return this.inputFileMarker;
    }

    public void setInputFileMarker(String inputFileMarker) {
        this.inputFileMarker = inputFileMarker;
    }

    public String getOutputFileMarker() {
        return this.outputFileMarker;
    }

    public void setOutputFileMarker(String outputFileMarker) {
        this.outputFileMarker = outputFileMarker;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(INPUTFILEMARKER, "Input file marker", null);
        desc.add(OUTPUTFILEMARKER, "Output file marker", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("XLIFF Joiner", true, false);
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(INPUTFILEMARKER));
        tip.setVertical(false);
        tip = desc.addTextInputPart(paramsDesc.get(OUTPUTFILEMARKER));
        tip.setVertical(false);
        tip.setAllowEmpty(true);
        return desc;
    }
}

