/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.tikal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.applications.tikal.LogHandler;
import net.sf.okapi.applications.tikal.XLIFFMergingStep;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.DefaultFilters;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationEditor;
import net.sf.okapi.common.filters.IFilterConfigurationListEditor;
import net.sf.okapi.common.filterwriter.XLIFFWriter;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.plugins.PluginsManager;
import net.sf.okapi.common.query.IQuery;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.apertium.ApertiumMTConnector;
import net.sf.okapi.connectors.globalsight.GlobalSightTMConnector;
import net.sf.okapi.connectors.globalsight.Parameters;
import net.sf.okapi.connectors.google.GoogleMTv2Connector;
import net.sf.okapi.connectors.google.GoogleMTv2Parameters;
import net.sf.okapi.connectors.microsoft.MicrosoftMTConnector;
import net.sf.okapi.connectors.mymemory.MyMemoryTMConnector;
import net.sf.okapi.connectors.opentran.OpenTranTMConnector;
import net.sf.okapi.connectors.pensieve.PensieveTMConnector;
import net.sf.okapi.connectors.tda.TDASearchConnector;
import net.sf.okapi.connectors.translatetoolkit.TranslateToolkitTMConnector;
import net.sf.okapi.filters.mosestext.FilterWriterParameters;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.ITMQuery;
import net.sf.okapi.steps.common.FilterEventsToRawDocumentStep;
import net.sf.okapi.steps.common.FilterEventsWriterStep;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.formatconversion.FormatConversionStep;
import net.sf.okapi.steps.formatconversion.TableFilterWriterParameters;
import net.sf.okapi.steps.leveraging.LeveragingStep;
import net.sf.okapi.steps.moses.ExtractionStep;
import net.sf.okapi.steps.moses.MergingParameters;
import net.sf.okapi.steps.moses.MergingStep;
import net.sf.okapi.steps.segmentation.SegmentationStep;

public class Main {
    protected static final int CMD_EXTRACT = 0;
    protected static final int CMD_MERGE = 1;
    protected static final int CMD_EDITCONFIG = 2;
    protected static final int CMD_QUERYTRANS = 3;
    protected static final int CMD_CONV2PO = 4;
    protected static final int CMD_CONV2TMX = 5;
    protected static final int CMD_CONV2TABLE = 6;
    protected static final int CMD_CONV2PEN = 7;
    protected static final int CMD_TRANSLATE = 8;
    protected static final int CMD_EXTRACTTOMOSES = 9;
    protected static final int CMD_LEVERAGEMOSES = 10;
    protected static final int CMD_SEGMENTATION = 11;
    protected static final int CMD_SHOWCONFIGS = 12;
    protected static final int CMD_ADDTRANS = 13;
    private static final String DEFAULT_SEGRULES = "-";
    private static final String MSG_ONLYWITHUICOMP = "UI-based commands are available only in the distributions with UI components.";
    private static PrintStream ps;
    protected ArrayList<String> inputs = new ArrayList();
    protected String skeleton;
    protected String output;
    protected String specifiedConfigId;
    protected String specifiedConfigIdPath;
    protected String configId;
    protected String inputEncoding;
    protected String outputEncoding;
    protected LocaleId srcLoc;
    protected LocaleId trgLoc;
    protected int command = -1;
    protected String query;
    protected String addTransTrans;
    protected int addTransRating = 4;
    protected boolean useGoogleV2;
    protected String googleV2Params;
    protected boolean useOpenTran;
    protected boolean useTransToolkit;
    protected String transToolkitParams;
    protected boolean useGlobalSight;
    protected String globalSightParams;
    protected boolean useTDA;
    protected String tdaParams;
    protected boolean useMyMemory;
    protected String myMemoryParams;
    protected boolean useApertium;
    protected String apertiumParams;
    protected boolean usePensieve;
    protected String pensieveData;
    protected boolean useMicrosoft;
    protected String microsoftParams;
    protected boolean genericOutput = false;
    protected String tableConvFormat;
    protected String tableConvCodes;
    protected int convTargetStyle = 0;
    protected boolean convSkipEntriesWithoutText = true;
    protected boolean convOverwrite = false;
    protected String segRules;
    protected boolean showTraceHint = true;
    protected String tmOptions;
    protected boolean levOptFillTarget = true;
    protected String levOptTMXPath;
    protected boolean extOptCopy = true;
    protected boolean extOptAltTrans = true;
    protected boolean mosesCopyToTarget = false;
    protected boolean mosesOverwriteTarget = false;
    protected boolean moses2Outputs = false;
    protected boolean mosesUseGModeInAltTrans = true;
    protected String mosesFromPath;
    protected String mosesToPath;
    protected String skeletonDir;
    protected String outputDir;
    private FilterConfigurationMapper fcMapper;
    private Hashtable<String, String> extensionsMap;
    private Hashtable<String, String> filtersMap;

    private static String getConsoleEncodingName() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Mac OS")) {
            return "UTF-8";
        }
        if (osName.startsWith("Windows")) {
            return "cp850";
        }
        return Charset.defaultCharset().name();
    }

    public static void main(String[] originalArgs) {
        Main prog = new Main();
        boolean showTrace = false;
        try {
            Handler[] handlers;
            ps = new PrintStream((OutputStream)System.out, true, Main.getConsoleEncodingName());
            for (Handler handler : handlers = Logger.getLogger("").getHandlers()) {
                Logger.getLogger("").removeHandler(handler);
            }
            LogHandler logHandler = new LogHandler(ps);
            logHandler.setLevel(Level.INFO);
            Logger.getLogger("").addHandler(logHandler);
            ArrayList<String> args = new ArrayList<String>();
            for (String tmp : originalArgs) {
                if (tmp.length() <= 0) continue;
                args.add(tmp);
            }
            prog.printBanner();
            if (args.size() == 0) {
                prog.printUsage();
                return;
            }
            if (args.contains("-?")) {
                prog.printUsage();
                return;
            }
            if (args.contains("-h") || args.contains("--help") || args.contains("-help")) {
                prog.showHelp();
                return;
            }
            if (args.contains("-i") || args.contains("--info") || args.contains("-info")) {
                prog.showInfo();
                return;
            }
            if (args.contains("-trace")) {
                showTrace = true;
            }
            for (int i = 0; i < args.size(); ++i) {
                String arg = (String)args.get(i);
                if (arg.equals("-fc")) {
                    prog.specifiedConfigId = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-sl")) {
                    prog.srcLoc = new LocaleId(prog.getArgument(args, ++i), true);
                    continue;
                }
                if (arg.equals("-tl")) {
                    prog.trgLoc = new LocaleId(prog.getArgument(args, ++i), true);
                    continue;
                }
                if (arg.equals("-ie")) {
                    prog.inputEncoding = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-oe")) {
                    prog.outputEncoding = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-od")) {
                    prog.outputDir = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-sd")) {
                    prog.skeletonDir = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-x")) {
                    prog.command = 0;
                    continue;
                }
                if (arg.equals("-xm")) {
                    prog.command = 9;
                    continue;
                }
                if (arg.equals("-2")) {
                    prog.moses2Outputs = true;
                    continue;
                }
                if (arg.equals("-t")) {
                    prog.command = 8;
                    continue;
                }
                if (arg.equals("-m")) {
                    prog.command = 1;
                    continue;
                }
                if (arg.equals("-lm")) {
                    prog.command = 10;
                    continue;
                }
                if (arg.equals("-totrg")) {
                    prog.mosesCopyToTarget = true;
                    prog.mosesOverwriteTarget = false;
                    continue;
                }
                if (arg.equals("-overtrg")) {
                    prog.mosesCopyToTarget = true;
                    prog.mosesOverwriteTarget = true;
                    continue;
                }
                if (arg.equals("-bpt")) {
                    prog.mosesUseGModeInAltTrans = false;
                    continue;
                }
                if (arg.equals("-over")) {
                    prog.convOverwrite = true;
                    continue;
                }
                if (arg.equals("-from")) {
                    prog.mosesFromPath = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-to")) {
                    prog.mosesToPath = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-2po")) {
                    prog.command = 4;
                    continue;
                }
                if (arg.equals("-2tmx")) {
                    prog.command = 5;
                    continue;
                }
                if (arg.equals("-2tbl")) {
                    prog.command = 6;
                    continue;
                }
                if (arg.equals("-csv")) {
                    prog.tableConvFormat = "csv";
                    continue;
                }
                if (arg.equals("-tab")) {
                    prog.tableConvFormat = "tab";
                    continue;
                }
                if (arg.equals("-xliff")) {
                    prog.tableConvCodes = "xliff";
                    continue;
                }
                if (arg.equals("-xliffgx")) {
                    prog.tableConvCodes = "xliffgx";
                    continue;
                }
                if (arg.equals("-tmx")) {
                    prog.tableConvCodes = "tmx";
                    continue;
                }
                if (arg.equals("-all")) {
                    prog.convSkipEntriesWithoutText = false;
                    continue;
                }
                if (arg.equals("-nofill")) {
                    prog.levOptFillTarget = false;
                    continue;
                }
                if (arg.equals("-nocopy")) {
                    prog.extOptCopy = false;
                    continue;
                }
                if (arg.equals("-noalttrans")) {
                    prog.extOptAltTrans = false;
                    continue;
                }
                if (arg.equals("-maketmx")) {
                    prog.levOptTMXPath = "pretrans.tmx";
                    if (args.size() <= i + 1 || args.get(i + 1).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.levOptTMXPath = args.get(++i);
                    continue;
                }
                if (arg.equals("-trgsource")) {
                    prog.convTargetStyle = 1;
                    continue;
                }
                if (arg.equals("-trgempty")) {
                    prog.convTargetStyle = 2;
                    continue;
                }
                if (arg.equals("-imp")) {
                    prog.command = 7;
                    prog.pensieveData = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-exp")) {
                    prog.command = 5;
                    prog.specifiedConfigId = "okf_pensieve";
                    continue;
                }
                if (arg.equals("-e")) {
                    prog.command = 2;
                    if (args.size() <= i + 1 || args.get(i + 1).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.specifiedConfigId = args.get(++i);
                    continue;
                }
                if (arg.equals("-generic")) {
                    prog.genericOutput = true;
                    prog.tableConvCodes = "generic";
                    continue;
                }
                if (arg.equals("-q")) {
                    prog.command = 3;
                    prog.query = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-a")) {
                    prog.command = 13;
                    prog.query = prog.getArgument(args, ++i);
                    prog.addTransTrans = prog.getArgument(args, ++i);
                    if (args.size() <= i + 1 || args.get(i + 1).startsWith(DEFAULT_SEGRULES)) continue;
                    try {
                        prog.addTransRating = Integer.parseInt(args.get(++i));
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException(String.format("Invalid rating option: '%s'.", args.get(i)));
                    }
                    if (prog.addTransRating >= -10 && prog.addTransRating <= 10) continue;
                    throw new RuntimeException("Rating must be between -10 and 10.");
                }
                if (arg.equals("-opt")) {
                    prog.tmOptions = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-gg") || arg.equals("-google")) {
                    prog.useGoogleV2 = true;
                    if (args.size() <= i + 1 || args.get(i + 1).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.googleV2Params = args.get(++i);
                    continue;
                }
                if (arg.equals("-opentran")) {
                    prog.useOpenTran = true;
                    continue;
                }
                if (arg.equals("-tt")) {
                    prog.useTransToolkit = true;
                    prog.transToolkitParams = "amagama.locamotion.org:80";
                    if (args.size() <= i + 1 || args.get(i + 1).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.transToolkitParams = args.get(++i);
                    continue;
                }
                if (arg.equals("-gs")) {
                    prog.useGlobalSight = true;
                    prog.globalSightParams = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-tda")) {
                    prog.useTDA = true;
                    prog.tdaParams = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-ms")) {
                    prog.useMicrosoft = true;
                    if (args.size() <= i + 1 || args.get(i + 1).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.microsoftParams = args.get(++i);
                    continue;
                }
                if (arg.equals("-apertium")) {
                    prog.useApertium = true;
                    if (args.size() <= i + 1 || args.get(i + 1).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.apertiumParams = args.get(++i);
                    continue;
                }
                if (arg.equals("-mm")) {
                    prog.useMyMemory = true;
                    if (args.size() <= i + 1 || args.get(i + 1).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.myMemoryParams = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-pen")) {
                    prog.usePensieve = true;
                    prog.pensieveData = "http://localhost:8080";
                    if (args.size() <= i + 1 || args.get(i + 1).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.pensieveData = args.get(++i);
                    continue;
                }
                if (arg.endsWith("-listconf") || arg.equals("-lfc")) {
                    prog.command = 12;
                    continue;
                }
                if (arg.equals("-s")) {
                    prog.command = 11;
                    prog.segRules = DEFAULT_SEGRULES;
                    continue;
                }
                if (arg.equals("-seg")) {
                    prog.segRules = DEFAULT_SEGRULES;
                    if (args.size() <= i + 1 || args.get(i + 1).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.segRules = args.get(++i);
                    continue;
                }
                if (arg.equals("-trace")) continue;
                if (!arg.startsWith(DEFAULT_SEGRULES)) {
                    prog.inputs.add(args.get(i));
                    continue;
                }
                prog.showTraceHint = false;
                throw new InvalidParameterException(String.format("Invalid command-line argument '%s'.", args.get(i)));
            }
            if (prog.specifiedConfigId != null) {
                String cfgPath = Util.getDirectoryName(prog.specifiedConfigId);
                if (!cfgPath.isEmpty()) {
                    prog.specifiedConfigIdPath = cfgPath;
                    prog.specifiedConfigId = Util.getFilename(prog.specifiedConfigId, true);
                }
                if (prog.specifiedConfigId.endsWith(".fprm")) {
                    prog.specifiedConfigId = Util.getFilename(prog.specifiedConfigId, false);
                }
            }
            if (prog.command == -1) {
                ps.println("No command specified. Please use one of the command described below:");
                prog.printUsage();
                return;
            }
            if (prog.command == 2) {
                if (prog.specifiedConfigId == null) {
                    prog.editAllConfigurations();
                } else {
                    prog.editConfiguration();
                }
                return;
            }
            if (prog.command == 12) {
                prog.showAllConfigurations();
                return;
            }
            if (prog.command == 3) {
                prog.processQuery();
                return;
            }
            if (prog.command == 13) {
                prog.processAddTranslation();
                return;
            }
            if (prog.inputs.size() == 0) {
                throw new RuntimeException("No input document specified.");
            }
            for (int i = 0; i < prog.inputs.size(); ++i) {
                if (i > 0) {
                    ps.println("------------------------------------------------------------");
                }
                prog.process(prog.inputs.get(i));
            }
        }
        catch (Throwable e) {
            if (showTrace) {
                e.printStackTrace();
            } else {
                ps.println("ERROR: " + e.getMessage());
                Throwable e2 = e.getCause();
                if (e2 != null) {
                    ps.println(e2.getMessage());
                }
                if (prog.showTraceHint) {
                    ps.println("You can use the -trace option for more details.");
                }
            }
            System.exit(1);
        }
    }

    protected String getArgument(ArrayList<String> args, int index) {
        if (index >= args.size()) {
            this.showTraceHint = false;
            throw new RuntimeException(String.format("Missing parameter after '%s'", args.get(index - 1)));
        }
        return args.get(index);
    }

    private void initialize() {
        this.fcMapper = new FilterConfigurationMapper();
        DefaultFilters.setMappings(this.fcMapper, false, false);
        this.extensionsMap = new Hashtable();
        this.filtersMap = new Hashtable();
        this.extensionsMap.put(".docx", "okf_openxml");
        this.extensionsMap.put(".pptx", "okf_openxml");
        this.extensionsMap.put(".xlsx", "okf_openxml");
        this.filtersMap.put("okf_openxml", "net.sf.okapi.filters.openxml.OpenXMLFilter");
        this.extensionsMap.put(".odt", "okf_openoffice");
        this.extensionsMap.put(".swx", "okf_openoffice");
        this.extensionsMap.put(".ods", "okf_openoffice");
        this.extensionsMap.put(".swc", "okf_openoffice");
        this.extensionsMap.put(".odp", "okf_openoffice");
        this.extensionsMap.put(".sxi", "okf_openoffice");
        this.extensionsMap.put(".odg", "okf_openoffice");
        this.extensionsMap.put(".sxd", "okf_openoffice");
        this.filtersMap.put("okf_openoffice", "net.sf.okapi.filters.openoffice.OpenOfficeFilter");
        this.extensionsMap.put(".htm", "okf_html");
        this.extensionsMap.put(".html", "okf_html");
        this.filtersMap.put("okf_html", "net.sf.okapi.filters.html.HtmlFilter");
        this.extensionsMap.put(".xlf", "okf_xliff");
        this.extensionsMap.put(".xlif", "okf_xliff");
        this.extensionsMap.put(".xliff", "okf_xliff");
        this.filtersMap.put("okf_xliff", "net.sf.okapi.filters.xliff.XLIFFFilter");
        this.extensionsMap.put(".tmx", "okf_tmx");
        this.filtersMap.put("okf_tmx", "net.sf.okapi.filters.tmx.TmxFilter");
        this.extensionsMap.put(".properties", "okf_properties");
        this.extensionsMap.put(".lang", "okf_properties-skypeLang");
        this.filtersMap.put("okf_properties", "net.sf.okapi.filters.properties.PropertiesFilter");
        this.extensionsMap.put(".po", "okf_po");
        this.filtersMap.put("okf_po", "net.sf.okapi.filters.po.POFilter");
        this.extensionsMap.put(".xml", "okf_xml");
        this.extensionsMap.put(".resx", "okf_xml-resx");
        this.filtersMap.put("okf_xml", "net.sf.okapi.filters.xml.XMLFilter");
        this.extensionsMap.put(".srt", "okf_regex-srt");
        this.filtersMap.put("okf_regex", "net.sf.okapi.filters.regex.RegexFilter");
        this.extensionsMap.put(".dtd", "okf_dtd");
        this.extensionsMap.put(".ent", "okf_dtd");
        this.filtersMap.put("okf_dtd", "net.sf.okapi.filters.dtd.DTDFilter");
        this.extensionsMap.put(".ts", "okf_ts");
        this.filtersMap.put("okf_ts", "net.sf.okapi.filters.ts.TsFilter");
        this.extensionsMap.put(".txt", "okf_plaintext");
        this.filtersMap.put("okf_plaintext", "net.sf.okapi.filters.plaintext.PlainTextFilter");
        this.extensionsMap.put(".csv", "okf_table_csv");
        this.filtersMap.put("okf_table", "net.sf.okapi.filters.table.TableFilter");
        this.extensionsMap.put(".ttx", "okf_ttx");
        this.filtersMap.put("okf_ttx", "net.sf.okapi.filters.ttx.TTXFilter");
        this.extensionsMap.put(".json", "okf_json");
        this.filtersMap.put("okf_json", "net.sf.okapi.filters.json.JSONFilter");
        this.filtersMap.put("okf_phpcontent", "net.sf.okapi.filters.php.PHPContentFilter");
        this.extensionsMap.put(".pentm", "okf_pensieve");
        this.filtersMap.put("okf_pensieve", "net.sf.okapi.filters.pensieve.PensieveFilter");
        this.filtersMap.put("okf_vignette", "net.sf.okapi.filters.vignette.VignetteFilter");
        this.extensionsMap.put(".yml", "okf_railsyaml");
        this.filtersMap.put("okf_railsyaml", "net.sf.okapi.filters.railsyaml.RailsYamlFilter");
        this.extensionsMap.put(".idml", "okf_idml");
        this.filtersMap.put("okf_idml", "net.sf.okapi.filters.idml.IDMLFilter");
        this.extensionsMap.put(".mif", "okf_mif");
        this.filtersMap.put("okf_mif", "net.sf.okapi.filters.mif.MIFFilter");
        this.extensionsMap.put(".txp", "okf_transifex");
        this.filtersMap.put("okf_transifex", "net.sf.okapi.filters.transifex.TransifexFilter");
        this.extensionsMap.put(".zip", "okf_archive");
        this.filtersMap.put("okf_archive", "net.sf.okapi.filters.archive.ArchiveFilter");
        this.extensionsMap.put(".txml", "okf_txml");
        this.filtersMap.put("okf_txml", "net.sf.okapi.filters.txml.TXMLFilter");
        this.filtersMap.put("okf_versifiedtxt", "net.sf.okapi.filters.versifiedtxt.VersifiedTextFilter");
        this.filtersMap.put("okf_xmlstream", "net.sf.okapi.filters.xmlstream.XmlStreamFilter");
        this.filtersMap.put("okf_mosestext", "net.sf.okapi.filters.mosestext.MosesTextFilter");
        if (this.specifiedConfigIdPath != null) {
            this.fcMapper.setCustomConfigurationsDirectory(this.specifiedConfigIdPath);
        }
    }

    private String getConfigurationId(String ext) {
        String id = this.extensionsMap.get(ext);
        if (id == null) {
            throw new RuntimeException(String.format("Could not guess the configuration for the extension '%s'", ext));
        }
        return id;
    }

    private void editAllConfigurations() {
        this.initialize();
        this.guessMissingLocales(null);
        DefaultFilters.setMappings(this.fcMapper, false, true);
        this.loadFromPluginsAndUpdate();
        this.fcMapper.updateCustomConfigurations();
        try {
            IFilterConfigurationListEditor editor = (IFilterConfigurationListEditor)Class.forName("net.sf.okapi.common.ui.filters.FilterConfigurationEditor").newInstance();
            editor.editConfigurations(this.fcMapper);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(MSG_ONLYWITHUICOMP);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(MSG_ONLYWITHUICOMP);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(MSG_ONLYWITHUICOMP);
        }
    }

    private void editConfiguration() {
        this.initialize();
        this.guessMissingLocales(null);
        if (this.specifiedConfigId == null) {
            throw new RuntimeException("You must specified the configuration to edit.");
        }
        this.configId = this.specifiedConfigId;
        if (!this.prepareFilter(this.configId)) {
            return;
        }
        try {
            IFilterConfigurationEditor editor = (IFilterConfigurationEditor)Class.forName("net.sf.okapi.common.ui.filters.FilterConfigurationEditor").newInstance();
            editor.editConfiguration(this.configId, this.fcMapper);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(MSG_ONLYWITHUICOMP);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(MSG_ONLYWITHUICOMP);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(MSG_ONLYWITHUICOMP);
        }
    }

    private void showAllConfigurations() {
        this.initialize();
        DefaultFilters.setMappings(this.fcMapper, true, true);
        this.loadFromPluginsAndUpdate();
        this.fcMapper.updateCustomConfigurations();
        ps.println("List of all filter configurations available:");
        Iterator<FilterConfiguration> iter = this.fcMapper.getAllConfigurations();
        while (iter.hasNext()) {
            FilterConfiguration config = iter.next();
            ps.println(String.format(" - %s = %s", config.configId, config.description));
        }
    }

    private boolean prepareFilter(String configId) {
        boolean pluginsDone = false;
        while (true) {
            if (this.filtersMap.containsKey(configId)) {
                this.fcMapper.addConfigurations(this.filtersMap.get(configId));
                if (configId.startsWith("okf_vignette") || configId.startsWith("okf_xmlstream")) {
                    this.fcMapper.addConfigurations(this.filtersMap.get("okf_html"));
                }
                return true;
            }
            for (String tmp : this.filtersMap.keySet()) {
                if (!configId.startsWith(tmp)) continue;
                this.fcMapper.addConfigurations(this.filtersMap.get(tmp));
                if (this.fcMapper.getConfiguration(configId) == null) {
                    this.fcMapper.addCustomConfiguration(configId);
                }
                return true;
            }
            if (pluginsDone) break;
            this.loadFromPluginsAndUpdate();
            pluginsDone = true;
        }
        ps.println(String.format("ERROR: Could not guess the filter for the configuration '%s'", configId));
        return false;
    }

    private void loadFromPluginsAndUpdate() {
        PluginsManager mgt = new PluginsManager();
        mgt.discover(new File(this.getAppRootDirectory() + File.separator + "dropins"), true);
        this.fcMapper.addFromPlugins(mgt);
        Iterator<FilterConfiguration> iter = this.fcMapper.getAllConfigurations();
        while (iter.hasNext()) {
            FilterConfiguration cfg = iter.next();
            if (this.filtersMap.containsKey(cfg.configId)) continue;
            this.filtersMap.put(cfg.configId, cfg.filterClass);
        }
    }

    private void guessMissingLocales(String inputPath) {
        List<String> guessed;
        if (this.srcLoc != null && this.trgLoc != null) {
            return;
        }
        if (inputPath != null && (guessed = FileUtil.guessLanguages(inputPath)).size() > 0) {
            if (this.srcLoc == null) {
                this.srcLoc = LocaleId.fromString(guessed.get(0));
            }
            if (guessed.size() > 1 && this.trgLoc == null) {
                this.trgLoc = LocaleId.fromString(guessed.get(1));
            }
        }
        if (this.srcLoc == null) {
            this.srcLoc = new LocaleId("en", false);
        }
        if (this.trgLoc == null) {
            this.trgLoc = new LocaleId(Locale.getDefault());
            if (this.trgLoc.sameLanguageAs(this.srcLoc)) {
                this.trgLoc = new LocaleId("fr", false);
            }
        }
    }

    private void guessMissingParameters(String inputOfConfig) {
        if (this.specifiedConfigId == null) {
            String ext = Util.getExtension(inputOfConfig);
            if (Util.isEmpty(ext)) {
                throw new RuntimeException(String.format("The input file '%s' has no extension to guess the filter from.", inputOfConfig));
            }
            this.configId = this.getConfigurationId(ext.toLowerCase());
        } else {
            this.configId = this.specifiedConfigId;
        }
        if (this.outputEncoding == null) {
            this.outputEncoding = this.inputEncoding != null ? this.inputEncoding : Charset.defaultCharset().name();
        }
        if (this.inputEncoding == null) {
            this.inputEncoding = Charset.defaultCharset().name();
        }
    }

    String pathChangeFolder(String newFolder, String oldPath) {
        String result;
        if (newFolder == null) {
            result = oldPath;
        } else {
            File file = new File(newFolder, Util.getFilename(oldPath, true));
            result = file.toString();
        }
        return result;
    }

    String pathInsertOutBeforeExt(String oldPath) {
        String ext = Util.getExtension(oldPath);
        int n = oldPath.lastIndexOf(46);
        return oldPath.substring(0, n) + ".out" + ext;
    }

    private void guessMergingArguments(String input) {
        String ext = Util.getExtension(input);
        if (!ext.equals(".xlf")) {
            throw new RuntimeException(String.format("The input file '%s' does not have the expected .xlf extension.", input));
        }
        int n = input.lastIndexOf(46);
        this.skeleton = input.substring(0, n);
        this.output = this.outputDir == null ? this.pathInsertOutBeforeExt(this.skeleton) : this.pathChangeFolder(this.outputDir, this.skeleton);
        this.skeleton = this.pathChangeFolder(this.skeletonDir, this.skeleton);
    }

    private void guessMergingMosesArguments(String input) {
        if (Util.isEmpty(this.mosesFromPath)) {
            this.mosesFromPath = input + "." + this.trgLoc.toString();
        }
        this.output = !Util.isEmpty(this.mosesToPath) ? this.mosesToPath : this.pathInsertOutBeforeExt(input);
    }

    protected void process(String input) throws URISyntaxException {
        this.initialize();
        switch (this.command) {
            case 8: {
                ps.println("Translation");
                this.guessMissingParameters(input);
                if (!this.prepareFilter(this.configId)) {
                    return;
                }
                this.guessMissingLocales(input);
                File file = new File(input);
                RawDocument rd = new RawDocument(file.toURI(), this.inputEncoding, this.srcLoc, this.trgLoc);
                rd.setFilterConfigId(this.configId);
                this.translateFile(rd);
                break;
            }
            case 11: {
                ps.println("Segmentation");
                this.guessMissingParameters(input);
                if (!this.prepareFilter(this.configId)) {
                    return;
                }
                this.guessMissingLocales(input);
                File file = new File(input);
                RawDocument rd = new RawDocument(file.toURI(), this.inputEncoding, this.srcLoc, this.trgLoc);
                rd.setFilterConfigId(this.configId);
                this.segmentFile(rd);
                break;
            }
            case 0: {
                ps.println("Extraction");
                this.guessMissingParameters(input);
                if (!this.prepareFilter(this.configId)) {
                    return;
                }
                this.guessMissingLocales(input);
                File file = new File(input);
                RawDocument rd = new RawDocument(file.toURI(), this.inputEncoding, this.srcLoc, this.trgLoc);
                rd.setFilterConfigId(this.configId);
                this.extractFile(rd);
                break;
            }
            case 9: {
                ps.println("Extraction to Moses InlineText");
                this.guessMissingParameters(input);
                if (!this.prepareFilter(this.configId)) {
                    return;
                }
                this.guessMissingLocales(input);
                File file = new File(input);
                RawDocument rd = new RawDocument(file.toURI(), this.inputEncoding, this.srcLoc, this.trgLoc);
                rd.setFilterConfigId(this.configId);
                this.extractFileToMoses(rd);
                break;
            }
            case 1: {
                ps.println("Merging");
                this.guessMergingArguments(input);
                this.guessMissingParameters(this.skeleton);
                if (!this.prepareFilter(this.configId)) {
                    return;
                }
                this.guessMissingLocales(input);
                XLIFFMergingStep stepMrg = new XLIFFMergingStep(this.fcMapper);
                File file = new File(this.skeleton);
                RawDocument skelRawDoc = new RawDocument(file.toURI(), this.inputEncoding, this.srcLoc, this.trgLoc);
                skelRawDoc.setFilterConfigId(this.configId);
                stepMrg.setXliffPath(input);
                stepMrg.setOutputPath(this.output);
                stepMrg.setOutputEncoding(this.outputEncoding);
                ps.println("Source language: " + this.srcLoc);
                ps.println("Target language: " + this.trgLoc);
                ps.println("Default input encoding: " + this.inputEncoding);
                ps.println("Output encoding: " + this.outputEncoding);
                ps.println("Filter configuration: " + this.configId);
                ps.println("XLIFF: " + input);
                ps.println(String.format("Output: %s", this.output == null ? "<auto-defined>" : this.output));
                stepMrg.handleRawDocument(skelRawDoc);
                break;
            }
            case 10: {
                ps.println("Merging Moses InlineText");
                this.guessMissingLocales(input);
                this.guessMergingMosesArguments(input);
                this.guessMissingParameters(input);
                if (!this.prepareFilter(this.configId)) {
                    return;
                }
                File file = new File(input);
                RawDocument rd = new RawDocument(file.toURI(), this.inputEncoding, this.srcLoc, this.trgLoc, this.configId);
                this.leverageFileWithMoses(rd);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                if (this.command == 4) {
                    ps.println("Conversion to PO");
                } else if (this.command == 5) {
                    ps.println("Conversion to TMX");
                } else if (this.command == 6) {
                    ps.println("Conversion to Table");
                } else {
                    ps.println("Importing to Pensieve TM");
                }
                this.guessMissingParameters(input);
                if (!this.prepareFilter(this.configId)) {
                    return;
                }
                this.guessMissingLocales(input);
                File file = new File(input);
                String output = input;
                output = this.command == 4 ? output + ".po" : (this.command == 5 ? output + ".tmx" : (this.command == 6 ? output + ".txt" : this.checkPensieveDirExtension()));
                URI outputURI = new File(output).toURI();
                RawDocument rd = new RawDocument(file.toURI(), this.inputEncoding, this.srcLoc, this.trgLoc);
                rd.setFilterConfigId(this.configId);
                ps.println("Source language: " + this.srcLoc);
                ps.println("Target language: " + this.trgLoc);
                ps.println("Default input encoding: " + this.inputEncoding);
                ps.println("Filter configuration: " + this.configId);
                ps.println("Output: " + output);
                this.convertFile(rd, outputURI);
            }
        }
        ps.println("Done");
    }

    private void printBanner() {
        ps.println("-------------------------------------------------------------------------------");
        ps.println("Okapi Tikal - Localization Toolset");
        ps.println(String.format("Version: %s", this.getClass().getPackage().getImplementationVersion()));
        ps.println("-------------------------------------------------------------------------------");
    }

    private void showInfo() {
        Runtime rt = Runtime.getRuntime();
        rt.runFinalization();
        rt.gc();
        ps.println("Java version: " + System.getProperty("java.version"));
        ps.println(String.format("Platform: %s, %s, %s", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version")));
        NumberFormat nf = NumberFormat.getInstance();
        ps.println(String.format("Java VM memory: free=%s KB, total=%s KB", nf.format(rt.freeMemory() / 1024L), nf.format(rt.totalMemory() / 1024L)));
        ps.println("-------------------------------------------------------------------------------");
    }

    private String getAppRootDirectory() {
        try {
            URL url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            String path = new File(url.toURI()).getCanonicalPath();
            return Util.getDirectoryName(Util.getDirectoryName(path));
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        catch (URISyntaxException e) {
            throw new OkapiIOException("Bad URI syntax.", e);
        }
    }

    private void showHelp() throws MalformedURLException {
        Util.openWikiTopic("Tikal");
    }

    private void printUsage() {
        ps.println("Shows this screen: -?");
        ps.println("Shows version and other information: -i or --info");
        ps.println("Opens the user guide page: -h or --help");
        ps.println("Lists all available filter configurations: -lfc or --listconf");
        ps.println("Edits or view filter configurations (UI-dependent command):");
        ps.println("   -e [[-fc] configId]");
        ps.println("Extracts a file to XLIFF (and optionally segment and pre-translate):");
        ps.println("   -x inputFile [inputFile2...] [-fc configId] [-ie encoding] [-sl srcLang]");
        ps.println("      [-tl trgLang] [-seg [srxFile]] [-tt [hostname[:port]]|-mm [key]");
        ps.println("      |-pen tmDirectory|-gs configFile|-apertium [configFile]");
        ps.println("      |-ms configFile|-tda configFile|-gg configFile]");
        ps.println("      [-maketmx [tmxFile]] [-opt threshold]");
        ps.println("      [-od outputDirectory] [-nocopy] [-noalttrans]");
        ps.println("Merges an XLIFF document back to its original format:");
        ps.println("   -m xliffFile [xliffFile2...] [-fc configId] [-ie encoding] [-oe encoding]");
        ps.println("      [-sd sourceDirectory] [-od outputDirectory]");
        ps.println("      [-sl srcLang] [-tl trgLang]");
        ps.println("Translates a file:");
        ps.println("   -t inputFile [inputFile2...] [-fc configId] [-ie encoding] [-oe encoding]");
        ps.println("      [-sl srcLang] [-tl trgLang] [-seg [srxFile]] [-tt [hostname[:port]]");
        ps.println("      |-mm [key]|-pen tmDirectory|-gs configFile|-apertium [configFile]");
        ps.println("      |-ms configFile|-tda configFile|-gg configFile]");
        ps.println("      [-maketmx [tmxFile]] [-opt threshold]");
        ps.println("Extracts a file to Moses InlineText:");
        ps.println("   -xm inputFile [-fc configId] [-ie encoding] [-seg [srxFile]]");
        ps.println("      [-sl srcLang] [-tl trgLang] [-2] [-to srcOutputFile]");
        ps.println("Leverages a file with Moses InlineText:");
        ps.println("   -lm inputFile [-fc configId] [-ie encoding] [-oe encoding] [-sl srcLang]");
        ps.println("      [-tl trgLang] [-seg [srxFile]] [-totrg|-overtrg] [-bpt]");
        ps.println("      [-from mosesFile] [-to outputFile]");
        ps.println("Segments a file:");
        ps.println("   -s inputFile [-fc configId] [-ie encoding]");
        ps.println("      [-sl srcLang] [-tl trgLang] [-seg [srxFile]]");
        ps.println("Queries translation resources:");
        ps.println("   -q \"source text\" [-sl srcLang] [-tl trgLang] [-opentran]");
        ps.println("      [-tt [hostname[:port]]] [-mm [key]] [-pen tmDirectory] [-gs configFile]");
        ps.println("      [-apertium [configFile]] [-ms configFile] [-tda configFile]");
        ps.println("      [-gg configFile] [-opt threshold[:maxhits]]");
        ps.println("Adds translation to a resources:");
        ps.println("   -a \"source text\" \"target text\" [rating] [-sl srcLang] [-tl trgLang]");
        ps.println("      -ms configFile");
        ps.println("Converts to PO format:");
        ps.println("   -2po inputFile [inputFile2...] [-fc configId] [-ie encoding] [-all]");
        ps.println("      [-sl srcLang] [-tl trgLang] [-generic] [-trgsource|-trgempty]");
        ps.println("Converts to TMX format:");
        ps.println("   -2tmx inputFile [inputFile2...] [-fc configId] [-ie encoding]");
        ps.println("      [-sl srcLang] [-tl trgLang] [-trgsource|-trgempty] [-all]");
        ps.println("Converts to table format:");
        ps.println("   -2tbl inputFile [inputFile2...] [-fc configId] [-ie encoding]");
        ps.println("      [-sl srcLang] [-tl trgLang] [-trgsource|-trgempty]");
        ps.println("      [-csv|-tab] [-xliff|-xliffgx|-tmx|-generic] [-all]");
        ps.println("Imports to Pensieve TM:");
        ps.println("   -imp tmDirectory inputFile [inputFile2...] [-fc configId] [-ie encoding]");
        ps.println("      [-sl srcLang] [-tl trgLang] [-trgsource|-trgempty] [-all] [-over]");
        ps.println("Exports Pensieve TM as TMX:");
        ps.println("   -exp tmDirectory1 [tmDirectory2...] [-sl srcLang] [-tl trgLang]");
        ps.println("      [-trgsource|-trgempty] [-all]");
    }

    private void displayQuery(IQuery conn, boolean isTM) {
        int count = conn.getClass().getName().endsWith("PensieveTMConnector") || conn.getClass().getName().endsWith("GoogleMTConnector") || conn.getClass().getName().endsWith("GoogleMTv2Connector") || conn.getClass().getName().endsWith("MyMemoryTMConnector") || conn.getClass().getName().endsWith("MicrosoftMTConnector") || conn.getClass().getName().endsWith("GlobalSightTMConnector") ? conn.query(this.parseToTextFragment(this.query)) : conn.query(this.query);
        ps.println(String.format("\n= From %s (%s->%s)", conn.getName(), conn.getSourceLanguage(), conn.getTargetLanguage()));
        if (isTM) {
            ITMQuery tmConn = (ITMQuery)conn;
            ps.println(String.format("  Threshold=%d, Maximum hits=%d", tmConn.getThreshold(), tmConn.getMaximumHits()));
        }
        if (count > 0) {
            while (conn.hasNext()) {
                QueryResult qr = conn.next();
                ps.println(String.format("score: %d, origin: '%s'%s", qr.getCombinedScore(), qr.origin == null ? "" : qr.origin, qr.fromMT() ? " (from MT)" : ""));
                ps.println(String.format("  Source: \"%s\"", qr.source.toText()));
                ps.println(String.format("  Target: \"%s\"", qr.target.toText()));
            }
        } else {
            ps.println(String.format("  Source: \"%s\"", this.query));
            ps.println("  <No translation has been found>");
        }
    }

    private void processAddTranslation() {
        MicrosoftMTConnector conn;
        this.guessMissingLocales(null);
        if (Util.isEmpty(this.query)) {
            throw new RuntimeException(String.format("Cannot add empty source text.", new Object[0]));
        }
        if (Util.isEmpty(this.addTransTrans)) {
            throw new RuntimeException(String.format("Cannot add empty target text.", new Object[0]));
        }
        if (this.useMicrosoft) {
            conn = new MicrosoftMTConnector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            conn.open();
            int res = conn.addTranslation(this.parseToTextFragment(this.query), this.parseToTextFragment(this.addTransTrans), this.addTransRating);
            if (res == 200) {
                ps.println("Done");
            } else {
                ps.println(String.format("Error code %d.", res));
            }
        } else {
            throw new RuntimeException(String.format("No valid connector specified to add a translation.", new Object[0]));
        }
        conn.close();
    }

    private void processQuery() {
        BaseConnector conn;
        this.guessMissingLocales(null);
        if (!(this.useGoogleV2 || this.useOpenTran || this.useTransToolkit || this.useMyMemory || this.usePensieve || this.useGlobalSight || this.useApertium || this.useMicrosoft || this.useTDA)) {
            this.useOpenTran = true;
        }
        int[] opt = this.parseTMOptions();
        int threshold = opt[0];
        int maxhits = opt[1];
        if (this.useGoogleV2) {
            conn = new GoogleMTv2Connector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            conn.open();
            this.displayQuery(conn, false);
            conn.close();
        }
        if (this.usePensieve) {
            conn = new PensieveTMConnector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            this.setTMOptionsIfPossible(conn, threshold, maxhits);
            conn.open();
            this.displayQuery(conn, true);
            conn.close();
        }
        if (this.useTransToolkit) {
            conn = new TranslateToolkitTMConnector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            this.setTMOptionsIfPossible(conn, threshold, maxhits);
            conn.open();
            this.displayQuery(conn, true);
            conn.close();
        }
        if (this.useGlobalSight) {
            conn = new GlobalSightTMConnector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            this.setTMOptionsIfPossible(conn, threshold, maxhits);
            conn.open();
            this.displayQuery(conn, true);
            conn.close();
        }
        if (this.useTDA) {
            conn = new TDASearchConnector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            this.setTMOptionsIfPossible(conn, threshold, maxhits);
            conn.open();
            this.displayQuery(conn, true);
            conn.close();
        }
        if (this.useMicrosoft) {
            conn = new MicrosoftMTConnector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            this.setTMOptionsIfPossible(conn, threshold, maxhits);
            conn.open();
            this.displayQuery(conn, true);
            conn.close();
        }
        if (this.useMyMemory) {
            conn = new MyMemoryTMConnector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            this.setTMOptionsIfPossible(conn, threshold, maxhits);
            conn.open();
            this.displayQuery(conn, true);
            conn.close();
        }
        if (this.useApertium) {
            conn = new ApertiumMTConnector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            conn.open();
            this.displayQuery(conn, false);
            conn.close();
        }
        if (this.useOpenTran) {
            conn = new OpenTranTMConnector();
            conn.setLanguages(this.srcLoc, this.trgLoc);
            this.setTMOptionsIfPossible(conn, threshold, maxhits);
            conn.open();
            this.displayQuery(conn, true);
            conn.close();
        }
    }

    private int[] parseTMOptions() {
        int[] opt = new int[]{-1, -1};
        if (!Util.isEmpty(this.tmOptions)) {
            try {
                int n = this.tmOptions.indexOf(58);
                if (n == -1) {
                    opt[0] = Integer.parseInt(this.tmOptions);
                } else {
                    opt[0] = Integer.parseInt(this.tmOptions.substring(0, n));
                    opt[1] = Integer.parseInt(this.tmOptions.substring(n + 1));
                    if (opt[1] < 0) {
                        throw new RuntimeException(String.format("Invalid TM options: '%s' Maximum hits must be more than 0.", this.tmOptions));
                    }
                }
                if (opt[0] < 0 || opt[0] > 100) {
                    throw new RuntimeException(String.format("Invalid TM options: '%s' Thresold must be between 0 and 100.", this.tmOptions));
                }
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(String.format("Invalid TM options: '%s'", this.tmOptions));
            }
        }
        return opt;
    }

    private void setTMOptionsIfPossible(IQuery conn, int threshold, int maxhits) {
        ITMQuery tmConn = (ITMQuery)conn;
        if (threshold > -1) {
            tmConn.setThreshold(threshold);
        }
        if (maxhits > -1) {
            tmConn.setMaximumHits(maxhits);
        }
    }

    private void convertFile(RawDocument rd, URI outputURI) {
        PipelineDriver driver = new PipelineDriver();
        driver.setFilterConfigurationMapper(this.fcMapper);
        driver.setRootDirectories(System.getProperty("user.dir"), Util.getDirectoryName(rd.getInputURI().getPath()));
        RawDocumentToFilterEventsStep rd2feStep = new RawDocumentToFilterEventsStep();
        driver.addStep(rd2feStep);
        FormatConversionStep fcStep = new FormatConversionStep();
        net.sf.okapi.steps.formatconversion.Parameters params = fcStep.getParameters();
        if (this.command == 4) {
            params.setOutputFormat("po");
            params.setOutputPath("output.po");
        } else if (this.command == 5) {
            params.setOutputFormat("tmx");
            params.setOutputPath("output.tmx");
        } else if (this.command == 6) {
            params.setOutputFormat("table");
            TableFilterWriterParameters opt = new TableFilterWriterParameters();
            opt.fromArguments(this.tableConvFormat, this.tableConvCodes);
            params.setFormatOptions(opt.toString());
            params.setOutputPath("output.txt");
        } else if (this.command == 7) {
            params.setOutputFormat("pensieve");
            params.setOutputPath(this.checkPensieveDirExtension());
        }
        params.setSingleOutput(this.command == 7);
        params.setUseGenericCodes(this.genericOutput);
        params.setTargetStyle(this.convTargetStyle);
        params.setSkipEntriesWithoutText(this.convSkipEntriesWithoutText);
        params.setOverwriteSameSource(this.convOverwrite);
        driver.addStep(fcStep);
        driver.addBatchItem(rd, outputURI, this.outputEncoding);
        driver.processBatch();
    }

    private IPipelineStep addSegmentationStep() {
        if (this.segRules.equals(DEFAULT_SEGRULES)) {
            this.segRules = this.getAppRootDirectory();
            this.segRules = this.segRules + File.separator + "config" + File.separator + "defaultSegmentation.srx";
        } else if (Util.isEmpty(Util.getExtension(this.segRules))) {
            this.segRules = this.segRules + ".srx";
        }
        SegmentationStep segStep = new SegmentationStep();
        net.sf.okapi.steps.segmentation.Parameters segParams = (net.sf.okapi.steps.segmentation.Parameters)segStep.getParameters();
        segParams.segmentSource = true;
        segParams.segmentTarget = true;
        File f = new File(this.segRules);
        segParams.setSourceSrxPath(f.getAbsolutePath());
        segParams.setTargetSrxPath(f.getAbsolutePath());
        ps.println("Segmentation: " + f.getAbsolutePath());
        return segStep;
    }

    private IPipelineStep addLeveragingStep() {
        LeveragingStep levStep = new LeveragingStep();
        net.sf.okapi.steps.leveraging.Parameters levParams = (net.sf.okapi.steps.leveraging.Parameters)levStep.getParameters();
        if (this.usePensieve) {
            levParams.setResourceClassName(PensieveTMConnector.class.getName());
        } else if (this.useTransToolkit) {
            levParams.setResourceClassName(TranslateToolkitTMConnector.class.getName());
        } else if (this.useMyMemory) {
            levParams.setResourceClassName(MyMemoryTMConnector.class.getName());
        } else if (this.useGoogleV2) {
            levParams.setResourceClassName(GoogleMTv2Connector.class.getName());
        } else if (this.useGlobalSight) {
            levParams.setResourceClassName(GlobalSightTMConnector.class.getName());
        } else if (this.useTDA) {
            levParams.setResourceClassName(TDASearchConnector.class.getName());
        } else if (this.useMicrosoft) {
            levParams.setResourceClassName(MicrosoftMTConnector.class.getName());
        } else if (this.useApertium) {
            levParams.setResourceClassName(ApertiumMTConnector.class.getName());
        }
        IParameters p = this.prepareConnectorParameters(levParams.getResourceClassName());
        if (p != null) {
            levParams.setResourceParameters(((Object)p).toString());
        }
        levParams.setFillTarget(this.levOptFillTarget);
        int[] opt = this.parseTMOptions();
        if (opt[0] > -1) {
            levParams.setThreshold(opt[0]);
        }
        if (this.levOptTMXPath != null) {
            levParams.setMakeTMX(true);
            levParams.setTMXPath(this.levOptTMXPath);
        }
        return levStep;
    }

    private void extractFile(RawDocument rd) throws URISyntaxException {
        PipelineDriver driver = new PipelineDriver();
        driver.setFilterConfigurationMapper(this.fcMapper);
        driver.setRootDirectories(System.getProperty("user.dir"), Util.getDirectoryName(rd.getInputURI().getPath()));
        RawDocumentToFilterEventsStep rd2feStep = new RawDocumentToFilterEventsStep();
        driver.addStep(rd2feStep);
        if (this.segRules != null) {
            driver.addStep(this.addSegmentationStep());
        }
        if (this.useGoogleV2 || this.useTransToolkit || this.useMyMemory || this.usePensieve || this.useGlobalSight || this.useApertium || this.useMicrosoft || this.useTDA) {
            driver.addStep(this.addLeveragingStep());
        }
        FilterEventsWriterStep fewStep = new FilterEventsWriterStep();
        XLIFFWriter writer = new XLIFFWriter();
        writer.setCopySource(this.extOptCopy);
        writer.setIncludeAltTrans(this.extOptAltTrans);
        fewStep.setFilterWriter(writer);
        fewStep.setDocumentRoots(System.getProperty("user.dir"));
        driver.addStep(fewStep);
        String tmp = rd.getInputURI().getPath();
        if (tmp.endsWith("/") || tmp.endsWith("\\")) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        tmp = tmp + ".xlf";
        tmp = this.pathChangeFolder(this.outputDir, tmp);
        driver.addBatchItem(rd, new File(tmp).toURI(), this.outputEncoding);
        ps.println("Source language: " + this.srcLoc);
        ps.println("Target language: " + this.trgLoc);
        ps.println("Default input encoding: " + this.inputEncoding);
        ps.println("Filter configuration: " + this.configId);
        ps.println("Output: " + tmp);
        driver.processBatch();
    }

    private void segmentFile(RawDocument rd) throws URISyntaxException {
        PipelineDriver driver = new PipelineDriver();
        driver.setFilterConfigurationMapper(this.fcMapper);
        driver.setRootDirectories(System.getProperty("user.dir"), Util.getDirectoryName(rd.getInputURI().getPath()));
        RawDocumentToFilterEventsStep rd2feStep = new RawDocumentToFilterEventsStep();
        driver.addStep(rd2feStep);
        driver.addStep(this.addSegmentationStep());
        FilterEventsToRawDocumentStep ferdStep = new FilterEventsToRawDocumentStep();
        driver.addStep(ferdStep);
        String tmp = rd.getInputURI().getPath();
        this.output = this.pathInsertOutBeforeExt(tmp);
        ps.println("Source language: " + this.srcLoc);
        ps.println("Target language: " + this.trgLoc);
        ps.println("Default input encoding: " + this.inputEncoding);
        ps.println("Output encoding: " + this.outputEncoding);
        ps.println("Filter configuration: " + this.configId);
        ps.println("Output: " + this.output);
        driver.addBatchItem(rd, new File(this.output).toURI(), this.outputEncoding);
        driver.processBatch();
    }

    private void leverageFileWithMoses(RawDocument rd) {
        PipelineDriver driver = new PipelineDriver();
        driver.setFilterConfigurationMapper(this.fcMapper);
        driver.setRootDirectories(System.getProperty("user.dir"), Util.getDirectoryName(rd.getInputURI().getPath()));
        driver.addStep(new RawDocumentToFilterEventsStep());
        if (this.segRules != null) {
            driver.addStep(this.addSegmentationStep());
        }
        MergingStep mrgStep = new MergingStep();
        MergingParameters params = (MergingParameters)mrgStep.getParameters();
        params.setCopyToTarget(this.mosesCopyToTarget);
        params.setOverwriteExistingTarget(this.mosesOverwriteTarget);
        params.setForceAltTransOutput(true);
        params.setUseGModeInAltTrans(this.mosesUseGModeInAltTrans);
        driver.addStep(mrgStep);
        driver.addStep(new FilterEventsToRawDocumentStep());
        RawDocument rdMoses = new RawDocument(new File(this.mosesFromPath).toURI(), "UTF-8", this.trgLoc);
        driver.addBatchItem(new BatchItemContext(rd, new File(this.output).toURI(), this.outputEncoding, rdMoses));
        driver.processBatch();
    }

    private void extractFileToMoses(RawDocument rd) throws URISyntaxException {
        PipelineDriver driver = new PipelineDriver();
        driver.setFilterConfigurationMapper(this.fcMapper);
        driver.setRootDirectories(System.getProperty("user.dir"), Util.getDirectoryName(rd.getInputURI().getPath()));
        RawDocumentToFilterEventsStep rd2feStep = new RawDocumentToFilterEventsStep();
        driver.addStep(rd2feStep);
        if (this.segRules != null) {
            driver.addStep(this.addSegmentationStep());
        }
        ExtractionStep extStep = new ExtractionStep();
        if (this.moses2Outputs) {
            FilterWriterParameters p = (FilterWriterParameters)extStep.getParameters();
            p.setSourceAndTarget(true);
        }
        driver.addStep(extStep);
        if (Util.isEmpty(this.mosesToPath)) {
            this.mosesToPath = rd.getInputURI().getPath();
        }
        if (!this.mosesToPath.endsWith("." + this.srcLoc.toString())) {
            this.mosesToPath = this.mosesToPath + "." + this.srcLoc.toString();
        }
        driver.addBatchItem(rd, new File(this.mosesToPath).toURI(), "UTF-8");
        ps.println("Source language: " + this.srcLoc);
        if (this.moses2Outputs) {
            ps.println("Target language: " + this.trgLoc);
        }
        ps.println("Default input encoding: " + this.inputEncoding);
        ps.println("Filter configuration: " + this.configId);
        driver.processBatch();
    }

    private void translateFile(RawDocument rd) throws URISyntaxException {
        PipelineDriver driver = new PipelineDriver();
        driver.setFilterConfigurationMapper(this.fcMapper);
        driver.setRootDirectories(System.getProperty("user.dir"), Util.getDirectoryName(rd.getInputURI().getPath()));
        RawDocumentToFilterEventsStep rd2feStep = new RawDocumentToFilterEventsStep();
        driver.addStep(rd2feStep);
        if (this.segRules != null) {
            driver.addStep(this.addSegmentationStep());
        }
        if (this.useGoogleV2 || this.useTransToolkit || this.useMyMemory || this.usePensieve || this.useGlobalSight || this.useApertium || this.useMicrosoft || this.useTDA) {
            driver.addStep(this.addLeveragingStep());
        } else {
            ps.println("No valid translation resource has been specified: The text will not be modified.");
        }
        FilterEventsToRawDocumentStep ferdStep = new FilterEventsToRawDocumentStep();
        driver.addStep(ferdStep);
        String tmp = rd.getInputURI().getPath();
        this.output = this.pathInsertOutBeforeExt(tmp);
        ps.println("Source language: " + this.srcLoc);
        ps.println("Target language: " + this.trgLoc);
        ps.println("Default input encoding: " + this.inputEncoding);
        ps.println("Output encoding: " + this.outputEncoding);
        ps.println("Filter configuration: " + this.configId);
        ps.println("Output: " + this.output);
        driver.addBatchItem(rd, new File(this.output).toURI(), this.outputEncoding);
        driver.processBatch();
    }

    private String checkPensieveDirExtension() {
        String ext = Util.getExtension(this.pensieveData);
        if (Util.isEmpty(ext)) {
            this.pensieveData = this.pensieveData + ".pentm";
        }
        return this.pensieveData;
    }

    private IParameters prepareConnectorParameters(String connectorClassName) {
        if (connectorClassName.equals(PensieveTMConnector.class.getName())) {
            net.sf.okapi.connectors.pensieve.Parameters params = new net.sf.okapi.connectors.pensieve.Parameters();
            if (this.pensieveData.startsWith("http:")) {
                params.setHost(this.pensieveData);
                params.setUseServer(true);
            } else {
                params.setDbDirectory(this.checkPensieveDirExtension());
            }
            return params;
        }
        if (connectorClassName.equals(TranslateToolkitTMConnector.class.getName())) {
            net.sf.okapi.connectors.translatetoolkit.Parameters params = new net.sf.okapi.connectors.translatetoolkit.Parameters();
            int n = this.transToolkitParams.lastIndexOf(58);
            if (n == -1) {
                params.setHost(this.transToolkitParams);
            } else {
                params.setPort(Integer.valueOf(this.transToolkitParams.substring(n + 1)));
                params.setHost(this.transToolkitParams.substring(0, n));
            }
            return params;
        }
        if (connectorClassName.equals(MyMemoryTMConnector.class.getName())) {
            net.sf.okapi.connectors.mymemory.Parameters params = new net.sf.okapi.connectors.mymemory.Parameters();
            params.setKey(this.myMemoryParams);
            return params;
        }
        if (connectorClassName.equals(GlobalSightTMConnector.class.getName())) {
            Parameters params = new Parameters();
            URI paramURI = new File(this.globalSightParams).toURI();
            params.load(paramURI, false);
            return params;
        }
        if (connectorClassName.equals(TDASearchConnector.class.getName())) {
            net.sf.okapi.connectors.tda.Parameters params = new net.sf.okapi.connectors.tda.Parameters();
            URI paramURI = new File(this.tdaParams).toURI();
            params.load(paramURI, false);
            return params;
        }
        if (connectorClassName.equals(MicrosoftMTConnector.class.getName())) {
            net.sf.okapi.connectors.microsoft.Parameters params = new net.sf.okapi.connectors.microsoft.Parameters();
            if (this.microsoftParams != null) {
                URI paramURI = new File(this.microsoftParams).toURI();
                params.load(paramURI, false);
            }
            return params;
        }
        if (connectorClassName.equals(GoogleMTv2Connector.class.getName())) {
            GoogleMTv2Parameters params = new GoogleMTv2Parameters();
            if (this.googleV2Params != null) {
                URI paramURI = new File(this.googleV2Params).toURI();
                params.load(paramURI, false);
            }
            return params;
        }
        if (connectorClassName.equals(ApertiumMTConnector.class.getName())) {
            net.sf.okapi.connectors.apertium.Parameters params = new net.sf.okapi.connectors.apertium.Parameters();
            if (this.apertiumParams != null) {
                URI paramURI = new File(this.apertiumParams).toURI();
                params.load(paramURI, false);
            }
            return params;
        }
        return null;
    }

    public TextFragment parseToTextFragment(String text) {
        int n;
        Pattern patternOpening = Pattern.compile("\\<(\\w+)[ ]*[^\\>/]*\\>");
        Pattern patternClosing = Pattern.compile("\\</(\\w+)[ ]*[^\\>]*\\>");
        Pattern patternPlaceholder = Pattern.compile("\\<(\\w+)[ ]*[^\\>]*/\\>");
        TextFragment tf = new TextFragment();
        tf.setCodedText(text);
        int start = 0;
        int diff = 0;
        Matcher m = patternOpening.matcher(text);
        while (m.find(start)) {
            n = m.start();
            diff += tf.changeToCode(n + diff, n + diff + m.group().length(), TextFragment.TagType.OPENING, m.group(1));
            start = n + m.group().length();
        }
        text = tf.getCodedText();
        diff = 0;
        start = 0;
        m = patternClosing.matcher(text);
        while (m.find(start)) {
            n = m.start();
            diff += tf.changeToCode(n + diff, n + diff + m.group().length(), TextFragment.TagType.CLOSING, m.group(1));
            start = n + m.group().length();
        }
        text = tf.getCodedText();
        diff = 0;
        start = 0;
        m = patternPlaceholder.matcher(text);
        while (m.find(start)) {
            n = m.start();
            diff += tf.changeToCode(n + diff, n + diff + m.group().length(), TextFragment.TagType.PLACEHOLDER, null);
            start = n + m.group().length();
        }
        return tf;
    }
}

