/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.annotation.IAnnotation;

public class BaseContext
implements IContext {
    private Map<String, Object> properties;
    private Annotations annotations;

    public BaseContext() {
    }

    public BaseContext(Map<String, Object> properties) {
        this.properties = new LinkedHashMap<String, Object>(properties);
    }

    @Override
    public String getString(String name) {
        if (this.properties == null) {
            return null;
        }
        return (String)this.properties.get(name);
    }

    @Override
    public void setString(String name, String value) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Object>();
        }
        this.properties.put(name, value);
    }

    @Override
    public boolean getBoolean(String name) {
        if (this.properties == null) {
            return false;
        }
        return (Boolean)this.properties.get(name);
    }

    @Override
    public void setBoolean(String name, boolean value) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Object>();
        }
        this.properties.put(name, value);
    }

    @Override
    public int getInteger(String name) {
        if (this.properties == null) {
            return 0;
        }
        return (Integer)this.properties.get(name);
    }

    @Override
    public void setInteger(String name, int value) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Object>();
        }
        this.properties.put(name, value);
    }

    @Override
    public Object getObject(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    @Override
    public void setObject(String name, Object value) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Object>();
        }
        this.properties.put(name, value);
    }

    @Override
    public void removeProperty(String name) {
        if (this.properties != null) {
            this.properties.remove(name);
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Object>();
        }
        return this.properties;
    }

    @Override
    public void clearProperties() {
        if (this.properties != null) {
            this.properties.clear();
        }
    }

    @Override
    public <A> A getAnnotation(Class<? extends IAnnotation> type) {
        if (this.annotations == null) {
            return null;
        }
        return (A)this.annotations.get(type);
    }

    @Override
    public void setAnnotation(IAnnotation annotation) {
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
        this.annotations.set(annotation);
    }

    @Override
    public void clearAnnotations() {
        if (this.annotations != null) {
            this.annotations.clear();
        }
    }
}

