/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.ListSelectionPart;
import net.sf.okapi.common.uidescription.PathInputPart;
import net.sf.okapi.common.uidescription.TextInputPart;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UIDescriptionTest {
    private TestClass ts;
    private ParametersDescription desc;

    @Before
    public void setUp() throws Exception {
        this.ts = new TestClass();
        this.desc = new ParametersDescription(this.ts);
        this.desc.add("text", "displayName", "shortDescription");
        this.desc.add("flag", "Flag", "A flag");
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testCheckboxPart() {
        CheckboxPart part = new CheckboxPart(this.desc.get("flag"));
        Assert.assertEquals((Object)"flag", (Object)part.getName());
        Assert.assertEquals((Object)"Flag", (Object)part.getDisplayName());
        Assert.assertEquals((Object)"A flag", (Object)part.getShortDescription());
        part = new CheckboxPart(this.desc.get("text"));
        Assert.assertEquals((Object)"text", (Object)part.getName());
        Assert.assertEquals((Object)"displayName", (Object)part.getDisplayName());
        Assert.assertEquals((Object)"shortDescription", (Object)part.getShortDescription());
    }

    @Test
    public void testTextInputPart() {
        TextInputPart part = new TextInputPart(this.desc.get("text"));
        part.setPassword(true);
        Assert.assertEquals((Object)"text", (Object)part.getName());
        Assert.assertEquals((Object)"displayName", (Object)part.getDisplayName());
        Assert.assertEquals((Object)"shortDescription", (Object)part.getShortDescription());
        Assert.assertEquals((Object)false, (Object)part.isAllowEmpty());
        Assert.assertEquals((Object)true, (Object)part.isPassword());
    }

    @Test
    public void testPathInputPart() {
        PathInputPart part = new PathInputPart(this.desc.get("text"), "title", true);
        Assert.assertEquals((Object)"text", (Object)part.getName());
        Assert.assertEquals((Object)"displayName", (Object)part.getDisplayName());
        Assert.assertEquals((Object)"shortDescription", (Object)part.getShortDescription());
        Assert.assertEquals((Object)"title", (Object)part.getBrowseTitle());
        Assert.assertEquals((Object)true, (Object)part.isForSaveAs());
    }

    @Test
    public void testListSelectionPart() {
        String[] items = new String[]{"selection1", "selection2"};
        ListSelectionPart part = new ListSelectionPart(this.desc.get("text"), items);
        Assert.assertEquals((Object)"text", (Object)part.getName());
        Assert.assertEquals((Object)"displayName", (Object)part.getDisplayName());
        Assert.assertEquals((Object)"shortDescription", (Object)part.getShortDescription());
        String[] choices = part.getChoicesValues();
        Assert.assertNotNull((Object)choices);
        Assert.assertEquals((long)2L, (long)choices.length);
        Assert.assertEquals((Object)"selection2", (Object)choices[1]);
    }

    class TestClass {
        private String text;
        private boolean flag;

        TestClass() {
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean isFlag() {
            return this.flag;
        }

        public void setFlag(boolean flag) {
            this.flag = flag;
        }
    }
}

