/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;

public class AltTranslationsAnnotation
implements IAnnotation,
Iterable<AltTranslation> {
    private ArrayList<AltTranslation> list = new ArrayList(2);

    public void add(AltTranslation alt) {
        this.list.add(alt);
    }

    public AltTranslation add(LocaleId sourceLocId, LocaleId targetLocId, TextFragment originalSource, TextFragment alternateSource, TextFragment alternateTarget, MatchType type, int combinedScore, String origin) {
        return this.add(sourceLocId, targetLocId, originalSource, alternateSource, alternateTarget, type, combinedScore, origin, combinedScore, QueryResult.QUALITY_UNDEFINED);
    }

    public AltTranslation add(LocaleId sourceLocId, LocaleId targetLocId, TextFragment originalSource, TextFragment alternateSource, TextFragment alternateTarget, MatchType type, int combinedScore, String origin, int fuzzyScore, int qualityScore) {
        this.list.add(new AltTranslation(sourceLocId, targetLocId, originalSource, alternateSource, alternateTarget, type, combinedScore, origin, fuzzyScore, qualityScore));
        return this.list.get(this.list.size() - 1);
    }

    @Override
    public Iterator<AltTranslation> iterator() {
        return new Iterator<AltTranslation>(){
            int current = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The method remove() not supported.");
            }

            @Override
            public AltTranslation next() {
                if (this.current >= AltTranslationsAnnotation.this.list.size()) {
                    throw new NoSuchElementException("No more content parts.");
                }
                return (AltTranslation)AltTranslationsAnnotation.this.list.get(this.current++);
            }

            @Override
            public boolean hasNext() {
                return this.current < AltTranslationsAnnotation.this.list.size();
            }
        };
    }

    public AltTranslation getFirst() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.get(0);
    }

    public AltTranslation getLast() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.get(this.list.size() - 1);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public int size() {
        return this.list.size();
    }

    public void sort() {
        Collections.sort(this.list);
    }

    public boolean hasSeveralBestMatches(boolean forceSort) {
        if (this.list.size() < 2) {
            return false;
        }
        if (forceSort) {
            this.sort();
        }
        AltTranslation best = this.list.get(0);
        if (best.combinedScore < 100) {
            return false;
        }
        for (int i = 1; i < this.list.size(); ++i) {
            AltTranslation res = this.list.get(i);
            if (best.combinedScore != res.combinedScore) {
                return false;
            }
            if (!best.getSource().toString().equals(res.getSource().toString())) {
                return false;
            }
            if (best.getTarget().toString().equals(res.getTarget().toString())) continue;
            return true;
        }
        return false;
    }

    public void downgradeIdenticalBestMatches(boolean forceSort, int threshold) {
        if (!this.hasSeveralBestMatches(forceSort)) {
            return;
        }
        AltTranslation best = this.list.get(0);
        for (int i = 1; i < this.list.size(); ++i) {
            AltTranslation res = this.list.get(i);
            if (best.combinedScore != res.combinedScore || !best.getSource().toString().equals(res.getSource().toString())) break;
            --res.combinedScore;
        }
        --best.combinedScore;
        Iterator<AltTranslation> iter = this.list.iterator();
        while (iter.hasNext()) {
            AltTranslation at = iter.next();
            if (at.combinedScore >= threshold) break;
            iter.remove();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (AltTranslation at : this.list) {
            sb.append(String.format("{%s} ", at.toString()));
        }
        return sb.toString();
    }
}

