/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.IEncoder;

public class PropertiesEncoder
implements IEncoder {
    private CharsetEncoder chsEnc = Charset.forName("us-ascii").newEncoder();
    private boolean escapeExtendedChars = false;
    private String lineBreak;

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
        this.chsEnc = Charset.forName(encoding).newEncoder();
        this.lineBreak = lineBreak;
        if (params != null) {
            this.escapeExtendedChars = params.getBoolean("escapeExtendedChars");
        }
    }

    @Override
    public String encode(String text, int context) {
        StringBuilder escaped = new StringBuilder();
        block5: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch > '\u007f') {
                if (Character.isHighSurrogate(ch)) {
                    int cp = text.codePointAt(i++);
                    String tmp = new String(Character.toChars(cp));
                    if (this.escapeExtendedChars || this.chsEnc != null && !this.chsEnc.canEncode(tmp)) {
                        escaped.append(String.format("\\u%04x\\u%04x", tmp.charAt(0), (int)tmp.charAt(1)));
                        continue;
                    }
                    escaped.append(tmp);
                    continue;
                }
                if (this.escapeExtendedChars || this.chsEnc != null && !this.chsEnc.canEncode(ch)) {
                    escaped.append(String.format("\\u%04x", ch));
                    continue;
                }
                escaped.append(String.valueOf(ch));
                continue;
            }
            switch (ch) {
                case '\n': {
                    escaped.append("\\n");
                    continue block5;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block5;
                }
                case ':': 
                case '=': {
                    if (i == 0) {
                        escaped.append('\\');
                    }
                }
                default: {
                    escaped.append(ch);
                }
            }
        }
        return escaped.toString();
    }

    @Override
    public String encode(char value, int context) {
        if (value > '\u007f') {
            if (this.escapeExtendedChars || !this.chsEnc.canEncode(value)) {
                return String.format("\\u%04x", value);
            }
            return String.valueOf(value);
        }
        switch (value) {
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
        }
        return String.valueOf(value);
    }

    @Override
    public String encode(int value, int context) {
        if (value > 127) {
            if (Character.isSupplementaryCodePoint(value)) {
                String tmp = new String(Character.toChars(value));
                if (this.escapeExtendedChars || !this.chsEnc.canEncode(tmp)) {
                    return String.format("\\u%04x\\u%04x", tmp.charAt(0), (int)tmp.charAt(1));
                }
                return tmp;
            }
            if (this.escapeExtendedChars || this.chsEnc != null && !this.chsEnc.canEncode((char)value)) {
                return String.format("\\u%04x", value);
            }
            return String.valueOf((char)value);
        }
        switch ((char)value) {
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
        }
        return String.valueOf((char)value);
    }

    @Override
    public String toNative(String propertyName, String value) {
        return value;
    }

    @Override
    public String getLineBreak() {
        return this.lineBreak;
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        return this.chsEnc;
    }
}

