/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.util.List;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.StubFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilterConfigurationTest {
    private FilterConfiguration fc1;
    private FilterConfiguration fc2;

    @Before
    public void setUp() throws Exception {
        this.fc1 = new FilterConfiguration("config1", "text/x-properties", "net.sf.okapi.filters.xml.XMLFilter", "Config1", "Description for Config1.");
        this.fc2 = new FilterConfiguration("config2", "text/x-properties", "net.sf.okapi.filters.xml.XMLFilter", "Config2", "Description for Config2.");
        this.fc2.custom = true;
    }

    @Test
    public void simpleOverrideTest() {
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfiguration(this.fc1);
        FilterConfiguration cfg = fcm.getDefaultConfiguration("text/x-properties");
        Assert.assertEquals((Object)cfg.configId, (Object)"config1");
        fcm.removeConfiguration(cfg.configId);
        fcm.addConfiguration(this.fc2);
        cfg = fcm.getDefaultConfiguration("text/x-properties");
        Assert.assertEquals((Object)cfg.configId, (Object)"config2");
    }

    @Test
    public void simpleConfigTest() {
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfiguration(this.fc1);
        FilterConfiguration cfg = fcm.getConfiguration(this.fc1.configId);
        Assert.assertNotNull((Object)cfg);
        Assert.assertEquals((Object)cfg, (Object)this.fc1);
    }

    @Test
    public void getDefaultFromMimeTest() {
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfigurations(StubFilter.class.getName());
        FilterConfiguration cfg = fcm.getDefaultConfiguration("text/foo");
        Assert.assertNotNull((String)"config should not be null", (Object)cfg);
        Assert.assertEquals((String)"The Config ID", (Object)"foobar", (Object)cfg.configId);
    }

    @Test
    public void getFilterConfigTest() {
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfiguration(this.fc1);
        List<FilterConfiguration> list = fcm.getFilterConfigurations(this.fc1.filterClass);
        Assert.assertNotNull(list);
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void getMimeConfigTest() {
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfiguration(this.fc1);
        List<FilterConfiguration> list = fcm.getMimeConfigurations(this.fc1.mimeType);
        Assert.assertNotNull(list);
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void clearConfigTest() {
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfiguration(this.fc2);
        fcm.addConfiguration(this.fc1);
        Assert.assertNotNull((Object)fcm.getConfiguration(this.fc1.configId));
        Assert.assertNotNull((Object)fcm.getConfiguration(this.fc2.configId));
        fcm.clearConfigurations(false);
        Assert.assertNull((Object)fcm.getConfiguration(this.fc1.configId));
        Assert.assertNull((Object)fcm.getConfiguration(this.fc2.configId));
    }

    @Test
    public void clearCustomConfigTest() {
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfiguration(this.fc2);
        fcm.addConfiguration(this.fc1);
        Assert.assertNotNull((Object)fcm.getConfiguration(this.fc1.configId));
        Assert.assertNotNull((Object)fcm.getConfiguration(this.fc2.configId));
        fcm.clearConfigurations(true);
        Assert.assertNotNull((Object)fcm.getConfiguration(this.fc1.configId));
        Assert.assertNull((Object)fcm.getConfiguration(this.fc2.configId));
    }

    @Test
    public void createFilterTestWithDefaultFilter() {
        String configId = "foobar";
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfigurations(StubFilter.class.getName());
        FilterConfiguration cfg = fcm.getConfiguration(configId);
        IFilter filter = fcm.createFilter(configId);
        Assert.assertNotNull((String)"filter should not be null", (Object)filter);
        Assert.assertEquals((Object)filter.getClass().getName(), (Object)cfg.filterClass);
    }

    @Test
    public void createFilterTestWithNonDefaultFilter() {
        String configId = "foobar-srt";
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfigurations(StubFilter.class.getName());
        FilterConfiguration cfg = fcm.getConfiguration(configId);
        IFilter filter = fcm.createFilter(configId);
        Assert.assertNotNull((String)"filter should not be null", (Object)filter);
        Assert.assertEquals((Object)filter.getClass().getName(), (Object)cfg.filterClass);
    }

    @Test
    public void removeFilterTest() {
        String configId = "foobar-srt";
        String filterClass = "net.sf.okapi.common.filters.StubFilter";
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfigurations(filterClass);
        FilterConfiguration cfg = fcm.getConfiguration(configId);
        Assert.assertNotNull((Object)cfg);
        fcm.removeConfigurations(filterClass);
        cfg = fcm.getConfiguration(configId);
        Assert.assertNull((String)"Config should have not been found.", (Object)cfg);
    }

    @Test
    public void createEditorTest() {
        String configId = "foobar-srt";
        String editorClass = "net.sf.okapi.common.filters.StubEditor";
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        fcm.addConfigurations("net.sf.okapi.common.filters.StubFilter");
        IFilter filter = fcm.createFilter(configId);
        Assert.assertNotNull((Object)filter);
        IParameters params = filter.getParameters();
        fcm.addEditor(editorClass, params.getClass().getName());
        IParametersEditor editor = fcm.createConfigurationEditor(configId);
        Assert.assertNotNull((String)"Editor should have been created.", (Object)editor);
        Assert.assertEquals((String)"Editor class name.", (Object)editorClass, (Object)editor.getClass().getName());
    }
}

