/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CodeTest {
    @Before
    public void setUp() {
    }

    @Test
    public void testAccess() {
        Code code = new Code(TextFragment.TagType.OPENING, "ctype", "data");
        Assert.assertEquals((Object)"data", (Object)code.getData());
        Assert.assertEquals((Object)"ctype", (Object)code.getType());
        Assert.assertEquals((Object)((Object)TextFragment.TagType.OPENING), (Object)((Object)code.getTagType()));
        Assert.assertEquals((Object)"data", (Object)code.getOuterData());
        code.setOuterData("outerData");
        Assert.assertEquals((Object)"outerData", (Object)code.getOuterData());
        Assert.assertEquals((Object)"data", (Object)code.getData());
    }

    @Test
    public void testFlags() {
        Code code = new Code(TextFragment.TagType.OPENING, "ctype", "data");
        Assert.assertFalse((boolean)code.isCloneable());
        Assert.assertFalse((boolean)code.isDeleteable());
        Assert.assertFalse((boolean)code.hasReference());
        code.setDeleteable(true);
        code.setCloneable(true);
        code.setReferenceFlag(true);
        Assert.assertTrue((boolean)code.isCloneable());
        Assert.assertTrue((boolean)code.isDeleteable());
        Assert.assertTrue((boolean)code.hasReference());
    }

    @Test
    public void testClone() {
        Code code = new Code(TextFragment.TagType.OPENING, "ctype", "data");
        code.setOuterData("out1");
        Code c2 = code.clone();
        Assert.assertNotSame((Object)c2, (Object)code);
        Assert.assertEquals((long)c2.getId(), (long)code.getId());
        Assert.assertEquals((Object)c2.getData(), (Object)code.getData());
        Assert.assertNotSame((Object)c2.data, (Object)code.data);
        Assert.assertEquals((Object)((Object)c2.getTagType()), (Object)((Object)code.getTagType()));
        Assert.assertEquals((Object)c2.getType(), (Object)code.getType());
        Assert.assertEquals((Object)c2.getOuterData(), (Object)code.getOuterData());
        Assert.assertNotSame((Object)c2.outerData, (Object)code.outerData);
    }

    @Test
    public void testStrings() {
        ArrayList<Code> codes = new ArrayList<Code>();
        codes.add(new Code(TextFragment.TagType.OPENING, "bold", "<b>"));
        codes.add(new Code(TextFragment.TagType.PLACEHOLDER, "break", "<br/>"));
        codes.add(new Code(TextFragment.TagType.CLOSING, "bold", "</b>"));
        String tmp = Code.codesToString(codes);
        Assert.assertNotNull((Object)tmp);
        List<Code> codesAfter = Code.stringToCodes(tmp);
        Assert.assertEquals((long)3L, (long)codesAfter.size());
        Code code = codesAfter.get(0);
        Assert.assertEquals((Object)"<b>", (Object)code.getData());
        Assert.assertEquals((Object)((Object)TextFragment.TagType.OPENING), (Object)((Object)code.getTagType()));
        Assert.assertEquals((Object)"bold", (Object)code.getType());
        code = codesAfter.get(1);
        Assert.assertEquals((Object)"<br/>", (Object)code.getData());
        Assert.assertEquals((Object)((Object)TextFragment.TagType.PLACEHOLDER), (Object)((Object)code.getTagType()));
        Assert.assertEquals((Object)"break", (Object)code.getType());
        code = codesAfter.get(2);
        Assert.assertEquals((Object)"</b>", (Object)code.getData());
        Assert.assertEquals((Object)((Object)TextFragment.TagType.CLOSING), (Object)((Object)code.getTagType()));
        Assert.assertEquals((Object)"bold", (Object)code.getType());
    }

    @Test
    public void testCodeData() {
        Code code = new Code(TextFragment.TagType.PLACEHOLDER, "type", null);
        Assert.assertEquals((Object)"", (Object)code.toString());
        code = new Code(TextFragment.TagType.PLACEHOLDER, "type", null);
        code.setOuterData("<x id=\"1\">");
        Assert.assertEquals((Object)"", (Object)code.toString());
        code.setOuterData(null);
        Assert.assertEquals((Object)"", (Object)code.toString());
    }
}

