/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import org.junit.Assert;
import org.junit.Test;

public class TextUnitUtilTest {
    private GenericContent fmt = new GenericContent();
    private LocaleId locTrg = LocaleId.fromString("trg");

    @Test
    public void testAdjustTargetFragment() {
        TextFragment toTransSrc = this.makeFragment1();
        TextFragment proposalTrg = this.makeFragment1Bis("trg");
        Assert.assertEquals((Object)"{B}A{/B}B{BR/}C trg", (Object)proposalTrg.toText());
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(toTransSrc, proposalTrg, true, true, null, null);
        Assert.assertEquals((Object)"[b]A[/b]B[br/]C trg", (Object)proposalTrg.toText());
    }

    @Test
    public void testAdjustIncompleteTargetFragmentAutoAdded() {
        TextFragment toTransSrc = this.makeFragment1();
        TextFragment proposalTrg = this.makeFragment1Bis("trg");
        proposalTrg.remove(6, 8);
        Assert.assertEquals((Object)"{B}A{/B}BC trg", (Object)proposalTrg.toText());
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(toTransSrc, proposalTrg, true, true, null, null);
        Assert.assertEquals((Object)"[b]A[/b]BC trg[br/]", (Object)proposalTrg.toText());
    }

    @Test
    public void testAdjustIncompleteTargetFragmentNoAddition() {
        TextFragment toTransSrc = this.makeFragment1();
        TextFragment proposalTrg = this.makeFragment1Bis("with warning");
        proposalTrg.remove(6, 8);
        Assert.assertEquals((Object)"{B}A{/B}BC with warning", (Object)proposalTrg.toText());
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(toTransSrc, proposalTrg, true, false, null, null);
        Assert.assertEquals((Object)"[b]A[/b]BC with warning", (Object)proposalTrg.toText());
    }

    @Test
    public void testAdjustNoCodes() {
        TextUnit tu = new TextUnit("1", "src");
        TextFragment newSrc = new TextFragment("src");
        TextFragment newTrg = new TextFragment("trg");
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(tu.getSource().getSegments().getFirstContent(), newTrg, true, false, newSrc, tu);
        Assert.assertEquals((Object)this.locTrg, (Object)newTrg.toText());
    }

    @Test
    public void testAdjustSameMarkers() {
        ITextUnit tu = this.createTextUnit1();
        TextFragment tf = new TextFragment("T ");
        tf.append(TextFragment.TagType.OPENING, "b", "<T>");
        tf.append("BOLD");
        tf.append(TextFragment.TagType.CLOSING, "b", "</T>");
        tf.append(" T ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<PH/>");
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(tu.getSource().getSegments().getFirstContent(), tf, true, false, null, tu);
        Assert.assertEquals((Object)"T <b>BOLD</b> T <br/>", (Object)tf.toText());
        this.fmt.setContent(tf);
        Assert.assertEquals((Object)"T <1>BOLD</1> T <2/>", (Object)this.fmt.toString());
    }

    @Test
    public void testAdjustExtraMarkers() {
        ITextUnit tu = this.createTextUnit1();
        TextFragment tf = new TextFragment("T ");
        tf.append(TextFragment.TagType.OPENING, "b", "<T>");
        tf.append("BOLD");
        tf.append(TextFragment.TagType.CLOSING, "b", "</T>");
        tf.append(" T ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<PH/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "extra", "<EXTRA/>");
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(tu.getSource().getSegments().getFirstContent(), tf, true, false, null, tu);
        Assert.assertEquals((Object)"T <b>BOLD</b> T <br/><EXTRA/>", (Object)tf.toText());
        this.fmt.setContent(tf);
        Assert.assertEquals((Object)"T <1>BOLD</1> T <2/><3/>", (Object)this.fmt.toString());
    }

    @Test
    public void testAdjustMissingMarker() {
        ITextUnit tu = this.createTextUnit1();
        TextFragment tf = new TextFragment("T ");
        tf.append(TextFragment.TagType.OPENING, "b", "<T>");
        tf.append("BOLD");
        tf.append(" T ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<PH/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "extra", "<EXTRA/>");
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(tu.getSource().getSegments().getFirstContent(), tf, true, false, null, tu);
        Assert.assertEquals((Object)"T <b>BOLD T <br/><EXTRA/>", (Object)tf.toText());
        this.fmt.setContent(tf);
        Assert.assertEquals((Object)"T <b1/>BOLD T <2/><3/>", (Object)this.fmt.toString());
    }

    @Test
    public void testAdjustDifferentTextSameMarkers() {
        ITextUnit tu = this.createTextUnit1();
        TextFragment tf = new TextFragment("U ");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("BOLD");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(" U ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(tu.getSource().getFirstContent(), tf, true, false, null, tu);
        Assert.assertEquals((Object)"U <b>BOLD</b> U <br/>", (Object)tf.toText());
        Assert.assertEquals((Object)"U <1>BOLD</1> U <2/>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testMovedCodes() {
        TextFragment oriFrag = new TextFragment("s1 ");
        oriFrag.append(TextFragment.TagType.PLACEHOLDER, "c1", "[c1]");
        oriFrag.append(" s2 ");
        oriFrag.append(TextFragment.TagType.OPENING, "c2", "[c2>]");
        oriFrag.append(" s3 ");
        oriFrag.append(TextFragment.TagType.CLOSING, "c2", "[<c2]");
        TextFragment trgFrag = this.fmt.fromLetterCodedToFragment("<g2>t3</g2> t1 <x1/> t2", null, false);
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(oriFrag, trgFrag, true, false, null, null);
        Assert.assertEquals((Object)"[c2>]t3[<c2] t1 [c1] t2", (Object)this.fmt.setContent(trgFrag).toString(true));
    }

    @Test
    public void testUtils() {
        String st = "12345678";
        Assert.assertEquals((Object)"45678", (Object)Util.trimStart(st, "123"));
        Assert.assertEquals((Object)"12345", (Object)Util.trimEnd(st, "678"));
        Assert.assertEquals((Object)"12345678", (Object)Util.trimEnd(st, "9"));
        st = "     ";
        Assert.assertEquals((Object)"", (Object)Util.trimStart(st, " "));
        Assert.assertEquals((Object)"", (Object)Util.trimEnd(st, " "));
        st = "  1234   ";
        TextFragment tf = new TextFragment(st);
        TextUnitUtil.trimLeading(tf, null);
        Assert.assertEquals((Object)"1234   ", (Object)tf.toText());
        TextUnitUtil.trimTrailing(tf, null);
        Assert.assertEquals((Object)"1234", (Object)tf.toText());
        st = "     ";
        tf = new TextFragment(st);
        TextUnitUtil.trimLeading(tf, null);
        Assert.assertEquals((Object)"", (Object)tf.toText());
        TextUnitUtil.trimTrailing(tf, null);
        Assert.assertEquals((Object)"", (Object)tf.toText());
        st = "     ";
        tf = new TextFragment(st);
        TextUnitUtil.trimTrailing(tf, null);
        Assert.assertEquals((Object)"", (Object)tf.toText());
        TextFragment tc = new TextFragment("test");
        Code c = new Code(TextFragment.TagType.PLACEHOLDER, "code");
        tc.append(c);
        tc.append(" string");
        TextFragment tcc = new TextFragment();
        Code c2 = new Code(TextFragment.TagType.PLACEHOLDER, "code");
        tcc.append("   ");
        tcc.append(c2);
        tcc.append("    123456  ");
        GenericSkeleton skel = new GenericSkeleton();
        TextUnitUtil.trimLeading(tcc, skel);
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSourceContent(tcc);
        Assert.assertEquals((Object)"    123456  ", (Object)((Object)tu1).toString());
        Assert.assertEquals((Object)"   ", (Object)skel.toString());
        TextFragment tcc2 = new TextFragment("    123456  ");
        Code c3 = new Code(TextFragment.TagType.PLACEHOLDER, "code");
        tcc2.append(c3);
        GenericSkeleton skel2 = new GenericSkeleton();
        TextUnitUtil.trimTrailing(tcc2, skel2);
        tu1.setSourceContent(tcc2);
        Assert.assertEquals((Object)"    123456  ", (Object)((Object)tu1).toString());
        Assert.assertEquals((Object)"", (Object)skel2.toString());
        TextFragment tcc4 = new TextFragment("    123456  ");
        Code c4 = new Code(TextFragment.TagType.PLACEHOLDER, "code");
        tcc4.append(c4);
        char ch = TextUnitUtil.getLastChar(tcc4);
        Assert.assertEquals((long)54L, (long)ch);
        TextFragment tcc5 = new TextFragment("    123456  ");
        TextUnitUtil.deleteLastChar(tcc5);
        Assert.assertEquals((Object)"    12345  ", (Object)tcc5.getCodedText());
        TextFragment tcc6 = new TextFragment("123456_    ");
        Assert.assertTrue((boolean)TextUnitUtil.endsWith(tcc6, "_"));
        Assert.assertTrue((boolean)TextUnitUtil.endsWith(tcc6, "6_"));
        Assert.assertFalse((boolean)TextUnitUtil.endsWith(tcc6, "  "));
        TextFragment tcc7 = new TextFragment("123456<splicer>    ");
        Assert.assertTrue((boolean)TextUnitUtil.endsWith(tcc7, "<splicer>"));
        Assert.assertTrue((boolean)TextUnitUtil.endsWith(tcc7, "6<splicer>"));
        Assert.assertFalse((boolean)TextUnitUtil.endsWith(tcc7, "  "));
    }

    @Test
    public void testGetText() {
        TextFragment tf = new TextFragment("ab");
        tf.append(TextFragment.TagType.OPENING, "type1", "z");
        tf.append("cde");
        tf.append(TextFragment.TagType.PLACEHOLDER, "type2", "z");
        tf.append("fgh");
        tf.append(TextFragment.TagType.PLACEHOLDER, "type3", "z");
        tf.append("ijklm");
        tf.append(TextFragment.TagType.CLOSING, "type1", "z");
        Assert.assertEquals((Object)"abcdefghijklm", (Object)TextUnitUtil.getText(tf));
        ArrayList<Integer> positions = new ArrayList<Integer>();
        Assert.assertEquals((Object)"abcdefghijklm", (Object)TextUnitUtil.getText(tf, positions));
        Assert.assertEquals((long)4L, (long)positions.size());
        Assert.assertEquals((long)2L, (long)positions.get(0).intValue());
        Assert.assertEquals((long)7L, (long)positions.get(1).intValue());
        Assert.assertEquals((long)12L, (long)positions.get(2).intValue());
        Assert.assertEquals((long)19L, (long)positions.get(3).intValue());
        tf = new TextFragment("ab");
        tf.append(TextFragment.TagType.OPENING, "type1", "z");
        tf.append("cde");
        tf.append(TextFragment.TagType.PLACEHOLDER, "type2", "z");
        tf.append("fgh");
        tf.append(TextFragment.TagType.PLACEHOLDER, "type3", "z");
        tf.append("ijklm");
        tf.append(TextFragment.TagType.CLOSING, "type1", "z");
        tf.append("n");
        Assert.assertEquals((Object)"abcdefghijklmn", (Object)TextUnitUtil.getText(tf));
        positions = new ArrayList();
        Assert.assertEquals((Object)"abcdefghijklmn", (Object)TextUnitUtil.getText(tf, positions));
        Assert.assertEquals((long)4L, (long)positions.size());
        Assert.assertEquals((long)2L, (long)positions.get(0).intValue());
        Assert.assertEquals((long)7L, (long)positions.get(1).intValue());
        Assert.assertEquals((long)12L, (long)positions.get(2).intValue());
        Assert.assertEquals((long)19L, (long)positions.get(3).intValue());
        String st = "abcdefghijklmn";
        Assert.assertEquals((Object)st, (Object)TextUnitUtil.getText(new TextFragment(st)));
        tf = new TextFragment("abcde");
        tf.append(TextFragment.TagType.PLACEHOLDER, "iso", "z");
        tf.append(TextFragment.TagType.PLACEHOLDER, "iso", "z");
        tf.append("fghijklm");
        tf.append(TextFragment.TagType.PLACEHOLDER, "iso", "z");
        tf.append(TextFragment.TagType.PLACEHOLDER, "iso", "z");
        tf.append("n");
        Assert.assertEquals((Object)"abcdefghijklmn", (Object)TextUnitUtil.getText(tf));
        positions = new ArrayList();
        Assert.assertEquals((Object)"abcdefghijklmn", (Object)TextUnitUtil.getText(tf, positions));
        Assert.assertEquals((long)4L, (long)positions.size());
        Assert.assertEquals((long)5L, (long)positions.get(0).intValue());
        Assert.assertEquals((long)7L, (long)positions.get(1).intValue());
        Assert.assertEquals((long)17L, (long)positions.get(2).intValue());
        Assert.assertEquals((long)19L, (long)positions.get(3).intValue());
        st = "abcdefghijklmn";
        Assert.assertEquals((Object)st, (Object)TextUnitUtil.getText(new TextFragment(st)));
    }

    @Test
    public void testRemoveQualifiers() {
        ITextUnit tu = TextUnitUtil.buildTU("\"qualified text\"");
        TextUnitUtil.removeQualifiers(tu, "\"");
        Assert.assertEquals((Object)"qualified text", (Object)tu.getSource().toString());
        tu.setSourceContent(new TextFragment("((({[qualified text]})))"));
        Assert.assertEquals((Object)"((({[qualified text]})))", (Object)tu.getSource().toString());
        TextUnitUtil.removeQualifiers(tu, "((({", "})))");
        Assert.assertEquals((Object)"[qualified text]", (Object)tu.getSource().toString());
        GenericSkeleton tuSkel = (GenericSkeleton)tu.getSkeleton();
        Assert.assertNotNull((Object)tuSkel);
        List<GenericSkeletonPart> parts = tuSkel.getParts();
        Assert.assertEquals((long)5L, (long)parts.size());
        String tuRef = TextFragment.makeRefMarker("$self$");
        Assert.assertEquals((Object)"\"", (Object)parts.get(0).toString());
        Assert.assertEquals((Object)"((({", (Object)parts.get(1).toString());
        Assert.assertEquals((Object)tuRef, (Object)parts.get(2).toString());
        Assert.assertEquals((Object)"})))", (Object)parts.get(3).toString());
        Assert.assertEquals((Object)"\"", (Object)parts.get(4).toString());
    }

    @Test
    public void testSimplifyCodes() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        TextUnit tu = new TextUnit("tu1");
        tu.setSourceContent(tf);
        Assert.assertEquals((Object)"<x1/>T1<x2/>", (Object)tu.getSource().toString());
        TextUnitUtil.simplifyCodes(tu, true);
        Assert.assertEquals((Object)"T1", (Object)tu.getSource().toString());
        GenericSkeleton tuSkel = (GenericSkeleton)tu.getSkeleton();
        Assert.assertNotNull((Object)tuSkel);
        List<GenericSkeletonPart> parts = tuSkel.getParts();
        Assert.assertEquals((long)3L, (long)parts.size());
        Assert.assertEquals((Object)"<x1/>", (Object)parts.get(0).toString());
        String tuRef = TextFragment.makeRefMarker("$self$");
        Assert.assertEquals((Object)tuRef, (Object)parts.get(1).toString());
        Assert.assertEquals((Object)"<x2/>", (Object)parts.get(2).toString());
    }

    @Test
    public void testSimplifyCodes_segmentedTU() {
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", new TextFragment("[seg 1]")));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", new TextFragment("[seg 2]")));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", new TextFragment("[seg 3]")));
        tc.append(new Segment("s4", new TextFragment("[seg 4]")));
        String[] res = TextUnitUtil.simplifyCodes(tc, false);
        Assert.assertEquals((Object)"[seg 1][text part 1][seg 2][text part 2][text part 3][seg 3][seg 4]", (Object)tc.toString());
        Assert.assertNull((Object)res);
    }

    @Test
    public void testSimplifyCodes_segmentedTU2() {
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", new TextFragment("[seg 1]")));
        String[] res = TextUnitUtil.simplifyCodes(tc, false);
        Assert.assertEquals((Object)"[seg 1]", (Object)tc.toString());
        Assert.assertNull((Object)res);
    }

    @Test
    public void testSimplifyCodes_segmentedTU3() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append("[seg 1]");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        String[] res = TextUnitUtil.simplifyCodes(tc, true);
        Assert.assertEquals((Object)"[seg 1]", (Object)tc.toString());
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)"<x11/><x12/>", (Object)res[0]);
        Assert.assertEquals((Object)"<x13/><x14/>", (Object)res[1]);
    }

    @Test
    public void testSimplifyCodes_segmentedTU4() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append("   [seg 1]");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        String[] res = TextUnitUtil.simplifyCodes(tc, true);
        Assert.assertEquals((Object)"[seg 1]", (Object)tc.toString());
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)"<x11/><x12/>   ", (Object)res[0]);
        Assert.assertEquals((Object)"<x13/><x14/>", (Object)res[1]);
    }

    @Test
    public void testSimplifyCodes_segmentedTU5() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append("   [seg 1]");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x21", "<x21/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x22", "<x22/>");
        tf2.append("   [seg 2]");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x23", "<x23/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x24", "<x24/>");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new Segment("s2", tf2));
        String[] res = TextUnitUtil.simplifyCodes(tc, true);
        Assert.assertEquals((Object)"[seg 1]<x13/><x14/><x21/><x22/>   [seg 2]", (Object)tc.toString());
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)"<x11/><x12/>   ", (Object)res[0]);
        Assert.assertEquals((Object)"<x23/><x24/>", (Object)res[1]);
        Assert.assertEquals((long)5L, (long)tc.count());
        Assert.assertTrue((boolean)tc.get(0).isSegment());
        Assert.assertFalse((boolean)tc.get(1).isSegment());
        Assert.assertFalse((boolean)tc.get(2).isSegment());
        Assert.assertFalse((boolean)tc.get(3).isSegment());
        Assert.assertTrue((boolean)tc.get(4).isSegment());
        Assert.assertEquals((Object)"[seg 1]", (Object)tc.get(0).toString());
        Assert.assertEquals((Object)"<x13/><x14/>", (Object)tc.get(1).toString());
        Assert.assertEquals((Object)"<x21/><x22/>", (Object)tc.get(2).toString());
        Assert.assertEquals((Object)"<x21/><x22/>", (Object)tc.get(2).toString());
        Assert.assertEquals((Object)"   ", (Object)tc.get(3).toString());
        Assert.assertEquals((Object)"[seg 2]", (Object)tc.get(4).toString());
        ISegments segs = tc.getSegments();
        Assert.assertEquals((long)2L, (long)segs.count());
    }

    @Test
    public void testStoreSegmentation() {
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", new TextFragment("[seg 1]")));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", new TextFragment("[seg 2]")));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", new TextFragment("[seg 3]")));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals((Object)"<1/>[seg 1]<2/><3/>[text part 1]<4/><5/>[seg 2]<6/><7/>[text part 2]<8/><9/>[text part 3]<10/><11/>[seg 3]<12/>", (Object)this.fmt.setContent(tf).toString());
        List<Code> codes = tf.getCodes();
        Assert.assertEquals((long)12L, (long)codes.size());
        Assert.assertEquals((Object)"[#$s1@%$seg_start$]", (Object)codes.get(0).toString());
        Assert.assertEquals((Object)"[#$s1@%$seg_end$]", (Object)codes.get(1).toString());
        Assert.assertEquals((Object)"$tp_start$", (Object)codes.get(2).toString());
        Assert.assertEquals((Object)"$tp_end$", (Object)codes.get(3).toString());
        Assert.assertEquals((Object)"[#$s2@%$seg_start$]", (Object)codes.get(4).toString());
        Assert.assertEquals((Object)"[#$s2@%$seg_end$]", (Object)codes.get(5).toString());
        Assert.assertEquals((Object)"$tp_start$", (Object)codes.get(6).toString());
        Assert.assertEquals((Object)"$tp_end$", (Object)codes.get(7).toString());
        Assert.assertEquals((Object)"$tp_start$", (Object)codes.get(8).toString());
        Assert.assertEquals((Object)"$tp_end$", (Object)codes.get(9).toString());
        Assert.assertEquals((Object)"[#$s3@%$seg_start$]", (Object)codes.get(10).toString());
        Assert.assertEquals((Object)"[#$s3@%$seg_end$]", (Object)codes.get(11).toString());
    }

    @Test
    public void testTreeSet() {
        TreeSet<Integer> set = new TreeSet<Integer>();
        set.add(5);
        set.add(1);
        set.add(5);
        set.add(3);
        set.add(9);
        Assert.assertEquals((long)4L, (long)set.size());
        Assert.assertEquals((Object)"[1, 3, 5, 9]", (Object)set.toString());
    }

    @Test
    public void testTreeMap() {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        map.put(5, "");
        map.put(1, "");
        map.put(5, "");
        map.put(3, "");
        map.put(9, "");
        Assert.assertEquals((long)4L, (long)map.size());
    }

    @Test
    public void testHashtableSort() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("a", "b");
        h.put("c", "d");
        h.put("e", "f");
        h.put("a", "bb");
        ArrayList v = new ArrayList(h.keySet());
        Collections.sort(v);
    }

    @Test
    public void testRestoreSegmentation() {
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", new TextFragment("[seg 1]")));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", new TextFragment("[seg 2]")));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", new TextFragment("[seg 3]")));
        tc.append(new Segment("s4", new TextFragment("[seg 4]")));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals((Object)"<1/>[seg 1]<2/><3/>[text part 1]<4/><5/>[seg 2]<6/><7/>[text part 2]<8/><9/>[text part 3]<10/><11/>[seg 3]<12/><13/>[seg 4]<14/>", (Object)this.fmt.setContent(tf).toString());
        TextUnitUtil.restoreSegmentation(tc, tf);
        Assert.assertEquals((Object)"(2: seg_start s1) (9: seg_end s1) (13: tp_start) (26: tp_end) (30: seg_start s2) (37: seg_end s2) (41: tp_start) (54: tp_end) (58: tp_start) (71: tp_end) (75: seg_start s3) (82: seg_end s3) (86: seg_start s4) (93: seg_end s4)", (Object)TextUnitUtil.testMarkers());
        Assert.assertEquals((Object)"[seg 1][text part 1][seg 2][text part 2][text part 3][seg 3][seg 4]", (Object)tc.toString());
        Iterator<TextPart> it = tc.iterator();
        TextPart part = null;
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue((boolean)part.isSegment());
            Assert.assertEquals((Object)"[seg 1]", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse((boolean)part.isSegment());
            Assert.assertEquals((Object)"[text part 1]", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue((boolean)part.isSegment());
            Assert.assertEquals((Object)"[seg 2]", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse((boolean)part.isSegment());
            Assert.assertEquals((Object)"[text part 2]", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse((boolean)part.isSegment());
            Assert.assertEquals((Object)"[text part 3]", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue((boolean)part.isSegment());
            Assert.assertEquals((Object)"[seg 3]", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue((boolean)part.isSegment());
            Assert.assertEquals((Object)"[seg 4]", (Object)part.toString());
        }
    }

    @Test
    public void testRestoreSegmentation2() {
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", new TextFragment("[seg 1]")));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", new TextFragment("[seg 2]")));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", new TextFragment("[seg 3]")));
        tc.append(new TextPart("[text part 4]"));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals((Object)"<1/>[seg 1]<2/><3/>[text part 1]<4/><5/>[seg 2]<6/><7/>[text part 2]<8/><9/>[text part 3]<10/><11/>[seg 3]<12/><13/>[text part 4]<14/>", (Object)this.fmt.setContent(tf).toString());
        TextUnitUtil.restoreSegmentation(tc, tf);
        Assert.assertEquals((Object)"[seg 1][text part 1][seg 2][text part 2][text part 3][seg 3][text part 4]", (Object)tc.toString());
        Iterator<TextPart> it = tc.iterator();
        TextPart part = null;
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue((boolean)part.isSegment());
            Assert.assertEquals((Object)"[seg 1]", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse((boolean)part.isSegment());
            Assert.assertEquals((Object)"[text part 1]", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue((boolean)part.isSegment());
            Assert.assertEquals((Object)"[seg 2]", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse((boolean)part.isSegment());
            Assert.assertEquals((Object)"[text part 2]", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse((boolean)part.isSegment());
            Assert.assertEquals((Object)"[text part 3]", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue((boolean)part.isSegment());
            Assert.assertEquals((Object)"[seg 3]", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse((boolean)part.isSegment());
            Assert.assertEquals((Object)"[text part 4]", (Object)part.toString());
        }
    }

    @Test
    public void testRestoreSegmentation3() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x21", "<x21/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x22", "<x22/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x23", "<x23/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x24", "<x24/>");
        TextFragment tf3 = new TextFragment();
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x31", "<x31/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x32", "<x32/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x33", "<x33/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x34", "<x34/>");
        Assert.assertEquals((Object)"<1/><2/><3/><4/>", (Object)this.fmt.setContent(tf1).toString());
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", tf2));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", tf3));
        tc.append(new TextPart("[text part 4]"));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals((Object)"<1/><1/><2/><3/><4/><2/><3/>[text part 1]<4/><5/><1/><2/><3/><4/><6/><7/>[text part 2]<8/><9/>[text part 3]<10/><11/><1/><2/><3/><4/><12/><13/>[text part 4]<14/>", (Object)this.fmt.setContent(tf).toString());
        TextUnitUtil.simplifyCodes(tf, false);
        Assert.assertEquals((Object)"<1/>[text part 1]<2/>[text part 2]<3/>[text part 3]<4/>[text part 4]<5/>", (Object)this.fmt.setContent(tf).toString());
        List<Code> codes = tf.getCodes();
        Assert.assertEquals((Object)"[#$s1@%$seg_start$]<x11/><x12/><x13/><x14/>[#$s1@%$seg_end$]$tp_start$", (Object)codes.get(0).toString());
        Assert.assertEquals((Object)"$tp_end$[#$s2@%$seg_start$]<x21/><x22/><x23/><x24/>[#$s2@%$seg_end$]$tp_start$", (Object)codes.get(1).toString());
        Assert.assertEquals((Object)"$tp_end$$tp_start$", (Object)codes.get(2).toString());
        Assert.assertEquals((Object)"$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/><x34/>[#$s3@%$seg_end$]$tp_start$", (Object)codes.get(3).toString());
        Assert.assertEquals((Object)"$tp_end$", (Object)codes.get(4).toString());
        TextUnitUtil.restoreSegmentation(tc, tf);
        Assert.assertEquals((Object)"<x11/><x12/><x13/><x14/>[text part 1]<x21/><x22/><x23/><x24/>[text part 2][text part 3]<x31/><x32/><x33/><x34/>[text part 4]", (Object)tc.toString());
        Iterator<TextPart> it = tc.iterator();
        TextPart part = null;
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue((boolean)part.isSegment());
            Assert.assertEquals((Object)"<x11/><x12/><x13/><x14/>", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse((boolean)part.isSegment());
            Assert.assertEquals((Object)"[text part 1]", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue((boolean)part.isSegment());
            Assert.assertEquals((Object)"<x21/><x22/><x23/><x24/>", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse((boolean)part.isSegment());
            Assert.assertEquals((Object)"[text part 2]", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse((boolean)part.isSegment());
            Assert.assertEquals((Object)"[text part 3]", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue((boolean)part.isSegment());
            Assert.assertEquals((Object)"<x31/><x32/><x33/><x34/>", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse((boolean)part.isSegment());
            Assert.assertEquals((Object)"[text part 4]", (Object)part.toString());
        }
    }

    @Test
    public void testRestoreSegmentation3_2() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append("[seg 1]");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextFragment tf2 = new TextFragment();
        tf2.append("[seg 2]");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x21", "<x21/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x22", "<x22/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x23", "<x23/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x24", "<x24/>");
        TextFragment tf3 = new TextFragment();
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x31", "<x31/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x32", "<x32/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x33", "<x33/>");
        tf3.append("[seg 3]");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x34", "<x34/>");
        Assert.assertEquals((Object)"<1/><2/>[seg 1]<3/><4/>", (Object)this.fmt.setContent(tf1).toString());
        Assert.assertEquals((Object)"[seg 2]<1/><2/><3/><4/>", (Object)this.fmt.setContent(tf2).toString());
        Assert.assertEquals((Object)"<1/><2/><3/>[seg 3]<4/>", (Object)this.fmt.setContent(tf3).toString());
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", tf2));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", tf3));
        tc.append(new TextPart("[text part 4]"));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals((Object)"<1/><1/><2/>[seg 1]<3/><4/><2/><3/>[text part 1]<4/><5/>[seg 2]<1/><2/><3/><4/><6/><7/>[text part 2]<8/><9/>[text part 3]<10/><11/><1/><2/><3/>[seg 3]<4/><12/><13/>[text part 4]<14/>", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"[#$s1@%$seg_start$]<x11/><x12/>[seg 1]<x13/><x14/>[#$s1@%$seg_end$]$tp_start$[text part 1]$tp_end$[#$s2@%$seg_start$][seg 2]<x21/><x22/><x23/><x24/>[#$s2@%$seg_end$]$tp_start$[text part 2]$tp_end$$tp_start$[text part 3]$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/>[seg 3]<x34/>[#$s3@%$seg_end$]$tp_start$[text part 4]$tp_end$", (Object)tf.toText());
        TextUnitUtil.simplifyCodes(tf, false);
        Assert.assertEquals((Object)"<1/>[seg 1]<2/>[text part 1]<3/>[seg 2]<4/>[text part 2]<5/>[text part 3]<6/>[seg 3]<7/>[text part 4]<8/>", (Object)this.fmt.setContent(tf).toString());
        List<Code> codes = tf.getCodes();
        Assert.assertEquals((long)8L, (long)codes.size());
        Assert.assertEquals((Object)"[#$s1@%$seg_start$]<x11/><x12/>", (Object)codes.get(0).toString());
        Assert.assertEquals((Object)"<x13/><x14/>[#$s1@%$seg_end$]$tp_start$", (Object)codes.get(1).toString());
        Assert.assertEquals((Object)"$tp_end$[#$s2@%$seg_start$]", (Object)codes.get(2).toString());
        Assert.assertEquals((Object)"<x21/><x22/><x23/><x24/>[#$s2@%$seg_end$]$tp_start$", (Object)codes.get(3).toString());
        Assert.assertEquals((Object)"$tp_end$$tp_start$", (Object)codes.get(4).toString());
        Assert.assertEquals((Object)"$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/>", (Object)codes.get(5).toString());
        Assert.assertEquals((Object)"<x34/>[#$s3@%$seg_end$]$tp_start$", (Object)codes.get(6).toString());
        Assert.assertEquals((Object)"$tp_end$", (Object)codes.get(7).toString());
        TextUnitUtil.restoreSegmentation(tc, tf);
        Assert.assertEquals((Object)"(0-19: tp_start) (0-31: tp_end) (2: seg_start s1) (9: seg_end s1) (9-0: tp_start) (9-12: tp_end) (11: tp_start) (24: tp_end) (26: seg_start s2) (33: seg_end s2) (33-0: tp_start) (33-24: tp_end) (35: tp_start) (48: tp_end) (50: tp_start) (63: tp_end) (63-27: tp_start) (63-45: tp_end) (65: seg_start s3) (72: seg_end s3) (72-0: tp_start) (72-6: tp_end) (74: tp_start) (87: tp_end)", (Object)TextUnitUtil.testMarkers());
        Assert.assertEquals((Object)"<x11/><x12/>[seg 1]<x13/><x14/>[text part 1][seg 2]<x21/><x22/><x23/><x24/>[text part 2][text part 3]<x31/><x32/><x33/>[seg 3]<x34/>[text part 4]", (Object)tc.toString());
        Assert.assertEquals((long)12L, (long)tc.count());
        Assert.assertTrue((!tc.get(0).isSegment() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)tc.get(1).isSegment());
        Assert.assertTrue((!tc.get(2).isSegment() ? 1 : 0) != 0);
        Assert.assertTrue((!tc.get(3).isSegment() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)tc.get(4).isSegment());
        Assert.assertTrue((!tc.get(5).isSegment() ? 1 : 0) != 0);
        Assert.assertTrue((!tc.get(6).isSegment() ? 1 : 0) != 0);
        Assert.assertTrue((!tc.get(7).isSegment() ? 1 : 0) != 0);
        Assert.assertTrue((!tc.get(8).isSegment() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)tc.get(9).isSegment());
        Assert.assertTrue((!tc.get(10).isSegment() ? 1 : 0) != 0);
        Assert.assertTrue((!tc.get(11).isSegment() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"<x11/><x12/>", (Object)tc.get(0).toString());
        Assert.assertEquals((Object)"[seg 1]", (Object)tc.get(1).toString());
        Assert.assertEquals((Object)"<x13/><x14/>", (Object)tc.get(2).toString());
        Assert.assertEquals((Object)"[text part 1]", (Object)tc.get(3).toString());
        Assert.assertEquals((Object)"[seg 2]", (Object)tc.get(4).toString());
        Assert.assertEquals((Object)"<x21/><x22/><x23/><x24/>", (Object)tc.get(5).toString());
        Assert.assertEquals((Object)"[text part 2]", (Object)tc.get(6).toString());
        Assert.assertEquals((Object)"[text part 3]", (Object)tc.get(7).toString());
        Assert.assertEquals((Object)"<x31/><x32/><x33/>", (Object)tc.get(8).toString());
        Assert.assertEquals((Object)"[seg 3]", (Object)tc.get(9).toString());
        Assert.assertEquals((Object)"<x34/>", (Object)tc.get(10).toString());
        Assert.assertEquals((Object)"[text part 4]", (Object)tc.get(11).toString());
    }

    @Test
    public void testRestoreSegmentation3_3() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append("[seg 1]");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextFragment tf2 = new TextFragment();
        tf2.append("[seg 2]");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x21", "<x21/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x22", "<x22/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x23", "<x23/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x24", "<x24/>");
        TextFragment tf3 = new TextFragment();
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x31", "<x31/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x32", "<x32/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x33", "<x33/>");
        tf3.append("[seg 3]");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x34", "<x34/>");
        Assert.assertEquals((Object)"<1/><2/>[seg 1]<3/><4/>", (Object)this.fmt.setContent(tf1).toString());
        Assert.assertEquals((Object)"[seg 2]<1/><2/><3/><4/>", (Object)this.fmt.setContent(tf2).toString());
        Assert.assertEquals((Object)"<1/><2/><3/>[seg 3]<4/>", (Object)this.fmt.setContent(tf3).toString());
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", tf2));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", tf3));
        tc.append(new TextPart("[text part 4]"));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals((Object)"<1/><1/><2/>[seg 1]<3/><4/><2/><3/>[text part 1]<4/><5/>[seg 2]<1/><2/><3/><4/><6/><7/>[text part 2]<8/><9/>[text part 3]<10/><11/><1/><2/><3/>[seg 3]<4/><12/><13/>[text part 4]<14/>", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"[#$s1@%$seg_start$]<x11/><x12/>[seg 1]<x13/><x14/>[#$s1@%$seg_end$]$tp_start$[text part 1]$tp_end$[#$s2@%$seg_start$][seg 2]<x21/><x22/><x23/><x24/>[#$s2@%$seg_end$]$tp_start$[text part 2]$tp_end$$tp_start$[text part 3]$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/>[seg 3]<x34/>[#$s3@%$seg_end$]$tp_start$[text part 4]$tp_end$", (Object)tf.toText());
        String[] res = TextUnitUtil.simplifyCodes(tf, true);
        Assert.assertEquals((Object)"[seg 1]<2/>[text part 1]<3/>[seg 2]<4/>[text part 2]<5/>[text part 3]<6/>[seg 3]<7/>[text part 4]", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"[seg 1]<x13/><x14/>[#$s1@%$seg_end$]$tp_start$[text part 1]$tp_end$[#$s2@%$seg_start$][seg 2]<x21/><x22/><x23/><x24/>[#$s2@%$seg_end$]$tp_start$[text part 2]$tp_end$$tp_start$[text part 3]$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/>[seg 3]<x34/>[#$s3@%$seg_end$]$tp_start$[text part 4]", (Object)tf.toText());
        Assert.assertEquals((Object)"[#$s1@%$seg_start$]<x11/><x12/>", (Object)res[0]);
        Assert.assertEquals((Object)"$tp_end$", (Object)res[1]);
        List<Code> codes = tf.getCodes();
        Assert.assertEquals((long)6L, (long)codes.size());
        Assert.assertEquals((Object)"<x13/><x14/>[#$s1@%$seg_end$]$tp_start$", (Object)codes.get(0).toString());
        Assert.assertEquals((Object)"$tp_end$[#$s2@%$seg_start$]", (Object)codes.get(1).toString());
        Assert.assertEquals((Object)"<x21/><x22/><x23/><x24/>[#$s2@%$seg_end$]$tp_start$", (Object)codes.get(2).toString());
        Assert.assertEquals((Object)"$tp_end$$tp_start$", (Object)codes.get(3).toString());
        Assert.assertEquals((Object)"$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/>", (Object)codes.get(4).toString());
        Assert.assertEquals((Object)"<x34/>[#$s3@%$seg_end$]$tp_start$", (Object)codes.get(5).toString());
        TextUnitUtil.restoreSegmentation(tc, tf);
        Assert.assertEquals((Object)"(7: seg_end s1) (7-0: tp_start) (7-12: tp_end) (9: tp_start) (22: tp_end) (24: seg_start s2) (31: seg_end s2) (31-0: tp_start) (31-24: tp_end) (33: tp_start) (46: tp_end) (48: tp_start) (61: tp_end) (61-27: tp_start) (61-45: tp_end) (63: seg_start s3) (70: seg_end s3) (70-0: tp_start) (70-6: tp_end) (72: tp_start)", (Object)TextUnitUtil.testMarkers());
        Assert.assertEquals((Object)"<x13/><x14/>[text part 1][seg 2]<x21/><x22/><x23/><x24/>[text part 2][text part 3]<x31/><x32/><x33/>[seg 3]<x34/>", (Object)tc.toString());
        TextPart part = null;
        Assert.assertEquals((long)9L, (long)tc.count());
        part = tc.get(0);
        Assert.assertFalse((boolean)part.isSegment());
        Assert.assertEquals((Object)"<x13/><x14/>", (Object)part.toString());
        part = tc.get(1);
        Assert.assertFalse((boolean)part.isSegment());
        Assert.assertEquals((Object)"[text part 1]", (Object)part.toString());
        part = tc.get(2);
        Assert.assertTrue((boolean)part.isSegment());
        Assert.assertEquals((Object)"[seg 2]", (Object)part.toString());
        part = tc.get(3);
        Assert.assertFalse((boolean)part.isSegment());
        Assert.assertEquals((Object)"<x21/><x22/><x23/><x24/>", (Object)part.toString());
        part = tc.get(4);
        Assert.assertFalse((boolean)part.isSegment());
        Assert.assertEquals((Object)"[text part 2]", (Object)part.toString());
        part = tc.get(5);
        Assert.assertFalse((boolean)part.isSegment());
        Assert.assertEquals((Object)"[text part 3]", (Object)part.toString());
        part = tc.get(6);
        Assert.assertFalse((boolean)part.isSegment());
        Assert.assertEquals((Object)"<x31/><x32/><x33/>", (Object)part.toString());
        part = tc.get(7);
        Assert.assertTrue((boolean)part.isSegment());
        Assert.assertEquals((Object)"[seg 3]", (Object)part.toString());
        part = tc.get(8);
        Assert.assertFalse((boolean)part.isSegment());
        Assert.assertEquals((Object)"<x34/>", (Object)part.toString());
    }

    @Test
    public void testRestoreSegmentation3_4() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append("[seg 1]");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextFragment tf2 = new TextFragment();
        tf2.append("[seg 2]");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x21", "<x21/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x22", "<x22/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x23", "<x23/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x24", "<x24/>");
        TextFragment tf3 = new TextFragment();
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x31", "<x31/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x32", "<x32/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x33", "<x33/>");
        tf3.append("[seg 3]");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x34", "<x34/>");
        Assert.assertEquals((Object)"<1/><2/>[seg 1]<3/><4/>", (Object)this.fmt.setContent(tf1).toString());
        Assert.assertEquals((Object)"[seg 2]<1/><2/><3/><4/>", (Object)this.fmt.setContent(tf2).toString());
        Assert.assertEquals((Object)"<1/><2/><3/>[seg 3]<4/>", (Object)this.fmt.setContent(tf3).toString());
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", tf2));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", tf3));
        tc.append(new TextPart("[text part 4]"));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals((Object)"<1/><1/><2/>[seg 1]<3/><4/><2/><3/>[text part 1]<4/><5/>[seg 2]<1/><2/><3/><4/><6/><7/>[text part 2]<8/><9/>[text part 3]<10/><11/><1/><2/><3/>[seg 3]<4/><12/><13/>[text part 4]<14/>", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"[#$s1@%$seg_start$]<x11/><x12/>[seg 1]<x13/><x14/>[#$s1@%$seg_end$]$tp_start$[text part 1]$tp_end$[#$s2@%$seg_start$][seg 2]<x21/><x22/><x23/><x24/>[#$s2@%$seg_end$]$tp_start$[text part 2]$tp_end$$tp_start$[text part 3]$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/>[seg 3]<x34/>[#$s3@%$seg_end$]$tp_start$[text part 4]$tp_end$", (Object)tf.toText());
        String[] res = TextUnitUtil.simplifyCodes(tc, true);
        Assert.assertEquals((Object)"<1/><1/><2/>[seg 1]<3/><4/><2/><3/>[text part 1]<4/><5/>[seg 2]<1/><2/><3/><4/><6/><7/>[text part 2]<8/><9/>[text part 3]<10/><11/><1/><2/><3/>[seg 3]<4/><12/><13/>[text part 4]<14/>", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"[#$s1@%$seg_start$]<x11/><x12/>[seg 1]<x13/><x14/>[#$s1@%$seg_end$]$tp_start$[text part 1]$tp_end$[#$s2@%$seg_start$][seg 2]<x21/><x22/><x23/><x24/>[#$s2@%$seg_end$]$tp_start$[text part 2]$tp_end$$tp_start$[text part 3]$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/>[seg 3]<x34/>[#$s3@%$seg_end$]$tp_start$[text part 4]$tp_end$", (Object)tf.toText());
        Assert.assertEquals((Object)"<x11/><x12/>", (Object)res[0]);
        Assert.assertEquals((Object)"", (Object)res[1]);
        TextPart part = null;
        Assert.assertEquals((long)11L, (long)tc.count());
        part = tc.get(0);
        Assert.assertTrue((boolean)part.isSegment());
        Assert.assertEquals((Object)"[seg 1]", (Object)part.toString());
        part = tc.get(1);
        Assert.assertFalse((boolean)part.isSegment());
        Assert.assertEquals((Object)"<x13/><x14/>", (Object)part.toString());
        part = tc.get(2);
        Assert.assertFalse((boolean)part.isSegment());
        Assert.assertEquals((Object)"[text part 1]", (Object)part.toString());
        part = tc.get(3);
        Assert.assertTrue((boolean)part.isSegment());
        Assert.assertEquals((Object)"[seg 2]", (Object)part.toString());
        part = tc.get(4);
        Assert.assertFalse((boolean)part.isSegment());
        Assert.assertEquals((Object)"<x21/><x22/><x23/><x24/>", (Object)part.toString());
        part = tc.get(5);
        Assert.assertFalse((boolean)part.isSegment());
        Assert.assertEquals((Object)"[text part 2]", (Object)part.toString());
        part = tc.get(6);
        Assert.assertFalse((boolean)part.isSegment());
        Assert.assertEquals((Object)"[text part 3]", (Object)part.toString());
        part = tc.get(7);
        Assert.assertFalse((boolean)part.isSegment());
        Assert.assertEquals((Object)"<x31/><x32/><x33/>", (Object)part.toString());
        part = tc.get(8);
        Assert.assertTrue((boolean)part.isSegment());
        Assert.assertEquals((Object)"[seg 3]", (Object)part.toString());
        part = tc.get(9);
        Assert.assertFalse((boolean)part.isSegment());
        Assert.assertEquals((Object)"<x34/>", (Object)part.toString());
        part = tc.get(10);
        Assert.assertFalse((boolean)part.isSegment());
        Assert.assertEquals((Object)"[text part 4]", (Object)part.toString());
    }

    @Test
    public void testExtractSegMarkers() {
        String st = "$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/><x34/>[#$s3@%$seg_end$]$tp_start$";
        TextFragment tf = new TextFragment();
        String res = TextUnitUtil.extractSegMarkers(tf, st, false);
        Assert.assertEquals((Object)"<1/><2/><3/><4/>", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/><x34/>[#$s3@%$seg_end$]$tp_start$", (Object)res);
        List<Code> codes = tf.getCodes();
        Assert.assertEquals((long)4L, (long)codes.size());
        Assert.assertEquals((Object)"$tp_end$", (Object)codes.get(0).toString());
        Assert.assertEquals((Object)"[#$s3@%$seg_start$]", (Object)codes.get(1).toString());
        Assert.assertEquals((Object)"[#$s3@%$seg_end$]", (Object)codes.get(2).toString());
        Assert.assertEquals((Object)"$tp_start$", (Object)codes.get(3).toString());
        tf = new TextFragment();
        res = TextUnitUtil.extractSegMarkers(tf, st, true);
        Assert.assertEquals((Object)"<1/><2/><3/><4/>", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<x31/><x32/><x33/><x34/>", (Object)res);
        codes = tf.getCodes();
        Assert.assertEquals((long)4L, (long)codes.size());
        Assert.assertEquals((Object)"$tp_end$", (Object)codes.get(0).toString());
        Assert.assertEquals((Object)"[#$s3@%$seg_start$]", (Object)codes.get(1).toString());
        Assert.assertEquals((Object)"[#$s3@%$seg_end$]", (Object)codes.get(2).toString());
        Assert.assertEquals((Object)"$tp_start$", (Object)codes.get(3).toString());
    }

    @Test
    public void testRestoreSegmentation4() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x21", "<x21/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x22", "<x22/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x23", "<x23/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x24", "<x24/>");
        TextFragment tf3 = new TextFragment();
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x31", "<x31/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x32", "<x32/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x33", "<x33/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x34", "<x34/>");
        Assert.assertEquals((Object)"<1/><2/><3/><4/>", (Object)this.fmt.setContent(tf1).toString());
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", tf2));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", tf3));
        tc.append(new TextPart("[text part 4]"));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals((Object)"<1/><1/><2/><3/><4/><2/><3/>[text part 1]<4/><5/><1/><2/><3/><4/><6/><7/>[text part 2]<8/><9/>[text part 3]<10/><11/><1/><2/><3/><4/><12/><13/>[text part 4]<14/>", (Object)this.fmt.setContent(tf).toString());
        TextUnitUtil.restoreSegmentation(tc, tf);
        Assert.assertEquals((Object)"<x11/><x12/><x13/><x14/>[text part 1]<x21/><x22/><x23/><x24/>[text part 2][text part 3]<x31/><x32/><x33/><x34/>[text part 4]", (Object)tc.toString());
    }

    @Test
    public void testRestoreSegmentation5() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x1", "[#$0@%$seg_start$]");
        tf1.append("T1");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x2", "[#$0@%$seg_end$]$tp_start$ $tp_end$[#$1@%$seg_start$]<br /> <br />");
        tf1.append(" T2");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x3", "[#$1@%$seg_end$]");
        TextContainer tc = new TextContainer();
        TextUnitUtil.restoreSegmentation(tc, tf1);
        Assert.assertEquals((Object)"T1 <br /> <br /> T2", (Object)tc.toString());
        Assert.assertEquals((long)4L, (long)tc.count());
        Segment s1 = tc.getSegments().get(0);
        Segment s2 = tc.getSegments().get(1);
        Assert.assertEquals((Object)"T1", (Object)s1.getContent().toText());
        Assert.assertEquals((Object)" T2", (Object)s2.getContent().toText());
        Iterator<TextPart> it = tc.iterator();
        TextPart part = null;
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue((boolean)part.isSegment());
            Assert.assertEquals((Object)"T1", (Object)part.toString());
            Assert.assertEquals((Object)"0", (Object)((Segment)part).getId());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse((boolean)part.isSegment());
            Assert.assertEquals((Object)" ", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse((boolean)part.isSegment());
            Assert.assertEquals((Object)"<br /> <br />", (Object)part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue((boolean)part.isSegment());
            Assert.assertEquals((Object)" T2", (Object)part.toString());
            Assert.assertEquals((Object)"1", (Object)((Segment)part).getId());
        }
    }

    @Test
    public void testRestoreSegmentation6() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x1", "[#$0@%$seg_start$]   [#$0@%$seg_end$]$tp_start$  $tp_end$$tp_start$ $tp_end$$tp_start$  $tp_end$[#$1@%$seg_start$]");
        tf1.append("T1");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x2", "[#$1@%$seg_end$]");
        TextContainer tc = new TextContainer();
        TextUnitUtil.restoreSegmentation(tc, tf1);
        Assert.assertEquals((Object)"        T1", (Object)tc.toString());
        Assert.assertEquals((long)5L, (long)tc.count());
        Assert.assertEquals((long)2L, (long)tc.getSegments().count());
        Segment s1 = tc.getSegments().get(0);
        Segment s2 = tc.getSegments().get(1);
        Assert.assertEquals((Object)"   ", (Object)s1.getContent().toText());
        Assert.assertEquals((Object)"T1", (Object)s2.getContent().toText());
    }

    @Test
    public void testRestoreSegmentation7() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x1", "[<br1> <br2> [#$0@%$seg_end$][#$1@%$seg_start$][#$1@%$seg_end$]$tp_start$ T1 $tp_end$$tp_start$ T2 $tp_end$[#$2@%$seg_start$]<br /> <br />]");
        TextContainer tc = new TextContainer();
        TextUnitUtil.restoreSegmentation(tc, tf1);
        Assert.assertEquals((Object)"[<br1> <br2>  T1  T2 <br /> <br />]", (Object)tc.toString());
        Assert.assertEquals((long)5L, (long)tc.count());
        TextPart tp1 = tc.get(0);
        Assert.assertEquals((Object)"[<br1> <br2> ", (Object)tp1.getContent().toText());
        TextPart tp2 = tc.get(1);
        Assert.assertEquals((Object)"", (Object)tp2.getContent().toText());
        TextPart tp4 = tc.get(2);
        Assert.assertEquals((Object)" T1 ", (Object)tp4.getContent().toText());
        TextPart tp5 = tc.get(3);
        Assert.assertEquals((Object)" T2 ", (Object)tp5.getContent().toText());
        TextPart tp6 = tc.get(4);
        Assert.assertEquals((Object)"<br /> <br />]", (Object)tp6.getContent().toText());
        Assert.assertEquals((long)1L, (long)tc.getSegments().count());
        Segment s1 = tc.getSegments().get(0);
        Assert.assertEquals((Object)"", (Object)s1.getContent().toText());
    }

    @Test
    public void testTrimSegments() {
        TextFragment tf1 = new TextFragment();
        tf1.append(" [seg 1]");
        TextFragment tf2 = new TextFragment();
        tf2.append("  [seg 2]   ");
        TextFragment tf3 = new TextFragment();
        tf3.append("    [seg 3]     ");
        TextFragment tf4 = new TextFragment();
        tf4.append("[seg 4]");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new Segment("s2", tf2));
        tc.append(new Segment("s3", tf3));
        tc.append(new Segment("s4", tf4));
        Assert.assertEquals((Object)" [seg 1]  [seg 2]       [seg 3]     [seg 4]", (Object)tc.toString());
        Assert.assertEquals((long)4L, (long)tc.count());
        Assert.assertTrue((boolean)tc.get(0).isSegment());
        Assert.assertTrue((boolean)tc.get(1).isSegment());
        Assert.assertTrue((boolean)tc.get(2).isSegment());
        Assert.assertTrue((boolean)tc.get(3).isSegment());
        Assert.assertEquals((Object)" [seg 1]", (Object)tc.get(0).toString());
        Assert.assertEquals((Object)"  [seg 2]   ", (Object)tc.get(1).toString());
        Assert.assertEquals((Object)"    [seg 3]     ", (Object)tc.get(2).toString());
        Assert.assertEquals((Object)"[seg 4]", (Object)tc.get(3).toString());
        TextUnitUtil.trimSegments(tc);
        Assert.assertEquals((long)9L, (long)tc.count());
        Assert.assertTrue((!tc.get(0).isSegment() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)tc.get(1).isSegment());
        Assert.assertTrue((!tc.get(2).isSegment() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)tc.get(3).isSegment());
        Assert.assertTrue((!tc.get(4).isSegment() ? 1 : 0) != 0);
        Assert.assertTrue((!tc.get(5).isSegment() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)tc.get(6).isSegment());
        Assert.assertTrue((!tc.get(7).isSegment() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)tc.get(8).isSegment());
        Assert.assertEquals((Object)" ", (Object)tc.get(0).toString());
        Assert.assertEquals((Object)"[seg 1]", (Object)tc.get(1).toString());
        Assert.assertEquals((Object)"  ", (Object)tc.get(2).toString());
        Assert.assertEquals((Object)"[seg 2]", (Object)tc.get(3).toString());
        Assert.assertEquals((Object)"   ", (Object)tc.get(4).toString());
        Assert.assertEquals((Object)"    ", (Object)tc.get(5).toString());
        Assert.assertEquals((Object)"[seg 3]", (Object)tc.get(6).toString());
        Assert.assertEquals((Object)"     ", (Object)tc.get(7).toString());
        Assert.assertEquals((Object)"[seg 4]", (Object)tc.get(8).toString());
    }

    @Test
    public void testTrimSegments_leading() {
        TextFragment tf1 = new TextFragment();
        tf1.append(" [seg 1]");
        TextFragment tf2 = new TextFragment();
        tf2.append("  [seg 2]   ");
        TextFragment tf3 = new TextFragment();
        tf3.append("    [seg 3]     ");
        TextFragment tf4 = new TextFragment();
        tf4.append("[seg 4]");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new Segment("s2", tf2));
        tc.append(new Segment("s3", tf3));
        tc.append(new Segment("s4", tf4));
        Assert.assertEquals((Object)" [seg 1]  [seg 2]       [seg 3]     [seg 4]", (Object)tc.toString());
        Assert.assertEquals((long)4L, (long)tc.count());
        Assert.assertTrue((boolean)tc.get(0).isSegment());
        Assert.assertTrue((boolean)tc.get(1).isSegment());
        Assert.assertTrue((boolean)tc.get(2).isSegment());
        Assert.assertTrue((boolean)tc.get(3).isSegment());
        Assert.assertEquals((Object)" [seg 1]", (Object)tc.get(0).toString());
        Assert.assertEquals((Object)"  [seg 2]   ", (Object)tc.get(1).toString());
        Assert.assertEquals((Object)"    [seg 3]     ", (Object)tc.get(2).toString());
        Assert.assertEquals((Object)"[seg 4]", (Object)tc.get(3).toString());
        TextUnitUtil.trimSegments(tc, true, false);
        Assert.assertEquals((long)7L, (long)tc.count());
        Assert.assertTrue((!tc.get(0).isSegment() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)tc.get(1).isSegment());
        Assert.assertTrue((!tc.get(2).isSegment() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)tc.get(3).isSegment());
        Assert.assertTrue((!tc.get(4).isSegment() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)tc.get(5).isSegment());
        Assert.assertTrue((boolean)tc.get(6).isSegment());
        Assert.assertEquals((Object)" ", (Object)tc.get(0).toString());
        Assert.assertEquals((Object)"[seg 1]", (Object)tc.get(1).toString());
        Assert.assertEquals((Object)"  ", (Object)tc.get(2).toString());
        Assert.assertEquals((Object)"[seg 2]   ", (Object)tc.get(3).toString());
        Assert.assertEquals((Object)"    ", (Object)tc.get(4).toString());
        Assert.assertEquals((Object)"[seg 3]     ", (Object)tc.get(5).toString());
        Assert.assertEquals((Object)"[seg 4]", (Object)tc.get(6).toString());
    }

    @Test
    public void testTrimSegments_trailing() {
        TextFragment tf1 = new TextFragment();
        tf1.append(" [seg 1]");
        TextFragment tf2 = new TextFragment();
        tf2.append("  [seg 2]   ");
        TextFragment tf3 = new TextFragment();
        tf3.append("    [seg 3]     ");
        TextFragment tf4 = new TextFragment();
        tf4.append("[seg 4]");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new Segment("s2", tf2));
        tc.append(new Segment("s3", tf3));
        tc.append(new Segment("s4", tf4));
        Assert.assertEquals((Object)" [seg 1]  [seg 2]       [seg 3]     [seg 4]", (Object)tc.toString());
        Assert.assertEquals((long)4L, (long)tc.count());
        Assert.assertTrue((boolean)tc.get(0).isSegment());
        Assert.assertTrue((boolean)tc.get(1).isSegment());
        Assert.assertTrue((boolean)tc.get(2).isSegment());
        Assert.assertTrue((boolean)tc.get(3).isSegment());
        Assert.assertEquals((Object)" [seg 1]", (Object)tc.get(0).toString());
        Assert.assertEquals((Object)"  [seg 2]   ", (Object)tc.get(1).toString());
        Assert.assertEquals((Object)"    [seg 3]     ", (Object)tc.get(2).toString());
        Assert.assertEquals((Object)"[seg 4]", (Object)tc.get(3).toString());
        TextUnitUtil.trimSegments(tc, false, true);
        Assert.assertEquals((long)6L, (long)tc.count());
        Assert.assertTrue((boolean)tc.get(0).isSegment());
        Assert.assertTrue((boolean)tc.get(1).isSegment());
        Assert.assertTrue((!tc.get(2).isSegment() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)tc.get(3).isSegment());
        Assert.assertTrue((!tc.get(4).isSegment() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)tc.get(5).isSegment());
        Assert.assertEquals((Object)" [seg 1]", (Object)tc.get(0).toString());
        Assert.assertEquals((Object)"  [seg 2]", (Object)tc.get(1).toString());
        Assert.assertEquals((Object)"   ", (Object)tc.get(2).toString());
        Assert.assertEquals((Object)"    [seg 3]", (Object)tc.get(3).toString());
        Assert.assertEquals((Object)"     ", (Object)tc.get(4).toString());
        Assert.assertEquals((Object)"[seg 4]", (Object)tc.get(5).toString());
    }

    private TextFragment makeFragment1() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "b", "[b]");
        tf.append("A");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "[br/]");
        tf.append("B");
        tf.append(TextFragment.TagType.CLOSING, "b", "[/b]");
        tf.append("C");
        return tf;
    }

    private TextFragment makeFragment1Bis(String extra) {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "b", "{B}");
        tf.append("A");
        tf.append(TextFragment.TagType.CLOSING, "b", "{/B}");
        tf.append("B");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "{BR/}");
        tf.append("C " + extra);
        return tf;
    }

    private ITextUnit createTextUnit1() {
        TextUnit tu = new TextUnit("1", "t ");
        TextFragment tf = tu.getSource().getSegments().getFirstContent();
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("bold");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(" t ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        return tu;
    }
}

