/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.promt;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    protected static final String HOST = "host";
    protected static final String USERNAME = "username";
    protected static final String PASSWORD = "password";
    private String host;
    private String username;
    private String password;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Parameters() {
        this.reset();
        this.toString();
    }

    public Parameters(String initialData) {
        this.fromString(initialData);
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.host = this.buffer.getString(HOST, this.host);
        this.username = this.buffer.getString(USERNAME, this.username);
        this.password = this.buffer.getEncodedString(PASSWORD, this.password);
    }

    @Override
    public void reset() {
        this.host = "ptsdemo.promt.ru/";
        this.username = "";
        this.password = "";
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString(HOST, this.host);
        this.buffer.setString(USERNAME, this.username);
        this.buffer.setEncodedString(PASSWORD, this.password);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(HOST, "Host server", "The root URL of the host server (e.g. http://ptsdemo.promt.ru/");
        desc.add(USERNAME, "User name (optional)", "The login name to use");
        desc.add(PASSWORD, "Password (if needed)", "The password for the given user name");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("ProMT Connector Settings");
        desc.addTextInputPart(paramsDesc.get(HOST));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(USERNAME));
        tip.setAllowEmpty(true);
        tip = desc.addTextInputPart(paramsDesc.get(PASSWORD));
        tip.setPassword(true);
        tip.setAllowEmpty(true);
        return desc;
    }
}

