/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mif;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiIllegalFilterOperationException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.mif.FrameRomanCharsetProvider;
import net.sf.okapi.filters.mif.MIFEncoder;
import net.sf.okapi.filters.mif.MIFFilterWriter;
import net.sf.okapi.filters.mif.MIFToken;
import net.sf.okapi.filters.mif.Parameters;

@UsingParameters(value=Parameters.class)
public class MIFFilter
implements IFilter {
    public static final String FRAMEROMAN = "x-FrameRoman";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final int BLOCKTYPE_TEXTFLOW = 1;
    private static final int BLOCKTYPE_TABLE = 2;
    private static final Hashtable<String, String> charTable = MIFFilter.initCharTable();
    private static final Hashtable<String, String> encodingTable = MIFFilter.initEncodingTable();
    private static final String TOPSTATEMENTSTOSKIP = "ColorCatalog;ConditionCatalog;BoolCondCatalog;CombinedFontCatalog;PgfCatalog;ElementDefCatalog;FmtChangeListCatalog;DefAttrValuesCatalog;AttrCondExprCatalog;FontCatalog;RulingCatalog;TblCatalog;KumihanCatalog;Views;MarkerTypeCatalog;XRefFormats;Document;BookComponent;InitialAutoNums;Dictionary;AFrames;Page;";
    private static final String IMPORTOBJECT = "ImportObject";
    private Parameters params = new Parameters();
    private String lineBreak;
    private String docName;
    private BufferedReader reader;
    private StringBuilder tagBuffer;
    private StringBuilder strBuffer;
    private int tuId;
    private int otherId;
    private int grpId;
    private boolean canceled;
    private LinkedList<Event> queue;
    private LocaleId srcLang;
    private GenericSkeleton skel;
    private boolean hasNext;
    private EncoderManager encoderManager;
    private int inBlock;
    private int blockLevel;
    private String version;
    private int paraLevel;
    private StringBuilder paraSkelBuf;
    private StringBuilder paraTextBuf;
    private StringBuilder paraCodeBuf;
    private StringBuilder paraCodeTypes;
    private int tableGroupLevel;
    private int rowGroupLevel;
    private int cellGroupLevel;
    private int fnoteGroupLevel;
    private Stack<String> parentIds;
    private ArrayList<Integer> textFlows;
    private ArrayList<String> tables;
    private boolean secondPass;
    private ByteArrayOutputStream byteStream;
    private FrameRomanCharsetProvider csProvider;
    private CharsetDecoder[] decoders;
    private boolean[] doubleConversion;
    private CharsetDecoder firstDecoder;
    private CharsetEncoder[] encoders;
    private CharsetDecoder currentDecoder;
    private boolean doDoubleConversion;
    private int currentCharsetIndex;
    private MIFEncoder encoder;
    private int decodingErrors;
    private String baseEncoding;
    private boolean useUTF;
    private String resname;
    private int footnotesLevel;
    private int textFlowNumber;
    private ITextUnit refTU;

    private static Hashtable<String, String> initCharTable() {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("Tab", "\t");
        table.put("HardSpace", "\u00a0");
        table.put("SoftHyphen", "");
        table.put("HardHyphen", "\u2011");
        table.put("DiscHyphen", "\u00ad");
        table.put("NoHyphen", "\u200d");
        table.put("Cent", "\u00a2");
        table.put("Pound", "\u00a3");
        table.put("Yen", "\u00a5");
        table.put("EnDash", "\u2013");
        table.put("EmDash", "\u2014");
        table.put("Dagger", "\u2020");
        table.put("DoubleDagger", "\u2021");
        table.put("Bullet", "\u2022");
        table.put("HardReturn", "\n");
        table.put("NumberSpace", "\u2007");
        table.put("ThinSpace", "\u2009");
        table.put("EnSpace", "\u2002");
        table.put("EmSpace", "\u2003");
        return table;
    }

    private static Hashtable<String, String> initEncodingTable() {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("FrameRoman", FRAMEROMAN);
        table.put("JISX0208.ShiftJIS", "Shift_JIS");
        table.put("BIG5", "Big5");
        table.put("GB2312-80.EUC", "GB2312");
        table.put("KSC5601-1992", "EUC-KR");
        return table;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            this.hasNext = false;
            this.docName = null;
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public String getName() {
        return "okf_mif";
    }

    @Override
    public String getDisplayName() {
        return "MIF Filter";
    }

    @Override
    public String getMimeType() {
        return "application/vnd.mif";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "application/vnd.mif", this.getClass().getName(), "MIF (BETA)", "Adobe FrameMaker MIF documents", null, ".mif;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("application/vnd.mif", "net.sf.okapi.filters.mif.MIFEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.close();
        if (input.getInputURI() == null && input.getInputCharSequence() == null) {
            throw new OkapiBadFilterInputException("Direct stream input not supported for MIF.");
        }
        this.srcLang = input.getSourceLocale();
        if (input.getInputURI() != null) {
            this.docName = input.getInputURI().getPath();
        }
        input.setEncoding("UTF-8");
        this.open(input.getStream(), input);
    }

    private void initialize() {
        this.tagBuffer = new StringBuilder();
        this.strBuffer = new StringBuilder();
        this.paraSkelBuf = new StringBuilder();
        this.paraCodeBuf = new StringBuilder();
        this.paraCodeTypes = new StringBuilder();
        this.paraTextBuf = new StringBuilder();
        this.tuId = 0;
        this.otherId = 0;
        this.grpId = 0;
        this.canceled = false;
        this.hasNext = true;
        this.inBlock = 0;
        this.blockLevel = 0;
        this.lineBreak = "\n";
        this.tableGroupLevel = -1;
        this.rowGroupLevel = -1;
        this.cellGroupLevel = -1;
        this.fnoteGroupLevel = -1;
        this.parentIds = new Stack();
        this.encoder = new MIFEncoder();
        this.decodingErrors = 0;
        this.footnotesLevel = -1;
        this.textFlowNumber = 0;
    }

    private void open(InputStream input, RawDocument rd) {
        try {
            this.csProvider = new FrameRomanCharsetProvider();
            this.version = "";
            InputStream bomAwareInput = this.guessEncoding(input);
            CharsetDecoder decoder = this.baseEncoding.equals(FRAMEROMAN) ? this.csProvider.charsetForName(FRAMEROMAN).newDecoder() : Charset.forName(this.baseEncoding).newDecoder();
            this.reader = new BufferedReader(new InputStreamReader(bomAwareInput, decoder));
            this.initialize();
            this.secondPass = false;
            this.textFlows = new ArrayList();
            this.tables = new ArrayList();
            this.gatherExtractionInformation();
            this.reader.close();
            input.close();
            this.secondPass = true;
            input = rd.getStream();
            bomAwareInput = this.guessEncoding(input);
            this.reader = new BufferedReader(new InputStreamReader(bomAwareInput, decoder));
            this.initialize();
            String sdId = rd.getId();
            if (Util.isEmpty(sdId)) {
                sdId = "sd1";
            }
            this.parentIds.push(sdId);
            if (this.params.getUseCodeFinder()) {
                this.params.getCodeFinder().compile();
            }
            this.firstDecoder = this.csProvider.charsetForName(FRAMEROMAN).newDecoder();
            this.currentCharsetIndex = 0;
            this.doubleConversion = new boolean[2];
            this.doubleConversion[0] = false;
            this.doubleConversion[1] = false;
            this.doDoubleConversion = this.doubleConversion[this.currentCharsetIndex];
            this.decoders = new CharsetDecoder[2];
            this.decoders[0] = this.baseEncoding.equals(FRAMEROMAN) ? this.firstDecoder : Charset.forName(this.baseEncoding).newDecoder();
            this.decoders[1] = this.decoders[0];
            this.currentDecoder = this.decoders[this.currentCharsetIndex];
            this.encoders = new CharsetEncoder[2];
            this.encoders[0] = this.baseEncoding.equals(FRAMEROMAN) ? this.csProvider.charsetForName(this.baseEncoding).newEncoder() : Charset.forName(this.baseEncoding).newEncoder();
            this.encoders[1] = this.encoders[0];
            this.byteStream = new ByteArrayOutputStream(20);
            this.queue = new LinkedList();
            StartDocument startDoc = new StartDocument(sdId);
            startDoc.setName(this.docName);
            startDoc.setLineBreak(this.lineBreak);
            startDoc.setEncoding(this.baseEncoding, false);
            startDoc.setLocale(this.srcLang);
            startDoc.setFilterParameters(this.getParameters());
            startDoc.setFilterWriter(this.createFilterWriter());
            startDoc.setType(this.getMimeType());
            startDoc.setMimeType(this.getMimeType());
            this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiUnsupportedEncodingException("Error reading MIF input.", e);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error reading MIF input.", e);
        }
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public Event next() {
        if (this.canceled) {
            this.queue.clear();
            this.queue.add(new Event(EventType.CANCELED));
            this.hasNext = false;
        }
        if (this.queue.isEmpty()) {
            this.read();
        }
        if (this.queue.peek().getEventType() == EventType.END_DOCUMENT) {
            this.hasNext = false;
        }
        return this.queue.poll();
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new MIFFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    private void read() {
        try {
            int c;
            this.skel = new GenericSkeleton();
            if (this.inBlock > 0) {
                this.processBlock(this.inBlock, false);
                return;
            }
            block7: while ((c = this.reader.read()) != -1) {
                switch (c) {
                    case 35: {
                        this.skel.append((char)c);
                        this.readComment(true, null);
                        continue block7;
                    }
                    case 60: {
                        this.skel.append((char)c);
                        ++this.blockLevel;
                        String tag = this.readTag(true, true, null);
                        if (TOPSTATEMENTSTOSKIP.indexOf(tag + ";") > -1) {
                            this.skipOverContent(true, null);
                            --this.blockLevel;
                        } else if ("TextFlow".equals(tag)) {
                            ++this.textFlowNumber;
                            if (this.startBlock(this.blockLevel, 1)) {
                                return;
                            }
                        } else {
                            if ("Tbls".equals(tag)) continue block7;
                            if ("Tbl".equals(tag)) {
                                if (this.startBlock(this.blockLevel, 2)) {
                                    return;
                                }
                            } else if ("VariableFormats".equals(tag)) {
                                if (this.params.getExtractVariables()) {
                                    this.processVariables();
                                } else {
                                    this.skipOverContent(true, null);
                                    --this.blockLevel;
                                }
                            } else if ("MIFFile".equals(tag)) {
                                this.getNextTokenInStatement(true, null, true);
                            } else {
                                this.skipOverContent(true, null);
                                --this.blockLevel;
                            }
                        }
                        this.queue.add(new Event(EventType.DOCUMENT_PART, new DocumentPart(String.valueOf(++this.otherId), false), this.skel));
                        return;
                    }
                    case 62: {
                        this.skel.append((char)c);
                        --this.blockLevel;
                        DocumentPart dp = new DocumentPart(String.valueOf(++this.otherId), false, this.skel);
                        this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
                        return;
                    }
                }
                this.skel.append((char)c);
            }
            Ending ending = new Ending(String.valueOf(++this.otherId));
            this.queue.add(new Event(EventType.END_DOCUMENT, ending, this.skel));
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    private void gatherExtractionInformation() {
        try {
            boolean inEscape = false;
            boolean inString = false;
            ArrayList<String> trToExtract = new ArrayList<String>();
            ArrayList<String> tblIds = new ArrayList<String>();
            boolean hasPages = false;
            block11: while (true) {
                MIFToken token;
                int res = -1;
                while (res == -1) {
                    int c = this.reader.read();
                    if (inString) {
                        if (c != 39) continue;
                        inString = false;
                        continue;
                    }
                    if (inEscape) {
                        inEscape = false;
                        continue;
                    }
                    switch (c) {
                        case -1: {
                            if (!hasPages) {
                                this.textFlows = null;
                                this.tables = null;
                            }
                            return;
                        }
                        case 96: {
                            inString = true;
                            break;
                        }
                        case 92: {
                            inEscape = true;
                            break;
                        }
                        case 60: {
                            ++this.blockLevel;
                            res = 1;
                            break;
                        }
                        case 62: {
                            --this.blockLevel;
                            res = 0;
                        }
                    }
                }
                if (res != 1) continue;
                String tag = this.readTag(false, false, null);
                if (tag.equals("Page")) {
                    String pageType = null;
                    String textRectId = null;
                    hasPages = true;
                    while ((tag = this.readUntil("PageType;TextRect;", false, null, this.blockLevel, true)) != null) {
                        if (tag.equals("PageType")) {
                            token = this.getNextTokenInStatement(false, null, true);
                            if (token.getType() != 1) {
                                throw new OkapiIOException("Missing PageType value.");
                            }
                            pageType = token.getString();
                            if (textRectId == null) continue;
                            break;
                        }
                        if (!tag.equals("TextRect")) continue;
                        tag = this.readUntil("ID;", false, null, this.blockLevel, true);
                        if (tag != null) {
                            token = this.getNextTokenInStatement(false, null, true);
                            if (token.getType() != 1) {
                                throw new OkapiIOException("Missing ID value.");
                            }
                        } else {
                            throw new OkapiIOException("ID statement not found.");
                        }
                        textRectId = token.getString();
                        if (pageType == null) continue;
                    }
                    if (Util.isEmpty(pageType) || Util.isEmpty(textRectId)) continue;
                    if (pageType.equals("BodyPage")) {
                        if (!this.params.getExtractBodyPages()) continue;
                        trToExtract.add(textRectId);
                        continue;
                    }
                    if (pageType.equals("ReferencePage")) {
                        if (!this.params.getExtractReferencePages()) continue;
                        trToExtract.add(textRectId);
                        continue;
                    }
                    if (pageType.equals("HiddenPage")) {
                        if (!this.params.getExtractHiddenPages()) continue;
                        trToExtract.add(textRectId);
                        continue;
                    }
                    if (pageType.endsWith("MasterPage")) {
                        if (!this.params.getExtractMasterPages()) continue;
                        trToExtract.add(textRectId);
                        continue;
                    }
                    trToExtract.add(textRectId);
                    this.logger.warning(String.format("Unknown page type '%s' (It will be extracted)", pageType));
                    continue;
                }
                if (tag.equals("TextFlow")) {
                    ++this.textFlowNumber;
                    String textRectId = null;
                    boolean textRectDone = false;
                    int tfLevel = this.blockLevel;
                    while (true) {
                        if (this.readUntil("Para;", false, null, tfLevel, true) == null) continue block11;
                        tblIds.clear();
                        while (this.readUntil("ParaLine;", false, null, this.blockLevel, true) != null) {
                            while ((tag = this.readUntil("TextRectID;ATbl;", false, null, this.blockLevel, true)) != null) {
                                if (!textRectDone && tag.equals("TextRectID")) {
                                    token = this.getNextTokenInStatement(false, null, true);
                                    if (token.getType() != 1) continue;
                                    textRectId = token.getString();
                                    if (this.fnoteGroupLevel != -1) continue;
                                    textRectDone = true;
                                    continue;
                                }
                                if (!tag.equals("ATbl") || (token = this.getNextTokenInStatement(false, null, true)).getType() != 1) continue;
                                tblIds.add(token.getString());
                            }
                        }
                        if (!trToExtract.contains(textRectId)) continue;
                        this.textFlows.add(this.textFlowNumber);
                        this.tables.addAll(tblIds);
                    }
                }
                if (tag.equals(IMPORTOBJECT)) {
                    this.skipOverImportObject(false, null);
                    --this.blockLevel;
                    continue;
                }
                if (tag.equals("PgfCatalog")) {
                    int level = this.blockLevel;
                    block17: while (true) {
                        if (this.readUntil("Pgf;", false, null, level, true) == null) continue block11;
                        while (true) {
                            if ((tag = this.readUntil("PgfTag;PgfFont;", false, null, this.blockLevel, true)) == null) continue block17;
                            if (!tag.equals("PgfTag")) continue;
                        }
                        break;
                    }
                }
                if (!"MIFFile".equals(tag)) continue;
                token = this.getNextTokenInStatement(false, null, true);
                if (token.getType() != 1) break;
                this.version = token.getString();
            }
            throw new OkapiIOException("MIF version not found.");
        }
        catch (IOException e) {
            throw new OkapiIOException("Error while gathering extraction information.\n" + e.getMessage(), e);
        }
    }

    private void skipOverContent(boolean store, StringBuilder buffer) throws IOException {
        int c;
        int baseLevel = 1;
        int state = 0;
        block16: while ((c = this.reader.read()) != -1) {
            if (store) {
                if (buffer != null) {
                    buffer.append((char)c);
                } else {
                    this.skel.append((char)c);
                }
            }
            switch (state) {
                case 0: {
                    switch (c) {
                        case 96: {
                            state = 1;
                            continue block16;
                        }
                        case 92: {
                            state = 2;
                            continue block16;
                        }
                        case 60: {
                            ++baseLevel;
                            this.tagBuffer.setLength(0);
                            state = 3;
                            continue block16;
                        }
                        case 62: {
                            if (--baseLevel != 0) continue block16;
                            return;
                        }
                    }
                    continue block16;
                }
                case 1: {
                    if (c != 39) continue block16;
                    state = 0;
                    continue block16;
                }
                case 2: {
                    state = 0;
                    continue block16;
                }
                case 3: {
                    switch (c) {
                        case 62: {
                            if (--baseLevel == 0) {
                                return;
                            }
                        }
                        case 9: 
                        case 32: {
                            if (this.tagBuffer.toString().equals(IMPORTOBJECT)) {
                                this.skipOverImportObject(store, buffer);
                                --baseLevel;
                            }
                            state = 0;
                            continue block16;
                        }
                    }
                    this.tagBuffer.append((char)c);
                    continue block16;
                }
            }
        }
        throw new OkapiIllegalFilterOperationException(String.format("Unexpected end of input at state = %d", state));
    }

    private void readComment(boolean store, StringBuilder sb) throws IOException {
        int c;
        while ((c = this.reader.read()) != -1) {
            if (store) {
                if (sb != null) {
                    sb.append((char)c);
                } else {
                    this.skel.append((char)c);
                }
            }
            switch (c) {
                case 10: 
                case 13: {
                    return;
                }
            }
        }
    }

    private boolean startBlock(int stopLevel, int type) throws IOException {
        if (type == 2) {
            String tag = this.readUntil("TblID;", true, null, stopLevel, true);
            if (tag == null) {
                throw new OkapiIOException("Missing id for the table.");
            }
            MIFToken token = this.getNextTokenInStatement(true, null, true);
            if (token.getType() != 1) {
                throw new OkapiIOException("Missing id value for the table.");
            }
            if (this.tables != null && !this.tables.contains(token.getString())) {
                this.skipOverContent(true, null);
                --this.blockLevel;
                return false;
            }
            this.tableGroupLevel = this.blockLevel;
            StartGroup sg = new StartGroup(this.parentIds.peek());
            sg.setId(this.parentIds.push(String.valueOf(++this.grpId)));
            sg.setType("table");
            this.queue.add(new Event(EventType.START_GROUP, sg));
            this.resname = null;
        } else if (type == 1) {
            if (this.textFlows != null && !this.textFlows.contains(this.textFlowNumber)) {
                this.skipOverContent(true, null);
                --this.blockLevel;
                return false;
            }
            this.resname = null;
        }
        this.processBlock(stopLevel, false);
        return true;
    }

    private void processBlock(int stopLevel, boolean inPara) throws IOException {
        if (inPara) {
            this.inBlock = stopLevel;
            this.processPara();
            --this.blockLevel;
        } else if (this.readUntil("Para;", true, null, stopLevel, false) != null) {
            this.inBlock = stopLevel;
            this.processPara();
            --this.blockLevel;
        } else {
            this.inBlock = 0;
        }
        if (!this.skel.isEmpty()) {
            this.queue.add(new Event(EventType.DOCUMENT_PART, new DocumentPart(String.valueOf(++this.otherId), false), this.skel));
        }
    }

    private void processPara() throws IOException {
        TextFragment tf = new TextFragment();
        boolean first = true;
        this.paraLevel = 1;
        this.paraSkelBuf.setLength(0);
        this.paraTextBuf.setLength(0);
        this.paraCodeBuf.setLength(0);
        this.paraCodeTypes.setLength(0);
        String endString = null;
        this.resetToDefaultDecoder();
        Code code = null;
        boolean extractedMarker = false;
        int res = this.readUntilText(first, false);
        while (res > 0) {
            switch (res) {
                case 2: {
                    code = new Code(TextFragment.TagType.PLACEHOLDER, "index", "'>" + TextFragment.makeRefMarker(this.refTU.getId()) + "<String `");
                    code.setReferenceFlag(true);
                    extractedMarker = true;
                }
            }
            if (first) {
                if (this.paraSkelBuf.length() > 0) {
                    this.skel.append(this.paraSkelBuf.toString());
                    this.skel.append("<String `");
                    endString = "'>";
                }
                first = false;
            }
            if (this.paraCodeBuf.length() > 0) {
                Code code2 = new Code(TextFragment.TagType.PLACEHOLDER, this.paraCodeTypes.length() > 0 ? this.paraCodeTypes.toString() : "code", "'>" + this.paraCodeBuf.toString() + "<String `");
                tf.append(code2);
            }
            if (code != null) {
                tf.append(code);
                code = null;
            }
            if (this.paraTextBuf.length() > 0) {
                tf.append(this.paraTextBuf.toString());
            }
            this.paraSkelBuf.setLength(0);
            this.paraTextBuf.setLength(0);
            this.paraCodeBuf.setLength(0);
            this.paraCodeTypes.setLength(0);
            res = this.readUntilText(first, false);
        }
        this.checkInlineCodes(tf);
        TextUnit tu = null;
        if (!tf.isEmpty()) {
            if (tf.hasText() || extractedMarker) {
                tu = new TextUnit(String.valueOf(++this.tuId));
                tu.setPreserveWhitespaces(true);
                tu.setSourceContent(tf);
                tu.setName(this.resname);
                this.resname = null;
                this.queue.add(new Event(EventType.TEXT_UNIT, tu, this.skel));
                if (tf.getCodedText().charAt(0) == '\ue103' && tf.getCodes().size() == 1 && (code = tf.getCode(0)).getType().equals("font")) {
                    Code tmp = tf.getCode(0);
                    tf.remove(0, 2);
                    this.skel.append(tmp.toString());
                }
                this.skel.addContentPlaceholder(tu);
            } else {
                String ctext = tf.getCodedText();
                StringBuilder tmp = new StringBuilder();
                for (int i = 0; i < ctext.length(); ++i) {
                    char ch = ctext.charAt(i);
                    if (TextFragment.isMarker(ch)) {
                        tmp.append(tf.getCode(ctext.charAt(++i)));
                        continue;
                    }
                    tmp.append(this.encoder.encode(ch, 1));
                }
                GenericSkeletonPart part = this.skel.getLastPart();
                if (part == null || !part.getData().toString().endsWith("<String `")) {
                    this.skel.append("<String `");
                    endString = "'>";
                }
                this.skel.append(tmp.toString());
            }
        }
        if (endString != null) {
            this.skel.append(endString);
        }
        if (this.paraSkelBuf.length() > 0) {
            this.skel.append(this.paraSkelBuf.toString());
        }
        if (this.paraCodeBuf.length() > 0) {
            this.skel.append(this.paraCodeBuf.toString());
        }
        if (tu != null) {
            this.skel = new GenericSkeleton();
        }
    }

    private MIFToken getNextTokenInStatement(boolean store, StringBuilder sb, boolean updateBlockLevel) throws IOException {
        int n;
        boolean leadingWSDone = false;
        do {
            n = this.reader.read();
            if (store) {
                if (sb != null) {
                    sb.append((char)n);
                } else {
                    this.skel.add((char)n);
                }
            }
            switch (n) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                case -1: {
                    throw new OkapiIllegalFilterOperationException("Unexpected end of input.");
                }
                default: {
                    leadingWSDone = true;
                }
            }
        } while (!leadingWSDone);
        StringBuilder tmp = new StringBuilder();
        tmp.append((char)n);
        while (true) {
            n = this.reader.read();
            if (store) {
                if (sb != null) {
                    sb.append((char)n);
                } else {
                    this.skel.add((char)n);
                }
            }
            switch (n) {
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 62: {
                    MIFToken token = new MIFToken(tmp.toString());
                    token.setLast(n == 62);
                    if (updateBlockLevel && token.isLast()) {
                        --this.blockLevel;
                    }
                    return token;
                }
                case -1: {
                    throw new OkapiIllegalFilterOperationException("Unexpected end of input.");
                }
            }
            tmp.append((char)n);
        }
    }

    private MIFToken processChar(boolean store) throws IOException {
        MIFToken token = this.getNextTokenInStatement(store, null, false);
        if (!token.isLast()) {
            this.skipOverContent(store, null);
        }
        MIFToken chToken = new MIFToken();
        if (token.getType() == 1) {
            String str = charTable.get(token.getString());
            if (str == null) {
                this.logger.warning(String.format("Unknow character name '%s'. This character will be ignored.", token));
            } else {
                chToken.setString(str);
            }
        } else {
            this.logger.warning("Unexpected token is Char statement. This character will be ignored.");
        }
        return chToken;
    }

    private Object[] processMarker() throws IOException {
        this.refTU = null;
        int level = this.blockLevel;
        StringBuilder sb = new StringBuilder("<Marker ");
        Object[] res = new Object[]{sb, null};
        String tag = this.readUntil("MTypeName;", true, sb, -1, true);
        if (tag == null) {
            this.logger.warning("Marker without type or text found. It will be skipped.");
            this.skipOverContent(true, sb);
            return res;
        }
        String type = this.processString(true, sb);
        String resType = null;
        if ("Index".equals(type)) {
            if (this.params.getExtractIndexMarkers()) {
                resType = "x-index";
            }
        } else if ("Hypertext".equals(type) && this.params.getExtractLinks()) {
            resType = "link";
        }
        if (resType == null) {
            this.skipOverContent(true, sb);
            this.blockLevel = level;
            return res;
        }
        tag = this.readUntil("MText;", true, sb, -1, true);
        if (tag == null) {
            this.skipOverContent(true, sb);
            this.blockLevel = level;
            return res;
        }
        TextFragment tf = new TextFragment(this.processString(true, sb));
        this.checkInlineCodes(tf);
        if (tf.hasText()) {
            this.refTU = new TextUnit(String.valueOf(++this.tuId));
            this.refTU.setPreserveWhitespaces(true);
            this.refTU.setSourceContent(tf);
            this.refTU.setType(resType);
            this.refTU.setIsReferent(true);
            int n = sb.lastIndexOf("`");
            sb.delete(n + 1, sb.length());
            GenericSkeleton refSkel = new GenericSkeleton(sb.toString());
            refSkel.addContentPlaceholder(this.refTU);
            sb.setLength(0);
            sb.append("'>");
            this.skipOverContent(true, sb);
            refSkel.add(sb.toString());
            this.queue.add(new Event(EventType.TEXT_UNIT, this.refTU, refSkel));
            sb = null;
            res[1] = this.refTU;
        } else {
            this.skipOverContent(true, sb);
        }
        this.blockLevel = level;
        return res;
    }

    private int readUntilText(boolean startOfPara, boolean significant) throws IOException {
        int c;
        StringBuilder sb = startOfPara ? this.paraSkelBuf : this.paraCodeBuf;
        block5: while ((c = this.reader.read()) != -1) {
            switch (c) {
                case 35: {
                    sb.append((char)c);
                    this.readComment(true, sb);
                    continue block5;
                }
                case 60: {
                    ++this.paraLevel;
                    sb.append((char)c);
                    String tag = this.readTag(true, false, sb);
                    if ("ParaLine".equals(tag)) {
                        if (!startOfPara) {
                            int n = sb.lastIndexOf("<");
                            if (significant) {
                                sb.delete(n, sb.length());
                            } else {
                                sb.setLength(0);
                            }
                        }
                        return this.readUntilText(startOfPara, significant);
                    }
                    if ("String".equals(tag)) {
                        String text = this.processString(false, null);
                        int n = sb.lastIndexOf("<");
                        if (significant) {
                            sb.delete(n, sb.length());
                        } else {
                            sb.setLength(0);
                        }
                        --this.paraLevel;
                        if (!Util.isEmpty(text)) {
                            this.paraTextBuf.append(text);
                            return 1;
                        }
                    } else if ("Char".equals(tag)) {
                        String text = this.processChar(false).toString();
                        if (!significant) {
                            sb.setLength(0);
                        }
                        --this.paraLevel;
                        if (!Util.isEmpty(text)) {
                            this.paraTextBuf.append(text);
                            return 1;
                        }
                    } else if ("Marker".equals(tag)) {
                        int n = sb.lastIndexOf("<Marker");
                        if (significant) {
                            sb.delete(n, sb.length());
                        } else {
                            sb.setLength(0);
                        }
                        Object[] res = this.processMarker();
                        significant = true;
                        if (this.paraCodeTypes.length() > 0) {
                            this.paraCodeTypes.append(";");
                        }
                        this.paraCodeTypes.append(tag.toLowerCase());
                        --this.paraLevel;
                        if (res[1] != null) {
                            return 2;
                        }
                        sb.append(res[0]);
                    } else if (!this.useUTF && "PgfTag".equals(tag)) {
                        this.processString(true, sb);
                        significant = true;
                        if (this.paraCodeTypes.length() > 0) {
                            this.paraCodeTypes.append(";");
                        }
                        this.paraCodeTypes.append(tag.toLowerCase());
                        --this.paraLevel;
                    } else if ("Font".equals(tag)) {
                        this.monitorFontEncoding(sb);
                        significant = true;
                        if (this.paraCodeTypes.length() > 0) {
                            this.paraCodeTypes.append(";");
                        }
                        this.paraCodeTypes.append(tag.toLowerCase());
                        --this.paraLevel;
                    } else {
                        this.skipOverContent(true, sb);
                        significant = true;
                        if (this.paraCodeTypes.length() > 0) {
                            this.paraCodeTypes.append(";");
                        }
                        this.paraCodeTypes.append(tag.toLowerCase());
                        --this.paraLevel;
                    }
                    if (!startOfPara || "Font;Marker;Conditional;Unconditional;ATbl;AFrame;FNote;Variable;XRef;XRefEnd;".indexOf(tag) == -1) continue block5;
                    int n = sb.lastIndexOf("<" + tag + " ");
                    this.paraCodeBuf.append(sb.substring(n));
                    sb.delete(n, sb.length());
                    sb = this.paraCodeBuf;
                    this.paraCodeTypes.setLength(0);
                    this.paraCodeTypes.append(tag.toLowerCase());
                    startOfPara = false;
                    continue block5;
                }
                case 62: {
                    --this.paraLevel;
                    if (this.paraLevel != 1) {
                        sb.append((char)c);
                        significant = true;
                    }
                    if (this.paraLevel != 0) continue block5;
                    int n = sb.lastIndexOf(" # end of ParaLine");
                    if (n > -1) {
                        sb.insert(n, '>');
                    } else {
                        sb.append(" # end of ParaLine" + this.lineBreak + ">");
                    }
                    return 0;
                }
            }
            sb.append((char)c);
        }
        return 0;
    }

    private void monitorFontEncoding(StringBuilder sb) throws IOException {
        int c;
        int baseLevel = 1;
        String encoding = null;
        String fontHint = null;
        String ftag = null;
        boolean inString = false;
        MIFToken token = null;
        while ((c = this.reader.read()) != -1) {
            sb.append((char)c);
            if (inString) {
                if (c != 39) continue;
                inString = false;
                continue;
            }
            switch (c) {
                case 35: {
                    this.readComment(true, sb);
                    break;
                }
                case 96: {
                    inString = true;
                    break;
                }
                case 60: {
                    ++baseLevel;
                    String tag = this.readTag(true, true, sb);
                    if ("FTag".equals(tag)) {
                        token = this.getNextTokenInStatement(true, sb, false);
                        if (token.isLast()) {
                            --baseLevel;
                        }
                        ftag = token.toString().substring(1, token.toString().length() - 1);
                        break;
                    }
                    if ("FEncoding".equals(tag)) {
                        token = this.getNextTokenInStatement(true, sb, false);
                        if (token.isLast()) {
                            --baseLevel;
                        }
                        encoding = token.toString().substring(1, token.toString().length() - 1);
                        break;
                    }
                    if (!"FPlatformName".equals(tag)) break;
                    token = this.getNextTokenInStatement(true, sb, false);
                    if (token.isLast()) {
                        --baseLevel;
                    }
                    fontHint = token.toString().substring(1, token.toString().length() - 1);
                    break;
                }
                case 62: {
                    if (--baseLevel != 0) break;
                    if (!this.useUTF) {
                        Object[] res = this.mapFontEncoding(ftag, encoding, fontHint);
                        this.updateCurrentDecoder((String)res[0], (Boolean)res[1]);
                    }
                    return;
                }
            }
        }
        throw new OkapiIllegalFilterOperationException("Unexpected end of input when reading a font");
    }

    private void resetToDefaultDecoder() {
        this.currentCharsetIndex = 0;
        this.currentDecoder = this.decoders[0];
        this.doDoubleConversion = this.doubleConversion[0];
    }

    private Object[] mapFontEncoding(String ftag, String encoding, String hint) {
        Object[] res = new Object[2];
        res[1] = false;
        if (encoding == null) {
            if (Util.isEmpty(ftag)) {
                res[0] = "";
                return res;
            }
            return res;
        }
        String mappedEncoding = encodingTable.get(encoding);
        if (mappedEncoding == null) {
            this.logger.warning(String.format("Unknown encoding name: '%s'.", encoding));
            return res;
        }
        res[0] = mappedEncoding;
        if (mappedEncoding.equals(FRAMEROMAN) && !Util.isEmpty(hint)) {
            if ((hint = hint.toLowerCase()).contains("greek")) {
                res[0] = "x-MacGreek";
                res[1] = true;
            } else if (hint.contains("cyrillic")) {
                res[0] = "x-MacCyrillic";
                res[1] = true;
            } else if (hint.contains(" ce ")) {
                res[0] = "x-MacCentralEurope";
                res[1] = true;
            }
        }
        return res;
    }

    private void updateCurrentDecoder(String newEncoding, boolean newDoubleConversion) {
        if (newEncoding == null) {
            return;
        }
        if (newEncoding.isEmpty()) {
            this.resetToDefaultDecoder();
            return;
        }
        if (!newEncoding.equals(this.currentDecoder.charset().name())) {
            int n;
            int n2 = n = this.currentCharsetIndex == 0 ? 1 : 0;
            if (newEncoding.equals(this.decoders[n].charset().name())) {
                this.currentCharsetIndex = n;
            } else {
                if (newEncoding.equals(FRAMEROMAN)) {
                    this.decoders[1] = this.csProvider.charsetForName(newEncoding).newDecoder();
                    this.encoders[1] = this.csProvider.charsetForName(newEncoding).newEncoder();
                } else {
                    this.decoders[1] = Charset.forName(newEncoding).newDecoder();
                    this.encoders[1] = Charset.forName(newEncoding).newEncoder();
                }
                this.doubleConversion[1] = newDoubleConversion;
                this.currentCharsetIndex = 1;
            }
            this.currentDecoder = this.decoders[this.currentCharsetIndex];
            this.doDoubleConversion = this.doubleConversion[this.currentCharsetIndex];
        }
    }

    private String readUntil(String tagNames, boolean store, StringBuilder sb, int stopLevel, boolean skipNotesBlock) throws IOException {
        int c;
        int endNow = stopLevel;
        if (stopLevel == -1) {
            endNow = this.blockLevel;
        }
        while ((c = this.reader.read()) != -1) {
            if (store) {
                if (sb == null) {
                    this.skel.append((char)c);
                } else {
                    sb.append((char)c);
                }
            }
            block0 : switch (c) {
                case 35: {
                    this.readComment(store, sb);
                    break;
                }
                case 60: {
                    do {
                        StartGroup sg;
                        ++this.blockLevel;
                        String tag = this.readTag(store, true, sb);
                        if (tagNames.indexOf(tag + ";") > -1) {
                            if (skipNotesBlock && this.footnotesLevel != -1) break block0;
                            return tag;
                        }
                        if ("Tbl".equals(tag)) {
                            this.tableGroupLevel = this.blockLevel;
                            break block0;
                        }
                        if ("Row".equals(tag)) {
                            this.rowGroupLevel = this.blockLevel;
                            if (!this.secondPass) break block0;
                            sg = new StartGroup(this.parentIds.peek());
                            sg.setId(this.parentIds.push(String.valueOf(++this.grpId)));
                            sg.setType("row");
                            this.queue.add(new Event(EventType.START_GROUP, sg));
                            break block0;
                        }
                        if ("Cell".equals(tag)) {
                            this.cellGroupLevel = this.blockLevel;
                            if (!this.secondPass) break block0;
                            sg = new StartGroup(this.parentIds.peek(), String.valueOf(++this.grpId));
                            sg.setType("cell");
                            this.queue.add(new Event(EventType.START_GROUP, sg));
                            break block0;
                        }
                        if ("Notes".equals(tag)) {
                            this.footnotesLevel = this.blockLevel;
                            break block0;
                        }
                        if ("FNote".equals(tag)) {
                            if (this.footnotesLevel <= 0) break block0;
                            this.fnoteGroupLevel = this.blockLevel;
                            if (!this.secondPass) break block0;
                            sg = new StartGroup(this.parentIds.peek(), String.valueOf(++this.grpId));
                            sg.setType("fn");
                            this.queue.add(new Event(EventType.START_GROUP, sg));
                            break block0;
                        }
                        if (!IMPORTOBJECT.equals(tag)) continue;
                        this.skipOverImportObject(store, sb);
                        --this.blockLevel;
                        break block0;
                    } while (this.readUntilOpenOrClose(store, sb));
                    --this.blockLevel;
                    break;
                }
                case 62: {
                    if (this.tableGroupLevel == this.blockLevel) {
                        this.tableGroupLevel = -1;
                        if (this.secondPass) {
                            this.queue.add(new Event(EventType.END_GROUP, new Ending(String.valueOf(++this.grpId))));
                            this.parentIds.pop();
                        }
                    } else if (this.rowGroupLevel == this.blockLevel) {
                        this.rowGroupLevel = -1;
                        if (this.secondPass) {
                            this.queue.add(new Event(EventType.END_GROUP, new Ending(String.valueOf(++this.grpId))));
                            this.parentIds.pop();
                        }
                    } else if (this.cellGroupLevel == this.blockLevel) {
                        this.cellGroupLevel = -1;
                        if (this.secondPass) {
                            this.queue.add(new Event(EventType.END_GROUP, new Ending(String.valueOf(++this.grpId))));
                        }
                    } else if (this.footnotesLevel == this.blockLevel) {
                        this.footnotesLevel = -1;
                    } else if (this.fnoteGroupLevel == this.blockLevel && this.footnotesLevel > 0) {
                        this.fnoteGroupLevel = -1;
                        if (this.secondPass) {
                            this.queue.add(new Event(EventType.END_GROUP, new Ending(String.valueOf(++this.grpId))));
                        }
                    }
                    --this.blockLevel;
                    if (this.blockLevel >= endNow) break;
                    return null;
                }
            }
        }
        return null;
    }

    private void skipOverImportObject(boolean store, StringBuilder buffer) throws IOException {
        int c;
        int state = 0;
        int baseLevel = 1;
        block19: while ((c = this.reader.read()) != -1) {
            if (store) {
                if (buffer != null) {
                    buffer.append((char)c);
                } else {
                    this.skel.append((char)c);
                }
            }
            switch (state) {
                case 0: {
                    switch (c) {
                        case 96: {
                            state = 1;
                            continue block19;
                        }
                        case 60: {
                            ++baseLevel;
                            continue block19;
                        }
                        case 62: {
                            if (--baseLevel == 0) {
                                return;
                            }
                        }
                        case 10: 
                        case 13: {
                            state = 3;
                            continue block19;
                        }
                    }
                    continue block19;
                }
                case 1: {
                    if (c != 39) continue block19;
                    state = 0;
                    continue block19;
                }
                case 2: {
                    state = 0;
                    continue block19;
                }
                case 3: {
                    switch (c) {
                        case 38: {
                            state = 4;
                            continue block19;
                        }
                        case 60: {
                            state = 0;
                            ++baseLevel;
                            continue block19;
                        }
                        case 62: {
                            state = 0;
                            if (--baseLevel != 0) continue block19;
                            return;
                        }
                        case 10: 
                        case 13: {
                            continue block19;
                        }
                    }
                    state = 0;
                    continue block19;
                }
                case 4: {
                    if (c != 13 && c != 10) continue block19;
                    state = 3;
                    continue block19;
                }
            }
        }
        throw new OkapiIllegalFilterOperationException(String.format("Unexpected end of input at state = %d", state));
    }

    private boolean readUntilOpenOrClose(boolean store, StringBuilder sb) throws IOException {
        int c;
        boolean inEscape = false;
        boolean inString = false;
        while ((c = this.reader.read()) != -1) {
            if (store) {
                if (sb == null) {
                    this.skel.append((char)c);
                } else {
                    sb.append((char)c);
                }
            }
            if (inString) {
                if (c != 39) continue;
                inString = false;
                continue;
            }
            if (inEscape) {
                inEscape = false;
                continue;
            }
            switch (c) {
                case 96: {
                    inString = true;
                    break;
                }
                case 92: {
                    inEscape = true;
                    break;
                }
                case 60: {
                    return true;
                }
                case 62: {
                    return false;
                }
            }
        }
        throw new OkapiIllegalFilterOperationException("Unexpected end of input.");
    }

    private String readTag(boolean store, boolean storeCharStatement, StringBuilder sb) throws IOException {
        int c;
        this.tagBuffer.setLength(0);
        int wsStart = sb != null ? sb.length() - 1 : -1;
        boolean leadingWSDone = false;
        block7: do {
            c = this.reader.read();
            switch (c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (!store) continue block7;
                    if (sb != null) {
                        sb.append((char)c);
                        break;
                    }
                    this.skel.add((char)c);
                    break;
                }
                default: {
                    leadingWSDone = true;
                }
            }
        } while (!leadingWSDone);
        while (true) {
            switch (c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (store) {
                        if (!storeCharStatement && this.tagBuffer.toString().equals("Char")) {
                            if (wsStart > 0) {
                                sb.delete(wsStart, sb.length());
                            }
                        } else if (sb != null) {
                            sb.append(this.tagBuffer.toString());
                            sb.append((char)c);
                        } else {
                            this.skel.append(this.tagBuffer.toString());
                            this.skel.append((char)c);
                        }
                    }
                    return this.tagBuffer.toString();
                }
                case -1: {
                    throw new OkapiIllegalFilterOperationException("Unexpected end of input.");
                }
            }
            this.tagBuffer.append((char)c);
            c = this.reader.read();
        }
    }

    private void processVariables() throws IOException {
        boolean startGroupDone = false;
        String tag = null;
        TextUnit tu = null;
        do {
            if ((tag = this.readUntil("VariableFormat;", true, null, this.blockLevel - 1, true)) == null || (tag = this.readUntil("VariableDef;", true, null, this.blockLevel - 1, true)) == null) continue;
            String text = this.processString(false, null);
            TextFragment tf = new TextFragment(text);
            this.checkInlineCodes(tf);
            this.skel.append("`");
            if (tf.hasText()) {
                if (!startGroupDone) {
                    StartGroup sg = new StartGroup(this.parentIds.peek());
                    sg.setId(String.valueOf(++this.grpId));
                    sg.setType("variables");
                    this.queue.add(new Event(EventType.START_GROUP, sg));
                    startGroupDone = true;
                }
                tu = new TextUnit(String.valueOf(++this.tuId));
                tu.setPreserveWhitespaces(true);
                tu.setSourceContent(tf);
                tu.setName(this.resname);
                this.resname = null;
                this.queue.add(new Event(EventType.TEXT_UNIT, tu, this.skel));
                this.skel.addContentPlaceholder(tu);
            } else {
                this.skel.append(this.toMIFString(tf));
            }
            this.skel.append("'>");
            if (tu == null) continue;
            this.skel = new GenericSkeleton();
            tu = null;
        } while (tag != null);
        if (startGroupDone) {
            this.queue.add(new Event(EventType.END_GROUP, new Ending(String.valueOf(++this.grpId))));
        }
    }

    private String toMIFString(TextFragment tf) {
        String ctext = tf.getCodedText();
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < ctext.length(); ++i) {
            char ch = ctext.charAt(i);
            if (TextFragment.isMarker(ch)) {
                tmp.append(tf.getCode(ctext.charAt(++i)));
                continue;
            }
            tmp.append(this.encoder.encode(ch, 1));
        }
        return tmp.toString();
    }

    private void checkInlineCodes(TextFragment tf) {
        if (this.params.getUseCodeFinder()) {
            this.params.getCodeFinder().process(tf);
        }
        List<Code> codes = tf.getCodes();
        for (Code code : codes) {
            if (!code.getType().equals("regxph")) continue;
            code.setData(this.encoder.encode(code.getData(), 1));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String processString(boolean store, StringBuilder sb) throws IOException {
        int c;
        this.strBuffer.setLength(0);
        int state = 0;
        boolean byteMode = false;
        while ((c = this.reader.read()) != -1) {
            if (store) {
                if (sb == null) {
                    this.skel.append((char)c);
                } else {
                    sb.append((char)c);
                }
            }
            block1 : switch (state) {
                case 0: {
                    switch (c) {
                        case 96: {
                            state = 1;
                            break block1;
                        }
                        case 62: {
                            if (!byteMode) return this.strBuffer.toString();
                            try {
                                if (!this.doDoubleConversion) {
                                    CharBuffer buf = this.currentDecoder.decode(ByteBuffer.wrap(this.byteStream.toByteArray()));
                                    this.strBuffer.append(buf.toString());
                                    return this.strBuffer.toString();
                                }
                                CharBuffer buf1 = this.firstDecoder.decode(ByteBuffer.wrap(this.byteStream.toByteArray()));
                                this.byteStream.reset();
                                char[] arr$ = buf1.array();
                                int len$ = arr$.length;
                                int i$ = 0;
                                while (true) {
                                    if (i$ >= len$) {
                                        CharBuffer buf2 = this.currentDecoder.decode(ByteBuffer.wrap(this.byteStream.toByteArray()));
                                        this.strBuffer.append(buf2.toString());
                                        return this.strBuffer.toString();
                                    }
                                    char ch = arr$[i$];
                                    this.byteStream.write(ch);
                                    ++i$;
                                }
                            }
                            catch (CharacterCodingException e) {
                                if (++this.decodingErrors >= 25) return this.strBuffer.toString();
                                this.logger.warning(String.format("Error with decoding character with encoding '%s'.", this.currentDecoder.charset().name()));
                            }
                            return this.strBuffer.toString();
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c) {
                        case 39: {
                            state = 0;
                            break block1;
                        }
                        case 92: {
                            state = 2;
                            break block1;
                        }
                    }
                    if (byteMode) {
                        if (c > 127) {
                            this.logger.warning(String.format("A raw extended character (0x%04X) was found in a byte string.\nThis may be a problem.", c));
                        }
                        this.byteStream.write(c);
                        break;
                    }
                    this.strBuffer.append((char)c);
                    break;
                }
                case 2: {
                    state = 1;
                    switch (c) {
                        case 62: 
                        case 92: {
                            if (byteMode) {
                                this.byteStream.write(c);
                                break;
                            }
                            this.strBuffer.append((char)c);
                            break;
                        }
                        case 116: {
                            if (byteMode) {
                                this.byteStream.write(c);
                                break;
                            }
                            this.strBuffer.append('\t');
                            break;
                        }
                        case 81: {
                            if (byteMode) {
                                this.byteStream.write(c);
                                break;
                            }
                            this.strBuffer.append('`');
                            break;
                        }
                        case 113: {
                            if (byteMode) {
                                this.byteStream.write(c);
                                break;
                            }
                            this.strBuffer.append('\'');
                            break;
                        }
                        case 117: {
                            c = this.readHexa(4, false, store, sb);
                            if (c == Integer.MAX_VALUE) break;
                            if (byteMode) {
                                this.logger.warning("A Uniocde escape sequence was found in a byte string.\nMixed notations are not supported, this character will be skipped.");
                                break;
                            }
                            this.strBuffer.append((char)c);
                            break;
                        }
                        case 120: {
                            c = this.readHexa(2, true, store, sb);
                            if (c == Integer.MAX_VALUE) break;
                            if (!byteMode) {
                                this.byteStream.reset();
                                byteMode = true;
                            }
                            this.byteStream.write((char)c);
                        }
                    }
                    break;
                }
            }
        }
        throw new OkapiIllegalFilterOperationException("End of string is missing.");
    }

    private int readHexa(int length, boolean readExtraSpace, boolean store, StringBuilder sb) throws IOException {
        int c;
        this.tagBuffer.setLength(0);
        for (int i = 0; i < length; ++i) {
            c = this.reader.read();
            if (c == -1) {
                throw new OkapiIllegalFilterOperationException("Unexpected end of file.");
            }
            if (store) {
                if (sb == null) {
                    this.skel.append((char)c);
                } else {
                    sb.append((char)c);
                }
            }
            this.tagBuffer.append((char)c);
        }
        if (readExtraSpace) {
            c = this.reader.read();
            if (store) {
                if (sb == null) {
                    this.skel.append((char)c);
                } else {
                    sb.append((char)c);
                }
            }
        }
        try {
            int n = Integer.valueOf(this.tagBuffer.toString(), 16);
            return n;
        }
        catch (NumberFormatException e) {
            this.logger.warning(String.format("Invalid escape sequence found: '%s'", this.tagBuffer.toString()));
            return Integer.MAX_VALUE;
        }
    }

    private InputStream guessEncoding(InputStream input) throws IOException {
        int n;
        PushbackInputStream stream = new PushbackInputStream(input, 28);
        byte[] buffer = new byte[28];
        int unread = n = stream.read(buffer, 0, 28);
        boolean is16 = false;
        this.baseEncoding = "UTF-8";
        if (buffer[0] == -2 && buffer[1] == -1) {
            is16 = true;
            this.baseEncoding = "UTF-16BE";
        } else if (buffer[0] == -1 && buffer[1] == -2) {
            is16 = true;
            this.baseEncoding = "UTF-16LE";
        }
        String tmp = new String(buffer, this.baseEncoding);
        if (is16) {
            tmp = tmp.substring(1);
            unread = n - 2;
        }
        if (tmp.length() < 13) {
            throw new OkapiIOException("Invalid MIF header.");
        }
        if (!tmp.startsWith("<MIFFile ")) {
            throw new OkapiIOException("Invalid MIF header.");
        }
        this.version = tmp.substring(9);
        if (this.version.compareTo("8.00") < 0) {
            this.baseEncoding = FRAMEROMAN;
        }
        this.useUTF = this.baseEncoding.startsWith("UTF-");
        stream.unread(buffer, n - unread, unread);
        return stream;
    }
}

