/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xini;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.xini.Parameters;
import net.sf.okapi.filters.xini.XINIReader;
import net.sf.okapi.filters.xini.XINIWriter;

@UsingParameters(value=Parameters.class)
public class XINIFilter
implements IFilter {
    private Parameters params = new Parameters();
    private EncoderManager encoderManager;
    private XINIReader reader;
    private LinkedList<Event> queue = new LinkedList();
    private String relDocName;

    public XINIFilter() {
    }

    public XINIFilter(String relDocName) {
        this();
        this.relDocName = relDocName;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    @Override
    public String getName() {
        return "okf_xini";
    }

    @Override
    public String getDisplayName() {
        return "XINI Filter";
    }

    @Override
    public String getMimeType() {
        return "text/x-xini";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "text/x-xini", this.getClass().getName(), "XINI", "Configuration for XINI documents from ONTRAM.", null, ".xini;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("text/x-xini", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public Event next() {
        return this.queue.poll();
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.close();
        this.reader = new XINIReader();
        this.reader.open(input);
        if (this.relDocName == null) {
            this.queue.addAll(this.reader.getFilterEvents());
        } else {
            this.queue.addAll(this.reader.getFilterEvents(this.relDocName));
        }
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new XINIWriter();
    }
}

