/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.beans.v1;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.lib.beans.v1.AnnotationsBean;
import net.sf.okapi.lib.beans.v1.PropertyBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.PersistenceBean;
import net.sf.okapi.lib.persistence.beans.FactoryBean;

public class TextContainerBean
extends PersistenceBean<TextContainer> {
    private List<PropertyBean> properties = new ArrayList<PropertyBean>();
    private AnnotationsBean annotations = new AnnotationsBean();
    private List<FactoryBean> parts = new ArrayList<FactoryBean>();
    private boolean segApplied;

    @Override
    protected TextContainer createObject(IPersistenceSession session) {
        return new TextContainer();
    }

    @Override
    protected void fromObject(TextContainer obj, IPersistenceSession session) {
        for (String propName : obj.getPropertyNames()) {
            PropertyBean propBean = new PropertyBean();
            propBean.set(obj.getProperty(propName), session);
            this.properties.add(propBean);
        }
        this.annotations.set(obj.getAnnotations(), session);
        for (int i = 0; i < obj.count(); ++i) {
            TextPart part = obj.get(i);
            FactoryBean partBean = new FactoryBean();
            this.parts.add(partBean);
            partBean.set(part, session);
        }
        this.segApplied = obj.hasBeenSegmented();
    }

    @Override
    protected void setObject(TextContainer obj, IPersistenceSession session) {
        for (PropertyBean prop : this.properties) {
            obj.setProperty(prop.get(Property.class, session));
        }
        for (FactoryBean annotationBean : this.annotations.getItems()) {
            obj.setAnnotation(annotationBean.get(IAnnotation.class, session));
        }
        for (FactoryBean partBean : this.parts) {
            TextPart part = partBean.get(TextPart.class, session);
            if (part == null) continue;
            obj.append(part, true);
        }
        obj.setHasBeenSegmentedFlag(this.segApplied);
    }

    public AnnotationsBean getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(AnnotationsBean annotations) {
        this.annotations = annotations;
    }

    public List<PropertyBean> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyBean> properties) {
        this.properties = properties;
    }

    public List<FactoryBean> getParts() {
        return this.parts;
    }

    public void setParts(List<FactoryBean> parts) {
        this.parts = parts;
    }

    public boolean isSegApplied() {
        return this.segApplied;
    }

    public void setSegApplied(boolean segApplied) {
        this.segApplied = segApplied;
    }
}

