/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.translation;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.query.IQuery;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;

public abstract class BaseConnector
implements IQuery {
    private static final Logger LOGGER = Logger.getLogger(BaseConnector.class.getName());
    protected LocaleId srcLoc;
    protected String srcCode;
    protected LocaleId trgLoc;
    protected String trgCode;
    protected QueryResult result;
    protected int current = -1;
    private int weight;

    @Override
    public LocaleId getSourceLanguage() {
        return this.srcLoc;
    }

    @Override
    public LocaleId getTargetLanguage() {
        return this.trgLoc;
    }

    @Override
    public void setLanguages(LocaleId sourceLocale, LocaleId targetLocale) {
        this.srcLoc = sourceLocale;
        this.trgLoc = targetLocale;
        this.srcCode = this.toInternalCode(this.srcLoc);
        this.trgCode = this.toInternalCode(this.trgLoc);
    }

    @Override
    public boolean hasNext() {
        return this.current > -1;
    }

    @Override
    public QueryResult next() {
        if (this.current > -1) {
            this.current = -1;
            return this.result;
        }
        return null;
    }

    @Override
    public void clearAttributes() {
    }

    @Override
    public void removeAttribute(String name) {
    }

    @Override
    public void setAttribute(String name, String value) {
    }

    @Override
    public void setRootDirectory(String rootDir) {
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Override
    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        LinkedList<List<QueryResult>> queriesResults = new LinkedList<List<QueryResult>>();
        for (TextFragment fragment : fragments) {
            this.query(fragment);
            LinkedList<QueryResult> results = new LinkedList<QueryResult>();
            while (this.hasNext()) {
                QueryResult qr = this.next();
                results.add(qr);
            }
            queriesResults.add(results);
        }
        return queriesResults;
    }

    @Override
    public void leverage(ITextUnit tu) {
        if (tu == null || !tu.isTranslatable()) {
            return;
        }
        AltTranslationsAnnotation at = null;
        TextContainer trgCont = tu.createTarget(this.getTargetLanguage(), false, 4);
        ISegments trgSegs = trgCont.getSegments();
        for (Segment srcSeg : tu.getSource().getSegments()) {
            if (!srcSeg.text.hasText(false)) continue;
            this.query(srcSeg.text);
            while (this.hasNext()) {
                QueryResult qr = this.next();
                TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(srcSeg.text, qr.target, true, false, null, tu);
                if (trgCont.hasBeenSegmented()) {
                    Segment ts = trgSegs.get(srcSeg.getId());
                    if (ts == null) {
                        ts = new Segment(srcSeg.id, new TextFragment(""));
                        trgSegs.append(ts);
                        LOGGER.warning(String.format("Cannot find matching target segment for source id: %s.Creating a new target segment at the end of the target.", srcSeg.getId()));
                    }
                    at = TextUnitUtil.addAltTranslation(ts, qr.toAltTranslation(srcSeg.text, this.getSourceLanguage(), this.getTargetLanguage()));
                    continue;
                }
                at = TextUnitUtil.addAltTranslation(trgCont, qr.toAltTranslation(srcSeg.text, this.getSourceLanguage(), this.getTargetLanguage()));
            }
            if (at == null) continue;
            at.sort();
        }
    }

    @Override
    public void batchLeverage(List<ITextUnit> tus) {
        for (ITextUnit tu : tus) {
            this.leverage(tu);
        }
    }

    protected void leverageUsingBatchQuery(ITextUnit tu) {
        if (tu == null || !tu.isTranslatable()) {
            return;
        }
        ArrayList<ITextUnit> tuList = new ArrayList<ITextUnit>();
        tuList.add(tu);
        this.batchLeverageUsingBatchQuery(tuList);
    }

    protected void batchLeverageUsingBatchQuery(List<ITextUnit> tuList) {
        ArrayList<TextFragment> frags = new ArrayList<TextFragment>();
        for (ITextUnit tu : tuList) {
            if (!tu.isTranslatable()) continue;
            for (Segment srcSeg : tu.getSource().getSegments()) {
                frags.add(srcSeg.text);
            }
        }
        List<List<QueryResult>> allResults = this.batchQuery(frags);
        int transIndex = -1;
        for (ITextUnit tu : tuList) {
            if (!tu.isTranslatable()) continue;
            TextContainer trgCont = tu.createTarget(this.getTargetLanguage(), false, 4);
            ISegments trgSegs = trgCont.getSegments();
            for (Segment srcSeg : tu.getSource().getSegments()) {
                List<QueryResult> resList = allResults.get(++transIndex);
                AltTranslationsAnnotation at = null;
                for (QueryResult qr : resList) {
                    TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(srcSeg.text, qr.target, true, false, null, tu);
                    if (trgCont.hasBeenSegmented()) {
                        Segment ts = trgSegs.get(srcSeg.getId());
                        if (ts == null) {
                            ts = new Segment(srcSeg.id, new TextFragment(""));
                            trgSegs.append(ts);
                        }
                        at = TextUnitUtil.addAltTranslation(ts, qr.toAltTranslation(srcSeg.text, this.getSourceLanguage(), this.getTargetLanguage()));
                        continue;
                    }
                    at = TextUnitUtil.addAltTranslation(trgCont, qr.toAltTranslation(srcSeg.text, this.getSourceLanguage(), this.getTargetLanguage()));
                }
                if (at == null) continue;
                at.sort();
            }
        }
    }

    protected String toInternalCode(LocaleId locId) {
        return locId.toString();
    }
}

