/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import net.sf.okapi.lib.xliff.Util;
import org.oasisopen.xliff.v2.IAnnotation;
import org.oasisopen.xliff.v2.IMarker;
import org.oasisopen.xliff.v2.InlineType;

public class Annotation
implements IAnnotation {
    private static final long serialVersionUID = 64L;
    private InlineType inlineType;
    private String internalId;
    private String id;
    private String type;
    private String value;
    private String ref;
    private boolean translate = true;

    public Annotation(String id, boolean opening, String type) {
        this.id = id;
        this.inlineType = opening ? InlineType.OPENING : InlineType.CLOSING;
        this.setType(type);
    }

    public Annotation(String id, boolean opening, String type, String value) {
        this.id = id;
        this.inlineType = opening ? InlineType.OPENING : InlineType.CLOSING;
        this.setType(type);
        this.setValue(value);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        if (type == null) {
            throw new RuntimeException("Annotation type cannot be null.");
        }
        this.type = type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.internalId = id;
    }

    @Override
    public String getInternalId() {
        return this.internalId;
    }

    @Override
    public InlineType getInlineType() {
        return this.inlineType;
    }

    @Override
    public void setInlineType(InlineType inlineType) {
        this.inlineType = inlineType;
    }

    @Override
    public String getRef() {
        return this.ref;
    }

    @Override
    public void setRef(String ref) {
        this.ref = ref;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean getTranslate() {
        return this.translate;
    }

    @Override
    public void setTranslate(boolean translate) {
        this.translate = translate;
    }

    @Override
    public boolean equals(IMarker marker) {
        if (marker == null) {
            throw new NullPointerException("The parameter of Code.equals() must not be null.");
        }
        if (this == marker) {
            return true;
        }
        if (!(marker instanceof IAnnotation)) {
            return false;
        }
        IAnnotation anno = (IAnnotation)marker;
        if (Util.compareAllowingNull(this.type, anno.getType()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.id, anno.getId()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.ref, anno.getRef()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.value, anno.getValue()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.internalId, anno.getInternalId()) != 0) {
            return false;
        }
        return this.translate == anno.getTranslate();
    }

    @Override
    public boolean isAnnotation() {
        return true;
    }
}

