/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import net.sf.okapi.lib.xliff.ExtendedAttribute;
import org.oasisopen.xliff.v2.IExtendedAttribute;
import org.oasisopen.xliff.v2.IExtendedAttributes;

public class ExtendedAttributes
implements IExtendedAttributes {
    private static final long serialVersionUID = 64L;
    private ArrayList<IExtendedAttribute> attrs;
    private Map<String, String> namespaces;

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        if (this.attrs == null) {
            return null;
        }
        for (IExtendedAttribute att : this.attrs) {
            if (!att.getLocalPart().equals(localName) || !att.getNamespaceURI().equals(namespaceURI)) continue;
            return att.getValue();
        }
        return null;
    }

    @Override
    public IExtendedAttribute getAttribute(String namespaceURI, String localName) {
        if (this.attrs == null) {
            return null;
        }
        for (IExtendedAttribute att : this.attrs) {
            if (!att.getLocalPart().equals(localName) || !att.getNamespaceURI().equals(namespaceURI)) continue;
            return att;
        }
        return null;
    }

    @Override
    public IExtendedAttribute setAttribute(IExtendedAttribute attribute) {
        if (this.attrs == null) {
            this.attrs = new ArrayList();
        }
        int pos = 0;
        for (IExtendedAttribute att : this.attrs) {
            if (att.getLocalPart().equals(attribute.getLocalPart()) && att.getNamespaceURI().equals(attribute.getNamespaceURI())) {
                this.attrs.set(pos, attribute);
                return attribute;
            }
            ++pos;
        }
        this.attrs.add(attribute);
        return attribute;
    }

    @Override
    public IExtendedAttribute setAttribute(String namespaceURI, String localName, String value) {
        IExtendedAttribute att;
        if (this.attrs == null) {
            this.attrs = new ArrayList();
        }
        if ((att = this.getAttribute(namespaceURI, localName)) == null) {
            att = new ExtendedAttribute(new QName(namespaceURI, localName), value);
            this.attrs.add(att);
        }
        att.setValue(value);
        return att;
    }

    @Override
    public void deleteAttribute(String namespaceURI, String localName) {
        if (this.attrs == null) {
            return;
        }
        IExtendedAttribute att = this.getAttribute(namespaceURI, localName);
        if (att == null) {
            return;
        }
        this.attrs.remove(att);
    }

    @Override
    public int size() {
        if (this.attrs == null) {
            return 0;
        }
        return this.attrs.size();
    }

    @Override
    public Iterator<IExtendedAttribute> iterator() {
        return new Iterator<IExtendedAttribute>(){
            int current = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The method remove() not supported.");
            }

            @Override
            public IExtendedAttribute next() {
                return (IExtendedAttribute)ExtendedAttributes.this.attrs.get(++this.current - 1);
            }

            @Override
            public boolean hasNext() {
                return ExtendedAttributes.this.attrs != null && !ExtendedAttributes.this.attrs.isEmpty() && this.current < ExtendedAttributes.this.attrs.size();
            }
        };
    }

    @Override
    public void setNamespace(String prefix, String namespaceURI) {
        if (this.namespaces == null) {
            this.namespaces = new LinkedHashMap<String, String>();
        }
        this.namespaces.put(namespaceURI, prefix);
    }

    @Override
    public String getNamespacePrefix(String namespaceURI) {
        if (this.namespaces == null) {
            return null;
        }
        return this.namespaces.get(namespaceURI);
    }

    @Override
    public boolean hasNamespace() {
        if (this.namespaces == null) {
            return false;
        }
        return this.namespaces.size() > 0;
    }

    @Override
    public Set<String> getNamespaces() {
        if (this.namespaces == null) {
            return Collections.emptySet();
        }
        return this.namespaces.keySet();
    }
}

