/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.idaligner;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.PathInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String GENERATETMX = "generateTMX";
    private static final String TMXOUTPUTPATH = "tmxOutputPath";
    private static final String REPLACEWITHSOURCE = "replaceWithSource";
    private static final String COPYTOTARGET = "copyToTarget";
    private static final String STOREASALTTRANSLATION = "storeAsAltTranslation";
    private boolean generateTMX;
    private String tmxOutputPath;
    private boolean replaceWithSource;
    private boolean copyToTarget;
    private boolean storeAsAltTranslation;

    public Parameters() {
        this.reset();
    }

    public boolean getGenerateTMX() {
        return this.generateTMX;
    }

    public void setGenerateTMX(boolean generateTMX) {
        this.generateTMX = generateTMX;
    }

    public String getTmxOutputPath() {
        return this.tmxOutputPath;
    }

    public void setTmxOutputPath(String tmxOutputPath) {
        this.tmxOutputPath = tmxOutputPath;
    }

    public boolean getReplaceWithSource() {
        return this.replaceWithSource;
    }

    public void setReplaceWithSource(boolean replaceWithSource) {
        this.replaceWithSource = replaceWithSource;
    }

    public void setCopyToTarget(boolean copyToTarget) {
        this.copyToTarget = copyToTarget;
    }

    public boolean isCopyToTarget() {
        return this.copyToTarget;
    }

    public boolean isStoreAsAltTranslation() {
        return this.storeAsAltTranslation;
    }

    public void setStoreAsAltTranslation(boolean storeAsAltTranslation) {
        this.storeAsAltTranslation = storeAsAltTranslation;
    }

    @Override
    public void reset() {
        this.tmxOutputPath = "aligned.tmx";
        this.generateTMX = false;
        this.replaceWithSource = false;
        this.copyToTarget = false;
        this.storeAsAltTranslation = true;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.generateTMX = this.buffer.getBoolean(GENERATETMX, this.generateTMX);
        this.tmxOutputPath = this.buffer.getString(TMXOUTPUTPATH, this.tmxOutputPath);
        this.replaceWithSource = this.buffer.getBoolean(REPLACEWITHSOURCE, this.replaceWithSource);
        this.copyToTarget = this.buffer.getBoolean(COPYTOTARGET, this.copyToTarget);
        this.storeAsAltTranslation = this.buffer.getBoolean(STOREASALTTRANSLATION, this.storeAsAltTranslation);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(GENERATETMX, this.generateTMX);
        this.buffer.setParameter(TMXOUTPUTPATH, this.tmxOutputPath);
        this.buffer.setBoolean(REPLACEWITHSOURCE, this.replaceWithSource);
        this.buffer.setParameter(COPYTOTARGET, this.copyToTarget);
        this.buffer.setParameter(STOREASALTTRANSLATION, this.storeAsAltTranslation);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(GENERATETMX, "Generate a TMX file:", "If generateTMX is false generate bilingual TextUnits, otherwise (true) output a TMX file");
        desc.add(TMXOUTPUTPATH, "TMX output path", "Full path of the output TMX file");
        desc.add(REPLACEWITHSOURCE, "Fall back to source text", "If no target text is available, use the source text");
        desc.add(COPYTOTARGET, "Copy to/over the target (WARNING: Copied target will not be segmented)", "Copy to/over the target (an annotation will still be created if requested). WARNING: Copied target will not be segmented and any exisiting target will be lost.");
        desc.add(STOREASALTTRANSLATION, "Create an alternate translation annotation", "Store the matched target as an alternate translation so that subsequent steps can see it.");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Id-based Aligner", true, false);
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(GENERATETMX));
        PathInputPart pip = desc.addPathInputPart(paramsDesc.get(TMXOUTPUTPATH), "TMX Document to Generate", true);
        pip.setBrowseFilters("TMX Documents (*.tmx)\tAll Files (*.*)", "*.tmx\t*.*");
        pip.setWithLabel(false);
        pip.setMasterPart(cbp, true);
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get(REPLACEWITHSOURCE));
        desc.addCheckboxPart(paramsDesc.get(COPYTOTARGET));
        desc.addCheckboxPart(paramsDesc.get(STOREASALTTRANSLATION));
        return desc;
    }
}

