/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.rtf;

import net.sf.okapi.common.Event;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.steps.rainbowkit.common.BasePackageWriter;
import net.sf.okapi.steps.rainbowkit.rtf.RTFLayerWriter;

public class RTFPackageWriter
extends BasePackageWriter {
    private RTFLayerWriter layerWriter;

    public RTFPackageWriter() {
        super("rtf");
    }

    @Override
    protected void processStartBatch() {
        this.manifest.setSubDirectories("original", "work", "work", "done", null, true);
        this.setTMXInfo(true, null, false, false);
        super.processStartBatch();
    }

    @Override
    protected void processStartDocument(Event event) {
        super.processStartDocument(event);
        MergingInfo item = this.manifest.getItem(this.docId);
        String path = this.manifest.getTempSourceDirectory() + item.getRelativeInputPath() + ".rtf";
        this.layerWriter = new RTFLayerWriter(this.skelWriter, path, this.manifest.getTargetLocale(), item.getTargetEncoding());
        this.layerWriter.writeEvent(event);
    }

    @Override
    protected void processEndDocument(Event event) {
        this.layerWriter.writeEvent(event);
        super.processEndDocument(event);
    }

    @Override
    protected void processStartSubDocument(Event event) {
        this.layerWriter.writeEvent(event);
    }

    @Override
    protected void processEndSubDocument(Event event) {
        this.layerWriter.writeEvent(event);
    }

    @Override
    protected void processTextUnit(Event event) {
        this.layerWriter.writeEvent(event);
        this.writeTMXEntries(event.getTextUnit());
    }

    @Override
    protected void processStartGroup(Event event) {
        this.layerWriter.writeEvent(event);
    }

    @Override
    protected void processEndGroup(Event event) {
        this.layerWriter.writeEvent(event);
    }

    @Override
    protected void processDocumentPart(Event event) {
        this.layerWriter.writeEvent(event);
    }

    @Override
    public void close() {
        if (this.layerWriter != null) {
            this.layerWriter.close();
            this.layerWriter = null;
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }
}

