/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xmlcharfixing;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static String REPLACEMENT = "replacement";
    private String replacement;

    public Parameters() {
        this.reset();
    }

    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    @Override
    public void reset() {
        this.replacement = "_#x%X;";
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.replacement = this.buffer.getString(REPLACEMENT, this.replacement);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString(REPLACEMENT, this.replacement);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(REPLACEMENT, "Replacement string", "Enter a Java-formatted replacement string.");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("XML Characters Fixing", true, false);
        TextInputPart tip = desc.addTextInputPart(paramDesc.get(REPLACEMENT));
        tip.setAllowEmpty(true);
        return desc;
    }
}

