/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xmlvalidation;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.xmlvalidation.DTDResolver;
import net.sf.okapi.steps.xmlvalidation.Parameters;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

@UsingParameters(value=Parameters.class)
public class XMLValidationStep
extends BasePipelineStep {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private XMLInputFactory xmlInputFact;
    private String currentFileDir;
    private Parameters params = new Parameters();

    @Override
    public void destroy() {
    }

    @Override
    public String getDescription() {
        return "Validate XML documents. Expects: raw XML document. Sends back: raw XML document.";
    }

    @Override
    public String getName() {
        return "XML Validation";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.xmlInputFact = XMLInputFactory.newInstance();
        if (this.params.isValidate()) {
            this.logger.info("Validating using XML Schema: " + this.params.getSchemaPath());
        }
        return event;
    }

    @Override
    protected Event handleRawDocument(Event event) {
        RawDocument rawDoc = (RawDocument)event.getResource();
        this.currentFileDir = Util.getDirectoryName(rawDoc.getInputURI().getPath());
        StreamSource xmlInput = null;
        xmlInput = rawDoc.getInputURI() == null ? new StreamSource(rawDoc.getStream()) : new StreamSource(rawDoc.getStream(), rawDoc.getInputURI().getPath());
        try {
            XMLStreamReader reader = this.xmlInputFact.createXMLStreamReader(xmlInput);
            while (reader.hasNext()) {
                reader.next();
            }
            reader.close();
        }
        catch (XMLStreamException e) {
            this.logger.severe("Well-Formedness Error Line: " + e.getLocation().getLineNumber() + ", Column: " + e.getLocation().getColumnNumber() + ", Offset: " + e.getLocation().getCharacterOffset() + "\n" + e.getMessage());
            return event;
        }
        if (this.params.isValidate()) {
            xmlInput = new StreamSource(rawDoc.getStream());
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(true);
                SAXParser parser = factory.newSAXParser();
                if (this.params.getValidationType() != 0 && this.params.getValidationType() == 1) {
                    parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                    if (this.params.getSchemaPath().length() > 0) {
                        parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", new File(this.params.getSchemaPath()));
                    }
                }
                XMLReader reader = parser.getXMLReader();
                reader.setErrorHandler(new ErrorHandler(){

                    @Override
                    public void error(SAXParseException e) throws SAXException {
                        XMLValidationStep.this.logger.severe("Validation Error Line: " + e.getLineNumber() + ", Column: " + e.getColumnNumber() + "\n" + e.getMessage() + "\n");
                        throw new SAXException("Error encountered");
                    }

                    @Override
                    public void fatalError(SAXParseException e) throws SAXException {
                        XMLValidationStep.this.logger.severe("Validation Fatal Error Line: " + e.getLineNumber() + ", Column: " + e.getColumnNumber() + "\n" + e.getMessage() + "\n");
                        throw new SAXException("Fatal Error encountered");
                    }

                    @Override
                    public void warning(SAXParseException e) throws SAXException {
                        XMLValidationStep.this.logger.severe("Validation Warning Line: " + e.getLineNumber() + ", Column: " + e.getColumnNumber() + "\n" + e.getMessage() + "\n");
                        throw new SAXException("Warning encountered");
                    }
                });
                reader.setEntityResolver(new DTDResolver(this.currentFileDir));
                reader.parse(new InputSource(rawDoc.getStream()));
            }
            catch (ParserConfigurationException e) {
                this.logger.severe(e.getMessage());
                return event;
            }
            catch (SAXException e) {
                this.logger.severe(e.getMessage());
                return event;
            }
            catch (IOException e) {
                this.logger.severe(e.getMessage());
                return event;
            }
        }
        return event;
    }
}

