/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.jboss.resteasy.client.core.ClientInvoker;
import org.jboss.resteasy.client.core.ClientInvokerModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientProxy
implements InvocationHandler {
    private Map<Method, ClientInvoker> methodMap;
    private Class<?> clazz;

    public ClientProxy(Map<Method, ClientInvoker> methodMap) {
        this.methodMap = methodMap;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Object invoke(Object o, Method method, Object[] args) throws Throwable {
        ClientInvoker clientInvoker = this.methodMap.get(method);
        if (clientInvoker == null) {
            if (method.getName().equals("equals")) {
                return this.equals(o);
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("toString") && (args == null || args.length == 0)) {
                return this.toString();
            }
            if (method.getName().equals("getResteasyClientInvokers")) {
                return this.methodMap.values();
            }
            if (method.getName().equals("applyClientInvokerModifier")) {
                ClientInvokerModifier modifier = (ClientInvokerModifier)args[0];
                for (ClientInvoker invoker : this.methodMap.values()) {
                    modifier.modify(invoker);
                }
                return null;
            }
        }
        if (clientInvoker == null) {
            throw new RuntimeException("Could not find a method for: " + method);
        }
        return clientInvoker.invoke(args);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ClientProxy)) {
            return false;
        }
        ClientProxy other = (ClientProxy)obj;
        if (other == this) {
            return true;
        }
        if (other.clazz != this.clazz) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    public String toString() {
        return "Client Proxy for :" + this.clazz.getName();
    }
}

