/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core.extractors;

import java.lang.reflect.Method;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.Body;
import org.jboss.resteasy.annotations.Status;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.core.extractors.BodyEntityExtractor;
import org.jboss.resteasy.client.core.extractors.ClientRequestContext;
import org.jboss.resteasy.client.core.extractors.DefaultEntityExtractorFactory;
import org.jboss.resteasy.client.core.extractors.EntityExtractor;
import org.jboss.resteasy.spi.LinkHeader;

public class ResponseObjectEntityExtractorFactory
extends DefaultEntityExtractorFactory {
    public EntityExtractor createExtractor(Method method) {
        Class<?> returnType = method.getReturnType();
        if (method.isAnnotationPresent(Status.class)) {
            if (returnType == Integer.class || returnType == Integer.TYPE) {
                return new EntityExtractor<Integer>(){

                    @Override
                    public Integer extractEntity(ClientRequestContext context, Object ... args) {
                        return context.getClientResponse().getStatus();
                    }
                };
            }
            if (returnType == Response.Status.class) {
                return ResponseObjectEntityExtractorFactory.createStatusExtractor(false);
            }
        }
        if (method.isAnnotationPresent(Body.class)) {
            return new BodyEntityExtractor(method);
        }
        final HeaderParam headerParam = method.getAnnotation(HeaderParam.class);
        if (headerParam != null) {
            return new EntityExtractor(){

                public Object extractEntity(ClientRequestContext context, Object ... args) {
                    return context.getClientResponse().getHeaders().getFirst(headerParam.value());
                }
            };
        }
        if (returnType == ClientRequest.class) {
            return new EntityExtractor(){

                public Object extractEntity(ClientRequestContext context, Object ... args) {
                    return context.getRequest();
                }
            };
        }
        if (Response.class.isAssignableFrom(returnType)) {
            return this.createResponseTypeEntityExtractor(method);
        }
        if (returnType == LinkHeader.class) {
            return new EntityExtractor(){

                public Object extractEntity(ClientRequestContext context, Object ... args) {
                    return context.getClientResponse().getLinkHeader();
                }
            };
        }
        return null;
    }
}

