/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.LocaleId;
import org.junit.Assert;
import org.junit.Test;

public class ListUtilTest {
    @Test
    public void testListToArray() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Blobbo");
        list.add("Cracked");
        list.add("Dumbo");
        list.add("");
        Assert.assertEquals((long)4L, (long)list.size());
        String[] sl = ListUtil.stringListAsArray(list);
        Assert.assertEquals((long)4L, (long)sl.length);
        ArrayList<Object> list2 = new ArrayList<Object>();
        list2.add(new String());
        list2.add(new Integer(2));
        list2.add(new Boolean(false));
        list2.add(new Boolean(true));
        list2.add(null);
        list2.add(new Character('A'));
        Assert.assertEquals((long)6L, (long)list2.size());
        Object[] ol = ListUtil.objectListAsArray(list2);
        Assert.assertEquals((long)6L, (long)ol.length);
        ArrayList list3 = new ArrayList();
        list3.add(String.class);
        list3.add(Integer.class);
        list3.add(Boolean.class);
        list3.add(null);
        list3.add(Character.class);
        Assert.assertEquals((long)5L, (long)list3.size());
        Class<?>[] cl = ListUtil.classListAsArray(list3);
        Assert.assertEquals((long)5L, (long)cl.length);
    }

    @Test
    public void testStringAsLanguageList_Several() {
        String st = "en, fr-BE, ZU";
        List<LocaleId> list = ListUtil.stringAsLanguageList(st);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"en", (Object)list.get(0).toString());
        Assert.assertEquals((Object)"fr-be", (Object)list.get(1).toString());
        Assert.assertEquals((Object)"zu", (Object)list.get(2).toString());
    }

    @Test
    public void testStringAsLanguageList_Complex() {
        String st = "  en ,,  fr-BE,\t ZU,";
        List<LocaleId> list = ListUtil.stringAsLanguageList(st);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"en", (Object)list.get(0).toString());
        Assert.assertEquals((Object)"fr-be", (Object)list.get(1).toString());
        Assert.assertEquals((Object)"zu", (Object)list.get(2).toString());
    }

    @Test
    public void testStringAsLanguageList_One() {
        String st = "en-us";
        List<LocaleId> list = ListUtil.stringAsLanguageList(st);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"en-us", (Object)list.get(0).toString());
    }

    @Test
    public void testStringAsLanguageList_None() {
        String st = ", ,";
        List<LocaleId> list = ListUtil.stringAsLanguageList(st);
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testStringAsList() {
        String st = "1,2,3,4";
        List<String> list = ListUtil.stringAsList(st);
        Assert.assertNotNull(list);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"1", (Object)list.get(0));
        Assert.assertEquals((Object)"2", (Object)list.get(1));
        Assert.assertEquals((Object)"3", (Object)list.get(2));
        Assert.assertEquals((Object)"4", (Object)list.get(3));
        st = "1,2,3,4,  ";
        list = ListUtil.stringAsList(st);
        Assert.assertNotNull(list);
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertEquals((Object)"1", (Object)list.get(0));
        Assert.assertEquals((Object)"2", (Object)list.get(1));
        Assert.assertEquals((Object)"3", (Object)list.get(2));
        Assert.assertEquals((Object)"4", (Object)list.get(3));
        Assert.assertEquals((Object)"", (Object)list.get(4));
        String[] s = ListUtil.stringAsArray(st);
        Assert.assertEquals((long)5L, (long)s.length);
        Assert.assertEquals((Object)"1", (Object)s[0]);
        Assert.assertEquals((Object)"2", (Object)s[1]);
        Assert.assertEquals((Object)"3", (Object)s[2]);
        Assert.assertEquals((Object)"4", (Object)s[3]);
        Assert.assertEquals((Object)"", (Object)s[4]);
    }

    @Test
    public void testMerge() {
        List<String> list = Arrays.asList("aaaa", "bbb", "cccc", "ddddd");
        Assert.assertEquals((Object)"", (Object)ListUtil.merge(list, -1, -1, "-"));
        Assert.assertEquals((Object)"", (Object)ListUtil.merge(list, 100, 200, "-"));
        Assert.assertEquals((Object)"", (Object)ListUtil.merge(list, 3, 2, "-"));
        Assert.assertEquals((Object)"bbb-cccc", (Object)ListUtil.merge(list, 1, 2, "-"));
        Assert.assertEquals((Object)"bbb-cccc-ddddd", (Object)ListUtil.merge(list, 1, 3, "-"));
        Assert.assertEquals((Object)"cccc-ddddd", (Object)ListUtil.merge(list, 2, 5, "-"));
        String[] array = new String[]{"aaaa", "bbb", "cccc", "ddddd"};
        Assert.assertEquals((Object)"", (Object)ListUtil.merge(array, -1, -1, "-"));
        Assert.assertEquals((Object)"", (Object)ListUtil.merge(array, 100, 200, "-"));
        Assert.assertEquals((Object)"", (Object)ListUtil.merge(array, 3, 2, "-"));
        Assert.assertEquals((Object)"bbb-cccc", (Object)ListUtil.merge(array, 1, 2, "-"));
        Assert.assertEquals((Object)"bbb-cccc-ddddd", (Object)ListUtil.merge(array, 1, 3, "-"));
        Assert.assertEquals((Object)"cccc-ddddd", (Object)ListUtil.merge(array, 2, 5, "-"));
    }
}

