/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.annotation;

import java.security.InvalidParameterException;
import java.util.UUID;
import net.sf.okapi.common.HashCodeUtil;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;

public class AltTranslation
implements Comparable<AltTranslation> {
    public static final String ORIGIN_SOURCEDOC = "SourceDoc";
    LocaleId srcLocId;
    LocaleId trgLocId;
    ITextUnit tu;
    MatchType type;
    int combinedScore;
    int fuzzyScore;
    int qualityScore;
    String origin;
    boolean fromOriginal;

    public AltTranslation(LocaleId sourceLocId, LocaleId targetLocId, TextFragment originalSource, TextFragment alternateSource, TextFragment alternateTarget, MatchType type, int combinedScore, String origin) {
        this(sourceLocId, targetLocId, originalSource, alternateSource, alternateTarget, type, combinedScore, origin, combinedScore, QueryResult.QUALITY_UNDEFINED);
    }

    public AltTranslation(LocaleId sourceLocId, LocaleId targetLocId, TextFragment originalSource, TextFragment alternateSource, TextFragment alternateTarget, MatchType type, int combinedScore, String origin, int fuzzyScore, int qualityScore) {
        this.srcLocId = sourceLocId;
        this.trgLocId = targetLocId;
        this.type = type;
        this.combinedScore = combinedScore;
        this.origin = origin;
        this.qualityScore = qualityScore;
        this.fuzzyScore = fuzzyScore;
        this.tu = new TextUnit(UUID.randomUUID().toString());
        if (alternateSource != null) {
            this.tu.setSourceContent(alternateSource);
        }
        if (alternateTarget != null) {
            this.tu.setTargetContent(targetLocId, alternateTarget);
        }
    }

    public TextContainer getTarget() {
        return this.tu.getTarget(this.trgLocId);
    }

    public void setTarget(LocaleId targetLocId, TextFragment alternateTarget) {
        this.trgLocId = targetLocId;
        this.tu.setTargetContent(targetLocId, alternateTarget);
    }

    public LocaleId getSourceLocale() {
        return this.srcLocId;
    }

    public LocaleId getTargetLocale() {
        return this.trgLocId;
    }

    public TextContainer getSource() {
        return this.tu.getSource();
    }

    public int getCombinedScore() {
        return this.combinedScore;
    }

    public String getOrigin() {
        return this.origin;
    }

    public ITextUnit getEntry() {
        return this.tu;
    }

    public MatchType getType() {
        return this.type;
    }

    public void setType(MatchType type) {
        this.type = type;
    }

    public void setCombinedScore(int score) {
        if (score < 0 && score != QueryResult.COMBINEDSCORE_UNDEFINED) {
            throw new InvalidParameterException("Invalid quality value.");
        }
        this.combinedScore = score;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public void setFromOriginal(boolean fromOriginal) {
        this.fromOriginal = fromOriginal;
    }

    public boolean getFromOriginal() {
        return this.fromOriginal;
    }

    public int getFuzzyScore() {
        return this.fuzzyScore;
    }

    public void setFuzzyScore(int fuzzyScore) {
        if (fuzzyScore < 0 || fuzzyScore > 100) {
            throw new InvalidParameterException("Invalid score value.");
        }
        this.fuzzyScore = fuzzyScore;
    }

    public int getQualityScore() {
        return this.qualityScore;
    }

    public void setQualityScore(int qualityScore) {
        if (qualityScore < 0 && qualityScore != QueryResult.QUALITY_UNDEFINED || qualityScore > 100) {
            throw new InvalidParameterException("Invalid quality value.");
        }
        this.qualityScore = qualityScore;
    }

    private boolean isExact(MatchType type) {
        return type.ordinal() < MatchType.EXACT_REPAIRED.ordinal();
    }

    public boolean fromMT() {
        return this.type == MatchType.MT;
    }

    @Override
    public int compareTo(AltTranslation other) {
        int comparison;
        boolean EQUAL = false;
        if (this == other) {
            return 0;
        }
        String thisSource = this.getSource().toString();
        String otherSource = other.getSource().toString();
        if ((this.isExact(this.getType()) || this.isExact(other.getType())) && (comparison = this.getType().compareTo(other.getType())) != 0) {
            return comparison;
        }
        comparison = Float.compare(this.combinedScore, other.getCombinedScore());
        if (comparison != 0) {
            return comparison * -1;
        }
        comparison = thisSource.compareTo(otherSource);
        if (comparison != 0) {
            return comparison;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AltTranslation)) {
            return false;
        }
        AltTranslation otherHit = (AltTranslation)other;
        return this.getType() == otherHit.getType() && this.getSource().toString().equals(otherHit.getSource().toString()) && this.getTarget().toString().equals(otherHit.getTarget().toString());
    }

    public int hashCode() {
        int result = 23;
        result = HashCodeUtil.hash(result, (Object)this.getType());
        result = HashCodeUtil.hash(result, this.getSource().toString());
        result = HashCodeUtil.hash(result, this.getTarget().toString());
        return result;
    }

    public String toString() {
        return String.format("%s %d%% %s", this.type.name(), this.combinedScore, this.tu.getSource());
    }
}

