/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String WRITE_ALL_PROPERTIES_AS_ATTRIBUTES = "writeAllPropertiesAsAttributes";
    private boolean writeAllPropertiesAsAttributes;

    public Parameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.writeAllPropertiesAsAttributes = false;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.writeAllPropertiesAsAttributes = this.buffer.getBoolean(WRITE_ALL_PROPERTIES_AS_ATTRIBUTES, this.writeAllPropertiesAsAttributes);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(WRITE_ALL_PROPERTIES_AS_ATTRIBUTES, this.writeAllPropertiesAsAttributes);
        return this.buffer.toString();
    }

    public boolean isWriteAllPropertiesAsAttributes() {
        return this.writeAllPropertiesAsAttributes;
    }

    public void setWriteAllPropertiesAsAttributes(boolean writeAllPropertiesAsAttributes) {
        this.writeAllPropertiesAsAttributes = writeAllPropertiesAsAttributes;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(WRITE_ALL_PROPERTIES_AS_ATTRIBUTES, "Write all text unit level properties as TMX attributes", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("TMX Filter Writer Options", true, false);
        desc.addCheckboxPart(paramsDesc.get(WRITE_ALL_PROPERTIES_AS_ATTRIBUTES));
        return desc;
    }
}

