/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import java.io.OutputStream;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.annotation.TermsAnnotation;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.filterwriter.XLIFFContent;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

public class XLIFFWriter
implements IFilterWriter {
    public static final String NS_XLIFF12 = "urn:oasis:names:tc:xliff:document:1.2";
    public static final String NS_XLIFFOKAPI = "okapi-framework:xliff-extensions";
    public static final String OKP_MATCHTYPE = "matchType";
    private static final String RESTYPEVALUES = ";auto3state;autocheckbox;autoradiobutton;bedit;bitmap;button;caption;cell;checkbox;checkboxmenuitem;checkedlistbox;colorchooser;combobox;comboboxexitem;comboboxitem;component;contextmenu;ctext;cursor;datetimepicker;defpushbutton;dialog;dlginit;edit;file;filechooser;fn;font;footer;frame;grid;groupbox;header;heading;hedit;hscrollbar;icon;iedit;keywords;label;linklabel;list;listbox;listitem;ltext;menu;menubar;menuitem;menuseparator;message;monthcalendar;numericupdown;panel;popupmenu;pushbox;pushbutton;radio;radiobuttonmenuitem;rcdata;row;rtext;scrollpane;separator;shortcut;spinner;splitter;state3;statusbar;string;tabcontrol;table;textbox;togglebutton;toolbar;tooltip;trackbar;tree;uri;userbutton;usercontrol;var;versioninfo;vscrollbar;window;";
    private XMLWriter writer;
    private XLIFFContent xliffCont = new XLIFFContent();
    private String skeletonPath;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private String dataType;
    private String original;
    private String fwOutputPath;
    private String fwConfigId;
    private String fwInputEncoding;
    private boolean inFile;
    private boolean hasFile;
    private boolean useSourceForTranslated = false;
    private boolean escapeGt = false;
    private boolean placeholderMode = false;
    private boolean includeNoTranslate = true;
    private boolean setApprovedAsNoTranslate = false;
    private boolean copySource = true;
    private boolean includeAltTrans = true;

    public void setCopySource(boolean copySource) {
        this.copySource = copySource;
    }

    public void setPlaceholderMode(boolean placeholderMode) {
        this.placeholderMode = placeholderMode;
    }

    public void setEscapeGt(boolean escapeGt) {
        this.escapeGt = escapeGt;
    }

    public void setUseSourceForTranslated(boolean useSourceForTranslated) {
        this.useSourceForTranslated = useSourceForTranslated;
    }

    public void setIncludeNoTranslate(boolean includeNoTranslate) {
        this.includeNoTranslate = includeNoTranslate;
    }

    public void setIncludeAltTrans(boolean includeAltTrans) {
        this.includeAltTrans = includeAltTrans;
    }

    public void setSetApprovedAsNoTranslate(boolean setApprovedasNoTranslate) {
        this.setApprovedAsNoTranslate = setApprovedasNoTranslate;
    }

    public void create(String xliffPath, String skeletonPath, LocaleId srcLoc, LocaleId trgLoc, String dataType, String original, String message) {
        if (this.writer != null) {
            this.close();
        }
        this.skeletonPath = skeletonPath;
        this.original = original;
        this.srcLoc = srcLoc;
        this.trgLoc = trgLoc;
        this.dataType = dataType;
        this.writer = new XMLWriter(xliffPath);
        this.writer.writeStartDocument();
        this.writer.writeStartElement("xliff");
        this.writer.writeAttributeString("version", "1.2");
        this.writer.writeAttributeString("xmlns", NS_XLIFF12);
        this.writer.writeAttributeString("xmlns:okp", NS_XLIFFOKAPI);
        if (!Util.isEmpty(message)) {
            this.writer.writeLineBreak();
            this.writer.writeComment(message, false);
        }
        this.writer.writeLineBreak();
    }

    @Override
    public void close() {
        if (this.writer != null) {
            if (!this.hasFile) {
                this.writeStartFile(this.original, this.dataType, this.skeletonPath, this.fwConfigId, this.fwInputEncoding, null);
            }
            if (this.inFile) {
                this.writeEndFile();
            }
            this.writer.writeEndElementLineBreak();
            this.writer.writeEndDocument();
            this.writer.close();
            this.writer = null;
        }
        this.fwConfigId = null;
        this.fwInputEncoding = null;
        this.skeletonPath = null;
    }

    public void writeStartFile(String original, String dataType, String skeletonPath) {
        this.writeStartFile(original, dataType, skeletonPath, null, null, null);
    }

    public void writeStartFile(String original, String dataType, String skeletonPath, String extraForHeader) {
        this.writeStartFile(original, dataType, skeletonPath, null, null, extraForHeader);
    }

    private void writeStartFile(String original, String dataType, String skeletonPath, String configId, String inputEncoding, String extraForHeader) {
        this.writer.writeStartElement("file");
        this.writer.writeAttributeString("original", original != null ? original : "unknown");
        this.writer.writeAttributeString("source-language", this.srcLoc.toBCP47());
        if (this.trgLoc != null) {
            this.writer.writeAttributeString("target-language", this.trgLoc.toBCP47());
        }
        if (dataType == null) {
            dataType = "x-undefined";
        } else if (dataType.equals("text/html")) {
            dataType = "html";
        } else if (dataType.equals("text/xml")) {
            dataType = "xml";
        } else if (!dataType.startsWith("x-")) {
            dataType = "x-" + dataType;
        }
        this.writer.writeAttributeString("datatype", dataType);
        if (!Util.isEmpty(inputEncoding)) {
            this.writer.writeAttributeString("okp:inputEncoding", inputEncoding);
        }
        if (!Util.isEmpty(configId)) {
            this.writer.writeAttributeString("okp:configId", configId);
        }
        this.writer.writeLineBreak();
        if (!Util.isEmpty(skeletonPath) || !Util.isEmpty(extraForHeader)) {
            this.writer.writeStartElement("header");
            if (!Util.isEmpty(skeletonPath)) {
                this.writer.writeStartElement("skl");
                this.writer.writeStartElement("external-file");
                this.writer.writeAttributeString("href", skeletonPath);
                this.writer.writeEndElement();
                this.writer.writeEndElement();
            }
            if (!Util.isEmpty(extraForHeader)) {
                this.writer.writeRawXML(extraForHeader);
            }
            this.writer.writeEndElementLineBreak();
        }
        this.hasFile = true;
        this.inFile = true;
        this.writer.writeStartElement("body");
        this.writer.writeLineBreak();
    }

    public void writeEndFile() {
        this.writer.writeEndElementLineBreak();
        this.writer.writeEndElementLineBreak();
        this.inFile = false;
    }

    public void writeStartGroup(String id, String resName, String resType) {
        if (!this.inFile) {
            this.writeStartFile(this.original, this.dataType, this.skeletonPath, this.fwConfigId, this.fwInputEncoding, null);
        }
        this.writer.writeStartElement("group");
        this.writer.writeAttributeString("id", id);
        if (!Util.isEmpty(resName)) {
            this.writer.writeAttributeString("resname", resName);
        }
        if (!Util.isEmpty(resType)) {
            if (resType.startsWith("x-") || RESTYPEVALUES.contains(";" + resType + ";")) {
                this.writer.writeAttributeString("restype", resType);
            } else {
                this.writer.writeAttributeString("restype", "x-" + resType);
            }
        }
        this.writer.writeLineBreak();
    }

    public void writeEndGroup() {
        this.writer.writeEndElementLineBreak();
    }

    public void writeTextUnit(ITextUnit tu) {
        this.writeTextUnit(tu, null);
    }

    public void writeTextUnit(ITextUnit tu, String phaseName) {
        TermsAnnotation ann;
        if (this.fwConfigId == null) {
            Property prop;
            if (this.setApprovedAsNoTranslate && (prop = tu.getTargetProperty(this.trgLoc, "approved")) != null && prop.getValue().equals("yes")) {
                tu.setIsTranslatable(false);
            }
            if (!tu.isTranslatable() && !this.includeNoTranslate) {
                return;
            }
        }
        if (!this.inFile) {
            this.writeStartFile(this.original, this.dataType, this.skeletonPath, this.fwConfigId, this.fwInputEncoding, null);
        }
        this.writer.writeStartElement("trans-unit");
        this.writer.writeAttributeString("id", tu.getId());
        String tmp = tu.getName();
        if (!Util.isEmpty(tmp)) {
            this.writer.writeAttributeString("resname", tmp);
        }
        if (!Util.isEmpty(tmp = tu.getType())) {
            if (tmp.startsWith("x-") || RESTYPEVALUES.contains(";" + tmp + ";")) {
                this.writer.writeAttributeString("restype", tmp);
            } else {
                this.writer.writeAttributeString("restype", "x-" + tmp);
            }
        }
        if (!tu.isTranslatable()) {
            this.writer.writeAttributeString("translate", "no");
        }
        if (phaseName != null) {
            this.writer.writeAttributeString("phase-name", phaseName);
        }
        if (this.trgLoc != null && tu.hasTargetProperty(this.trgLoc, "approved") && tu.getTargetProperty(this.trgLoc, "approved").getValue().equals("yes")) {
            this.writer.writeAttributeString("approved", "yes");
        }
        if (tu.preserveWhitespaces()) {
            this.writer.writeAttributeString("xml:space", "preserve");
        }
        this.writer.writeLineBreak();
        TextContainer tc = tu.getSource();
        boolean srcHasText = tc.hasText(false);
        this.writer.writeStartElement("source");
        this.writer.writeAttributeString("xml:lang", this.srcLoc.toBCP47());
        this.writer.writeRawXML(this.xliffCont.toSegmentedString(tc, 0, this.escapeGt, false, this.placeholderMode));
        this.writer.writeEndElementLineBreak();
        if (tc.hasBeenSegmented()) {
            this.writer.writeStartElement("seg-source");
            this.writer.writeRawXML(this.xliffCont.toSegmentedString(tc, 0, this.escapeGt, true, this.placeholderMode));
            this.writer.writeEndElementLineBreak();
        }
        if (this.trgLoc != null) {
            TextContainer altCont;
            tc = tu.getTarget(this.trgLoc);
            boolean outputTarget = true;
            if (this.useSourceForTranslated || tc == null || tc.isEmpty() || srcHasText && !tc.hasText(false)) {
                tc = tu.getSource();
                outputTarget = this.copySource;
            }
            if (outputTarget) {
                this.writer.writeStartElement("target");
                this.writer.writeAttributeString("xml:lang", this.trgLoc.toBCP47());
                this.writer.writeRawXML(this.xliffCont.toSegmentedString(tc, 0, this.escapeGt, tc.hasBeenSegmented(), this.placeholderMode));
                this.writer.writeEndElementLineBreak();
            }
            if (this.includeAltTrans && (altCont = tu.getTarget(this.trgLoc)) != null) {
                this.writeAltTranslations(altCont.getAnnotation(AltTranslationsAnnotation.class), null);
                for (Segment seg : altCont.getSegments()) {
                    this.writeAltTranslations(seg.getAnnotation(AltTranslationsAnnotation.class), seg);
                }
            }
        }
        if (tu.hasProperty("note")) {
            this.writer.writeStartElement("note");
            this.writer.writeString(tu.getProperty("note").getValue());
            this.writer.writeEndElementLineBreak();
        }
        if (tu.hasProperty("transNote")) {
            this.writer.writeStartElement("note");
            this.writer.writeAttributeString("from", "translator");
            this.writer.writeString(tu.getProperty("transNote").getValue());
            this.writer.writeEndElementLineBreak();
        }
        if ((ann = tu.getSource().getAnnotation(TermsAnnotation.class)) != null && ann.size() > 0) {
            this.writer.writeStartElement("note");
            this.writer.writeAttributeString("annotates", "source");
            this.writer.writeString("Terms:\n" + ann.toString());
            this.writer.writeEndElementLineBreak();
        }
        this.writer.writeEndElementLineBreak();
    }

    private void writeAltTranslations(AltTranslationsAnnotation ann, Segment segment) {
        if (ann == null) {
            return;
        }
        for (AltTranslation alt : ann) {
            TextContainer cont;
            this.writer.writeStartElement("alt-trans");
            if (segment != null) {
                this.writer.writeAttributeString("mid", segment.getId());
            }
            if (alt.getCombinedScore() > 0) {
                this.writer.writeAttributeString("match-quality", String.format("%d", alt.getCombinedScore()));
            }
            if (!Util.isEmpty(alt.getOrigin())) {
                this.writer.writeAttributeString("origin", alt.getOrigin());
            }
            if (alt.getType() != MatchType.UKNOWN) {
                this.writer.writeAttributeString("okp:matchType", alt.getType().toString());
            }
            if (!(cont = alt.getSource()).isEmpty()) {
                this.writer.writeStartElement("source");
                this.writer.writeAttributeString("xml:lang", alt.getSourceLocale().toBCP47());
                this.writer.writeRawXML(this.xliffCont.toSegmentedString(cont, 0, this.escapeGt, false, this.placeholderMode));
                this.writer.writeEndElementLineBreak();
            }
            this.writer.writeStartElement("target");
            this.writer.writeAttributeString("xml:lang", alt.getTargetLocale().toBCP47());
            this.writer.writeRawXML(this.xliffCont.toSegmentedString(alt.getTarget(), 0, this.escapeGt, false, this.placeholderMode));
            this.writer.writeEndElementLineBreak();
            this.writer.writeEndElementLineBreak();
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument((StartDocument)event.getResource());
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                break;
            }
            case START_SUBDOCUMENT: {
                this.processStartSubDocument((StartSubDocument)event.getResource());
                break;
            }
            case END_SUBDOCUMENT: {
                this.processEndSubDocument((Ending)event.getResource());
                break;
            }
            case START_GROUP: {
                this.processStartGroup((StartGroup)event.getResource());
                break;
            }
            case END_GROUP: {
                this.processEndGroup((Ending)event.getResource());
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event.getTextUnit());
            }
        }
        return event;
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.trgLoc = locale;
    }

    @Override
    public void setOutput(String path) {
        this.fwOutputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        throw new OkapiUnsupportedEncodingException("Stream-based output not supported.");
    }

    @Override
    public void setParameters(IParameters params) {
    }

    private void processStartDocument(StartDocument resource) {
        this.create(this.fwOutputPath, null, resource.getLocale(), this.trgLoc, resource.getMimeType(), resource.getName(), null);
        this.placeholderMode = true;
        this.fwInputEncoding = resource.getEncoding();
        IParameters params = resource.getFilterParameters();
        this.fwConfigId = params == null ? null : params.getPath();
    }

    private void processEndDocument() {
        this.close();
    }

    private void processStartSubDocument(StartSubDocument resource) {
        this.writeStartFile(resource.getName(), resource.getMimeType(), null, this.fwConfigId, this.fwInputEncoding, null);
    }

    private void processEndSubDocument(Ending resource) {
        this.writeEndFile();
    }

    private void processStartGroup(StartGroup resource) {
        this.writeStartGroup(resource.getId(), resource.getName(), resource.getType());
    }

    private void processEndGroup(Ending resource) {
        this.writer.writeEndElementLineBreak();
    }

    private void processTextUnit(ITextUnit tu) {
        this.writeTextUnit(tu, null);
    }
}

