/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipelinedriver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiBadStepInputException;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipeline;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.Pipeline;
import net.sf.okapi.common.pipeline.annotations.ConfigurationParameter;
import net.sf.okapi.common.pipeline.annotations.StepIntrospector;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.DocumentData;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.IPipelineDriver;
import net.sf.okapi.common.resource.RawDocument;

public class PipelineDriver
implements IPipelineDriver {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private IPipeline pipeline = new Pipeline();
    private List<IBatchItemContext> batchItems = new ArrayList<IBatchItemContext>();
    private LinkedList<List<ConfigurationParameter>> paramList = new LinkedList();
    private IPipelineStep lastOutputStep;
    private int maxInputCount = 1;
    private IFilterConfigurationMapper fcMapper;
    private String rootDir;
    private String inputRootDir;
    private Object uiParent;

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @Override
    public void setRootDirectories(String rootDir, String inputRootDir) {
        this.rootDir = rootDir;
        this.inputRootDir = inputRootDir;
    }

    @Override
    public void setUIParent(Object uiParent) {
        this.uiParent = uiParent;
    }

    @Override
    public void setPipeline(IPipeline pipeline) {
        if (this.pipeline != null) {
            this.pipeline.cancel();
        }
        if (pipeline != null) {
            pipeline.cancel();
        }
        this.pipeline = new Pipeline();
        this.clearSteps();
        if (pipeline != null) {
            for (IPipelineStep step : pipeline.getSteps()) {
                this.addStep(step);
            }
        }
        this.pipeline = pipeline;
    }

    @Override
    public IPipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public void addStep(IPipelineStep step) {
        this.pipeline.addStep(step);
        List<ConfigurationParameter> pList = StepIntrospector.getStepParameters(step);
        this.paramList.add(pList);
        for (ConfigurationParameter p : pList) {
            if (p.getParameterType() == StepParameterType.OUTPUT_URI) {
                if (this.lastOutputStep != null) {
                    this.lastOutputStep.setLastOutputStep(false);
                }
                this.lastOutputStep = step;
                this.lastOutputStep.setLastOutputStep(true);
                continue;
            }
            if (p.getParameterType() == StepParameterType.SECOND_INPUT_RAWDOC) {
                this.maxInputCount = 2;
                continue;
            }
            if (p.getParameterType() != StepParameterType.THIRD_INPUT_RAWDOC) continue;
            this.maxInputCount = 3;
        }
    }

    @Override
    public void processBatch(List<IBatchItemContext> batchItems) {
        this.batchItems = batchItems;
        this.processBatch();
    }

    @Override
    public void processBatch() {
        if (this.batchItems.size() > 0) {
            this.assignRuntimeParameters(this.batchItems.get(0));
        }
        this.pipeline.startBatch();
        for (IBatchItemContext item : this.batchItems) {
            this.displayInput(item);
            this.assignRuntimeParameters(item);
            this.pipeline.process(item.getRawDocument(0));
        }
        this.pipeline.endBatch();
    }

    @Override
    public void addBatchItem(IBatchItemContext item) {
        this.batchItems.add(item);
    }

    @Override
    public void addBatchItem(RawDocument ... rawDocs) {
        BatchItemContext item = new BatchItemContext();
        for (RawDocument rawDoc : rawDocs) {
            DocumentData ddi = new DocumentData();
            ddi.rawDocument = rawDoc;
            item.add(ddi);
        }
        this.batchItems.add(item);
    }

    @Override
    public void addBatchItem(RawDocument rawDoc, URI outputURI, String outputEncoding) {
        DocumentData ddi = new DocumentData();
        ddi.rawDocument = rawDoc;
        ddi.outputURI = outputURI;
        ddi.outputEncoding = outputEncoding;
        BatchItemContext item = new BatchItemContext();
        item.add(ddi);
        this.batchItems.add(item);
    }

    @Override
    public void addBatchItem(URI inputURI, String defaultEncoding, String filterConfigId, LocaleId srcLoc, LocaleId trgLoc) {
        DocumentData ddi = new DocumentData();
        ddi.rawDocument = new RawDocument(inputURI, defaultEncoding, srcLoc, trgLoc);
        ddi.rawDocument.setFilterConfigId(filterConfigId);
        BatchItemContext item = new BatchItemContext();
        item.add(ddi);
        this.batchItems.add(item);
    }

    @Override
    public void clearItems() {
        this.batchItems.clear();
    }

    protected void displayInput(IBatchItemContext item) {
        if (item.getRawDocument(0).getInputURI() != null) {
            this.logger.info(String.format("\n-- Input: %s", item.getRawDocument(0).getInputURI().getPath()));
        } else {
            this.logger.info("\n-- Input (No path available)");
        }
    }

    @Override
    public void clearSteps() {
        this.pipeline.clearSteps();
        this.paramList.clear();
        this.lastOutputStep = null;
        this.maxInputCount = 1;
    }

    @Override
    public int getRequestedInputCount() {
        return this.maxInputCount;
    }

    private void assignRuntimeParameters(IBatchItemContext item) {
        try {
            RawDocument input = item.getRawDocument(0);
            for (List list : this.paramList) {
                block21: for (ConfigurationParameter p : list) {
                    Method method = p.getMethod();
                    if (method == null) continue;
                    switch (p.getParameterType()) {
                        case OUTPUT_URI: {
                            if (item.getOutputURI(0) == null) continue block21;
                            method.invoke((Object)p.getStep(), item.getOutputURI(0));
                            continue block21;
                        }
                        case TARGET_LOCALE: {
                            method.invoke((Object)p.getStep(), input.getTargetLocale());
                            continue block21;
                        }
                        case SOURCE_LOCALE: {
                            method.invoke((Object)p.getStep(), input.getSourceLocale());
                            continue block21;
                        }
                        case OUTPUT_ENCODING: {
                            method.invoke((Object)p.getStep(), item.getOutputEncoding(0));
                            continue block21;
                        }
                        case INPUT_URI: {
                            method.invoke((Object)p.getStep(), input.getInputURI());
                            continue block21;
                        }
                        case FILTER_CONFIGURATION_ID: {
                            method.invoke((Object)p.getStep(), input.getFilterConfigId());
                            continue block21;
                        }
                        case FILTER_CONFIGURATION_MAPPER: {
                            method.invoke((Object)p.getStep(), this.fcMapper);
                            continue block21;
                        }
                        case INPUT_RAWDOC: {
                            method.invoke((Object)p.getStep(), input);
                            continue block21;
                        }
                        case SECOND_INPUT_RAWDOC: {
                            method.invoke((Object)p.getStep(), item.getRawDocument(1));
                            continue block21;
                        }
                        case THIRD_INPUT_RAWDOC: {
                            method.invoke((Object)p.getStep(), item.getRawDocument(2));
                            continue block21;
                        }
                        case ROOT_DIRECTORY: {
                            method.invoke((Object)p.getStep(), this.rootDir == null ? "" : this.rootDir);
                            continue block21;
                        }
                        case INPUT_ROOT_DIRECTORY: {
                            method.invoke((Object)p.getStep(), this.inputRootDir == null ? "" : this.inputRootDir);
                            continue block21;
                        }
                        case UI_PARENT: {
                            method.invoke((Object)p.getStep(), this.uiParent);
                            continue block21;
                        }
                        case BATCH_INPUT_COUNT: {
                            method.invoke((Object)p.getStep(), this.batchItems.size());
                            continue block21;
                        }
                    }
                    throw new OkapiBadStepInputException(String.format("The step '%s' is using a runtime parameter not supported by this driver.", p.getStep().getName()));
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error when assigning runtime parameters.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error when assigning runtime parameters.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error when assigning runtime parameters.", e);
        }
    }
}

