/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.okapi.common.filters.FilterTestDriver;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.AnnotatedSpan;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.InlineAnnotation;
import net.sf.okapi.common.resource.InvalidPositionException;
import net.sf.okapi.common.resource.TextFragment;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextFragmentTest {
    private GenericContent fmt;

    @Before
    public void setUp() throws Exception {
        this.fmt = new GenericContent();
    }

    @Test
    public void testConstructors() {
        TextFragment tf1 = new TextFragment();
        Assert.assertTrue((boolean)tf1.isEmpty());
        Assert.assertNotNull((Object)tf1.toText());
        Assert.assertNotNull((Object)tf1.getCodedText());
        tf1 = new TextFragment("text");
        Assert.assertFalse((boolean)tf1.isEmpty());
        TextFragment tf2 = new TextFragment(tf1);
        Assert.assertEquals((Object)tf1.toText(), (Object)tf2.toText());
        Assert.assertNotSame((Object)tf1, (Object)tf2);
    }

    @Test
    public void testAppend() {
        TextFragment tf1 = new TextFragment();
        tf1.append('c');
        Assert.assertEquals((Object)tf1.toText(), (Object)"c");
        tf1 = new TextFragment();
        tf1.append("string");
        Assert.assertEquals((Object)tf1.toText(), (Object)"string");
        tf1.append('c');
        Assert.assertEquals((Object)tf1.toText(), (Object)"stringc");
        TextFragment tf2 = new TextFragment();
        tf2.append(tf1);
        Assert.assertEquals((Object)tf2.toText(), (Object)"stringc");
        Assert.assertNotSame((Object)tf1, (Object)tf2);
        Assert.assertFalse((boolean)tf1.hasCode());
        tf1 = new TextFragment("string");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        String s1 = tf1.getCodedText();
        s1 = s1.toUpperCase();
        Assert.assertEquals((Object)tf1.toText(), (Object)"string<br/>");
        tf1.setCodedText(s1);
        Assert.assertEquals((Object)tf1.toText(), (Object)"STRING<br/>");
        tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        Assert.assertTrue((boolean)tf1.hasCode());
        Code code = tf1.getCode(0);
        Assert.assertEquals((Object)code.getData(), (Object)"<br/>");
        Assert.assertEquals((Object)tf1.toText(), (Object)"<br/>");
    }

    @Test
    public void testAppendWithDifferentCodeIDs() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "a", "[A/]");
        Assert.assertEquals((long)1L, (long)tf1.getCode(0).getId());
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "b", "[B/]");
        Assert.assertEquals((long)1L, (long)tf2.getCode(0).getId());
        tf1.append(' ');
        tf1.append(tf2);
        Assert.assertEquals((Object)"[A/] [B/]", (Object)tf1.toText());
        Assert.assertEquals((long)1L, (long)tf1.getCode(0).getId());
        Assert.assertEquals((long)2L, (long)tf1.getCode(1).getId());
    }

    @Test
    public void testInsert() {
        TextFragment tf1 = new TextFragment();
        tf1.insert(0, new TextFragment("[ins1]"));
        Assert.assertEquals((Object)tf1.toText(), (Object)"[ins1]");
        tf1.insert(4, new TextFragment("ertion"));
        Assert.assertEquals((Object)tf1.toText(), (Object)"[insertion1]");
        tf1.insert(0, new TextFragment("<"));
        Assert.assertEquals((Object)tf1.toText(), (Object)"<[insertion1]");
        tf1.insert(13, new TextFragment(">"));
        Assert.assertEquals((Object)tf1.toText(), (Object)"<[insertion1]>");
        tf1.insert(-1, new TextFragment("$"));
        Assert.assertEquals((Object)tf1.toText(), (Object)"<[insertion1]>$");
        tf1 = new TextFragment();
        tf1.insert(0, new TextFragment("abc"));
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        tf1.insert(1, tf2);
        Code code = tf1.getCode(0);
        Assert.assertEquals((Object)code.getData(), (Object)"<br/>");
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(true), (Object)"a<br/>bc");
        tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf1.insert(4, tf2);
        tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf1.insert(7, tf2);
        tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf1.insert(-1, tf2);
        Assert.assertEquals((Object)tf1.toText(), (Object)"a<br/>b<b>c</b><x/>");
    }

    @Test
    public void testAppendWithSameID() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.OPENING, "b", "[b]");
        tf1.append("T1.");
        TextFragment tf2 = new TextFragment(" T2");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "br", "[br/]");
        tf2.append(TextFragment.TagType.CLOSING, "b", "[/b]");
        Assert.assertEquals((long)tf1.getCodes().get((int)0).id, (long)tf2.getCodes().get((int)0).id);
        Assert.assertEquals((long)2L, (long)tf2.getCodes().get((int)1).id);
        tf1.append(tf2);
        List<Code> codes = tf1.getCodes();
        Assert.assertEquals((long)1L, (long)codes.get((int)0).id);
        Assert.assertEquals((long)1L, (long)codes.get((int)2).id);
    }

    @Test
    public void testRemove() {
        TextFragment tf1 = this.makeFragment1();
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(true), (Object)"[b]A[br/]B[/b]C");
        tf1.remove(2, 3);
        tf1.remove(4, 5);
        tf1.remove(6, 7);
        Assert.assertFalse((boolean)tf1.hasText(true));
        Assert.assertEquals((long)tf1.getCodedText().length(), (long)6L);
        Assert.assertEquals((Object)tf1.toText(), (Object)"[b][br/][/b]");
        tf1 = this.makeFragment1();
        tf1.remove(0, 2);
        tf1.remove(1, 3);
        tf1.remove(2, 4);
        Assert.assertFalse((boolean)tf1.hasCode());
        Assert.assertEquals((long)tf1.getCodedText().length(), (long)3L);
        Assert.assertEquals((Object)tf1.toText(), (Object)"ABC");
    }

    @Test
    public void testInlines() {
        TextFragment tf1 = this.makeFragment1();
        Assert.assertTrue((boolean)tf1.hasCode());
        Assert.assertEquals((Object)tf1.toText(), (Object)"[b]A[br/]B[/b]C");
        Assert.assertEquals((Object)tf1.getCode(0).getData(), (Object)"[b]");
        Assert.assertEquals((Object)tf1.getCode(1).getData(), (Object)"[br/]");
        Assert.assertEquals((Object)tf1.getCode(2).getData(), (Object)"[/b]");
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(false), (Object)"<1>A<2/>B</1>C");
        tf1.remove(0, 2);
        Assert.assertEquals((Object)tf1.toText(), (Object)"A[br/]B[/b]C");
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.OPENING, "b", "[b]");
        tf1.insert(0, tf2);
        Code code1 = new Code(TextFragment.TagType.PLACEHOLDER, "type", "data");
        code1.setReferenceFlag(true);
        code1.setId(100);
        code1.setOuterData("outer");
        Assert.assertEquals((Object)code1.getType(), (Object)"type");
        Assert.assertEquals((Object)code1.getData(), (Object)"data");
        Assert.assertEquals((Object)code1.getOuterData(), (Object)"outer");
        Assert.assertEquals((long)code1.getId(), (long)100L);
        Assert.assertEquals((Object)((Object)code1.getTagType()), (Object)((Object)TextFragment.TagType.PLACEHOLDER));
        tf1 = new TextFragment();
        Code code2 = tf1.append(code1);
        Code code3 = tf1.getCode(0);
        Assert.assertSame((Object)code1, (Object)code2);
        Assert.assertSame((Object)code2, (Object)code3);
        code1 = null;
        Assert.assertEquals((Object)code2.getType(), (Object)"type");
        Assert.assertEquals((Object)code2.getData(), (Object)"data");
        Assert.assertEquals((Object)code2.getOuterData(), (Object)"outer");
        Assert.assertEquals((long)code2.getId(), (long)100L);
        Assert.assertEquals((Object)((Object)code2.getTagType()), (Object)((Object)TextFragment.TagType.PLACEHOLDER));
        Code code4 = code2.clone();
        Assert.assertNotSame((Object)code4, (Object)code2);
        Assert.assertEquals((Object)code4.getType(), (Object)"type");
        Assert.assertEquals((Object)code4.getData(), (Object)"data");
        Assert.assertEquals((Object)code4.getOuterData(), (Object)"outer");
        Assert.assertEquals((long)code4.getId(), (long)100L);
        Assert.assertEquals((Object)((Object)code4.getTagType()), (Object)((Object)TextFragment.TagType.PLACEHOLDER));
        code1 = new Code(TextFragment.TagType.PLACEHOLDER, "t", "d");
        Assert.assertFalse((boolean)code1.hasReference());
        Assert.assertFalse((boolean)code1.isCloneable());
        Assert.assertFalse((boolean)code1.isDeleteable());
        code2 = code1.clone();
        Assert.assertFalse((boolean)code2.hasReference());
        Assert.assertFalse((boolean)code2.isCloneable());
        Assert.assertFalse((boolean)code2.isDeleteable());
        code1.setReferenceFlag(true);
        code1.setCloneable(true);
        code1.setDeleteable(true);
        Assert.assertTrue((boolean)code1.hasReference());
        Assert.assertTrue((boolean)code1.isCloneable());
        Assert.assertTrue((boolean)code1.isDeleteable());
        code1.setReferenceFlag(false);
        Assert.assertFalse((boolean)code1.hasReference());
        Assert.assertTrue((boolean)code1.isCloneable());
        Assert.assertTrue((boolean)code1.isDeleteable());
        code1.setCloneable(false);
        Assert.assertFalse((boolean)code1.hasReference());
        Assert.assertFalse((boolean)code1.isCloneable());
        Assert.assertTrue((boolean)code1.isDeleteable());
        code1.setDeleteable(false);
        Assert.assertFalse((boolean)code1.hasReference());
        Assert.assertFalse((boolean)code1.isCloneable());
        Assert.assertFalse((boolean)code1.isDeleteable());
        code1.setReferenceFlag(true);
        code1.setDeleteable(true);
        Assert.assertTrue((boolean)code1.hasReference());
        Assert.assertFalse((boolean)code1.isCloneable());
        Assert.assertTrue((boolean)code1.isDeleteable());
        tf1 = new TextFragment();
        tf1.append(code1);
        String codesStorage1 = Code.codesToString(tf1.getCodes());
        String textStorage1 = tf1.getCodedText();
        Assert.assertNotNull((Object)codesStorage1);
        Assert.assertNotNull((Object)textStorage1);
        tf2 = new TextFragment();
        tf2.setCodedText(textStorage1, Code.stringToCodes(codesStorage1));
        Assert.assertEquals((Object)tf1.toText(), (Object)tf2.toText());
        String codesStorage2 = Code.codesToString(tf2.getCodes());
        String textStorage2 = tf2.getCodedText();
        Assert.assertEquals((Object)codesStorage1, (Object)codesStorage2);
        Assert.assertEquals((Object)textStorage1, (Object)textStorage2);
    }

    @Test
    public void testCodedText() {
        TextFragment tf1 = this.makeFragment1();
        Assert.assertEquals((long)tf1.getCodedText().length(), (long)9L);
        Assert.assertEquals((long)tf1.getCodedText(3, 5).length(), (long)2L);
        String codedText = tf1.getCodedText();
        List<Code> codes = tf1.getCodes();
        TextFragment tf2 = new TextFragment();
        tf2.setCodedText(codedText, codes);
        Assert.assertEquals((Object)tf1.toText(), (Object)tf2.toText());
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(false), (Object)this.fmt.setContent(tf2).toString(false));
        Assert.assertNotSame((Object)tf1, (Object)tf2);
        codes = null;
        codes = tf1.getCodes(0, 5);
        Assert.assertNotNull(codes);
        Assert.assertEquals((long)codes.size(), (long)2L);
        Assert.assertEquals((Object)codes.get(0).getData(), (Object)"[b]");
        Assert.assertEquals((Object)codes.get(1).getData(), (Object)"[br/]");
    }

    @Test
    public void testHasText() {
        TextFragment tf1 = new TextFragment();
        Assert.assertFalse((boolean)tf1.hasText(true));
        Assert.assertFalse((boolean)tf1.hasText(false));
        tf1.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        Assert.assertFalse((boolean)tf1.hasText(true));
        Assert.assertFalse((boolean)tf1.hasText(false));
        tf1.append('\t');
        Assert.assertTrue((boolean)tf1.hasText(true));
        Assert.assertFalse((boolean)tf1.hasText(false));
        tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        tf1.append('c');
        Assert.assertTrue((boolean)tf1.hasText(true));
        Assert.assertTrue((boolean)tf1.hasText(false));
    }

    @Test
    public void testGetText() {
        TextFragment frag = new TextFragment("watch out for ");
        frag.append(TextFragment.TagType.OPENING, "b", "<b>");
        frag.append("the killer");
        frag.append(TextFragment.TagType.CLOSING, "b", "</b>");
        frag.append(" rabbit");
        Assert.assertEquals((Object)"watch out for the killer rabbit", (Object)frag.getText());
    }

    @Test
    public void testHasCode() {
        TextFragment tf1 = new TextFragment();
        Assert.assertFalse((boolean)tf1.hasCode());
        tf1.append('\t');
        Assert.assertFalse((boolean)tf1.hasCode());
        tf1.append('c');
        Assert.assertFalse((boolean)tf1.hasCode());
        tf1.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        Assert.assertTrue((boolean)tf1.hasCode());
    }

    @Test
    public void testSubSequenceSimple() {
        TextFragment tf = new TextFragment("abc");
        Assert.assertEquals((Object)"a", (Object)tf.subSequence(0, 1).toText());
        Assert.assertEquals((Object)"b", (Object)tf.subSequence(1, 2).toText());
        Assert.assertEquals((Object)"c", (Object)tf.subSequence(2, 3).toText());
        Assert.assertEquals((Object)"bc", (Object)tf.subSequence(1, 3).toText());
        Assert.assertEquals((Object)"abc", (Object)tf.subSequence(0, -1).toText());
        TextFragment res = tf.subSequence(1, -1);
        Assert.assertEquals((Object)"bc", (Object)res.toText());
    }

    @Test
    public void testSubSequenceWithCodes() {
        TextFragment tf = this.makeFragment1();
        Assert.assertEquals((Object)"[b]A", (Object)tf.subSequence(0, 3).toText());
        TextFragment res = tf.subSequence(3, -1);
        Assert.assertEquals((Object)"[br/]B[/b]C", (Object)res.toText());
        Assert.assertEquals((long)2L, (long)res.getCodes().size());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSubSequenceError() {
        TextFragment tf = new TextFragment("abc");
        tf.subSequence(3, 4);
    }

    @Test
    public void testCharAt() {
        TextFragment tf = new TextFragment("abc");
        Assert.assertEquals((long)97L, (long)tf.charAt(0));
        Assert.assertEquals((long)99L, (long)tf.charAt(2));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testCharAtError() {
        TextFragment tf = new TextFragment("");
        tf.charAt(1);
    }

    @Test
    public void testLengthSimple() {
        TextFragment tf = new TextFragment();
        Assert.assertEquals((long)0L, (long)tf.length());
        tf.append("abc");
        Assert.assertEquals((long)3L, (long)tf.length());
        Assert.assertEquals((long)tf.length(), (long)tf.toText().length());
    }

    @Test
    public void testLengthWithCodes() {
        TextFragment tf = this.makeFragment1();
        Assert.assertEquals((long)9L, (long)tf.length());
        Assert.assertEquals((long)15L, (long)tf.toText().length());
    }

    @Test
    public void testCharSequence() {
        TextFragment tf = new TextFragment("ABC");
        Pattern pat = Pattern.compile("[bB]");
        Assert.assertTrue((boolean)pat.matcher(tf).find());
        Assert.assertNotNull((Object)new StringBuilder(tf));
    }

    @Test
    public void testToStringNoCodes() {
        TextFragment tf = new TextFragment("abc");
        Assert.assertEquals((Object)tf.toText(), (Object)tf.toString());
    }

    @Test
    public void testToStringWithCodes() {
        TextFragment tf = this.makeFragment1();
        Assert.assertFalse((boolean)tf.toText().equals(tf.toString()));
        Assert.assertEquals((long)tf.charAt(3), (long)tf.toString().charAt(3));
    }

    @Test
    public void testAppendableSeparated() {
        TextFragment tf = new TextFragment();
        StringBuilder csq1 = new StringBuilder("bc");
        StringBuilder csq2 = new StringBuilder("[d]");
        tf.append('a');
        tf.append(csq1);
        tf.append(csq2, 1, 2);
        Assert.assertEquals((Object)"abcd", (Object)tf.toText());
    }

    @Test
    public void testAppendableTFInTF() {
        TextFragment tfA = new TextFragment("a");
        TextFragment tf1 = this.makeFragment1();
        TextFragment tfB = new TextFragment("b");
        Assert.assertEquals((Object)"a[b]A[br/]B[/b]Cb", (Object)tfA.append(tf1).append(tfB).toText());
    }

    @Test
    public void testAppendableTFInTFNested() {
        TextFragment tfA = new TextFragment("a");
        TextFragment tf1 = this.makeFragment1();
        TextFragment tfB = new TextFragment("b");
        Assert.assertEquals((Object)"a[b]A[br/]B[/b]Cb", (Object)tfA.append(tf1.append(tfB)).toText());
    }

    @Test
    public void testAppendableTFInSB() {
        TextFragment tf1 = this.makeFragment1();
        StringBuilder sb = new StringBuilder("xyz");
        TextFragment tfB = new TextFragment("b");
        sb.append(tf1.append(tfB));
        tf1.setCodedText(sb.toString());
        Assert.assertEquals((Object)"xyz[b]A[br/]B[/b]Cb", (Object)tf1.toText());
    }

    @Test
    public void testAppendableSelf() {
        TextFragment tf = this.makeFragment1();
        Assert.assertEquals((Object)"[b]A[br/]B[/b]C[b]A[br/]B[/b]C", (Object)tf.append(tf).toText());
        Code c1 = tf.codes.get(1);
        Code c2 = tf.codes.get(4);
        Assert.assertEquals((Object)c1.toString(), (Object)c2.toString());
        Assert.assertFalse((c1 == c2 ? 1 : 0) != 0);
    }

    @Test
    public void testAppendableTogether() throws IOException {
        TextFragment tf = new TextFragment();
        StringBuilder csq1 = new StringBuilder("bc");
        StringBuilder csq2 = new StringBuilder("[d]");
        tf.append('a').append(csq1).append(csq2, 1, 2);
        Assert.assertEquals((Object)"abcd", (Object)tf.toText());
    }

    @Test
    public void testAppendableNull() throws IOException {
        TextFragment tf = new TextFragment();
        CharSequence csq1 = null;
        tf.append('a').append(csq1).append(csq1, 1, 2);
        Assert.assertEquals((Object)"anullu", (Object)tf.toText());
    }

    @Test
    public void testTextCodesChanges() {
        TextFragment tf1 = new TextFragment("<b>New file:</b> %s");
        int diff = tf1.changeToCode(0, 3, TextFragment.TagType.OPENING, "b");
        diff += tf1.changeToCode(12 + diff, 16 + diff, TextFragment.TagType.CLOSING, "b");
        List<Code> list1 = tf1.getCodes();
        Assert.assertEquals((Object)list1.get(0).getData(), (Object)"<b>");
        Assert.assertEquals((Object)list1.get(1).getData(), (Object)"</b>");
        Assert.assertEquals((Object)tf1.toText(), (Object)"<b>New file:</b> %s");
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(false), (Object)"<1>New file:</1> %s");
        tf1.annotate(17 + diff, 19 + diff, "protected", null);
        Assert.assertEquals((Object)tf1.toText(), (Object)"<b>New file:</b> %s");
        list1 = tf1.getCodes();
        Assert.assertTrue((boolean)list1.get(2).hasAnnotation());
        Assert.assertTrue((boolean)list1.get(2).hasAnnotation("protected"));
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(true), (Object)"<b>New file:</b> %s");
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(false), (Object)"<1>New file:</1> <2>%s</2>");
        String codesStorage1 = Code.codesToString(tf1.getCodes());
        String textStorage1 = tf1.getCodedText();
        Assert.assertNotNull((Object)codesStorage1);
        Assert.assertNotNull((Object)textStorage1);
        TextFragment tf2 = new TextFragment();
        tf2.setCodedText(textStorage1, Code.stringToCodes(codesStorage1));
        Assert.assertEquals((Object)tf1.toText(), (Object)tf2.toText());
        List<Code> list2 = tf2.getCodes();
        Assert.assertTrue((boolean)list1.get(2).hasAnnotation());
        Assert.assertTrue((boolean)list1.get(2).hasAnnotation("protected"));
        Assert.assertEquals((Object)this.fmt.setContent(tf2).toString(true), (Object)"<b>New file:</b> %s");
        Assert.assertEquals((Object)this.fmt.setContent(tf2).toString(false), (Object)"<1>New file:</1> <2>%s</2>");
        tf1.annotate(2, 5, "term", new InlineAnnotation("Nouveau"));
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(true), (Object)"<b>New file:</b> %s");
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(false), (Object)"<1><3>New</3> file:</1> <2>%s</2>");
        InlineAnnotation annot1 = list1.get(4).getAnnotation("term");
        InlineAnnotation annot2 = list1.get(5).getAnnotation("term");
        Assert.assertSame((Object)annot1, (Object)annot2);
        annot1.setData("new data");
        Assert.assertEquals((Object)annot2.toString(), (Object)"new data");
        annot2.setData("Nouveau");
        Assert.assertEquals((Object)annot1.toString(), (Object)"Nouveau");
        Assert.assertEquals((Object)list1.get(4).getAnnotation("term").toString(), (Object)annot2.toString());
        Code c1 = list1.get(4);
        Code c2 = c1.clone();
        annot1 = c1.getAnnotation("term");
        annot2 = c2.getAnnotation("term");
        Assert.assertNotSame((Object)annot1, (Object)annot2);
        tf2 = new TextFragment();
        tf2.setCodedText(tf1.getCodedText(), Code.stringToCodes(Code.codesToString(tf1.getCodes())));
        Assert.assertEquals((Object)tf1.toText(), (Object)tf2.toText());
        list2 = tf2.getCodes();
        Assert.assertTrue((boolean)list2.get(2).hasAnnotation());
        Assert.assertTrue((boolean)list2.get(2).hasAnnotation("protected"));
        Assert.assertTrue((boolean)list2.get(4).hasAnnotation("term"));
        InlineAnnotation annotation = list2.get(4).getAnnotation("term");
        Assert.assertEquals((Object)annotation.getData(), (Object)"Nouveau");
        annotation.setData("Neue");
        list1 = tf1.getCodes();
        Assert.assertEquals((Object)list1.get(4).getAnnotation("term").getData(), (Object)"Nouveau");
        Assert.assertEquals((Object)list2.get(4).getAnnotation("term").getData(), (Object)"Neue");
        tf1.annotate(2, 15, "mt", new InlineAnnotation("MT1"));
        tf1.annotate(2, 15, "term", new InlineAnnotation("TERM2"));
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(false), (Object)"<1><3>New</3> file:</1> <2>%s</2>");
        list1 = tf1.getCodes();
        Assert.assertEquals((Object)list1.get(0).getAnnotation("mt").getData(), (Object)"MT1");
        Assert.assertEquals((Object)list1.get(0).getAnnotation("term").getData(), (Object)"TERM2");
        List<AnnotatedSpan> spans = tf1.getAnnotatedSpans("term");
        Assert.assertEquals((long)spans.size(), (long)2L);
        Assert.assertEquals((Object)this.fmt.setContent(spans.get((int)0).span).toString(true), (Object)"New file:");
        Assert.assertEquals((Object)this.fmt.setContent(spans.get((int)0).span).toString(false), (Object)"<3>New</3> file:");
        Assert.assertEquals((Object)this.fmt.setContent(spans.get((int)1).span).toString(true), (Object)"New");
        Assert.assertEquals((Object)this.fmt.setContent(spans.get((int)1).span).toString(false), (Object)"New");
        Assert.assertEquals((long)spans.get((int)0).range.start, (long)2L);
        Assert.assertEquals((long)spans.get((int)0).range.end, (long)15L);
        Assert.assertEquals((long)spans.get((int)1).range.start, (long)4L);
        Assert.assertEquals((long)spans.get((int)1).range.end, (long)7L);
        Assert.assertTrue((boolean)tf1.hasAnnotation());
        list1.get(0).removeAnnotations();
        Assert.assertTrue((boolean)tf1.hasAnnotation());
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(false), (Object)"<1><3>New</3> file:</1> <2>%s</2>");
        Assert.assertFalse((boolean)list1.get(0).hasAnnotation());
        int n = list1.size();
        list1.get(4).removeAnnotations();
        Assert.assertEquals((long)list1.size(), (long)n);
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(false), (Object)"<1><3>New</3> file:</1> <2>%s</2>");
        tf1.removeAnnotations();
        Assert.assertFalse((boolean)tf1.hasAnnotation());
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(true), (Object)"<b>New file:</b> %s");
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(false), (Object)"<1>New file:</1> %s");
        tf1 = new TextFragment("w1 ");
        tf1.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf1.append("w2 w3");
        tf1.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf1.append(" w4 ");
        tf1.append(TextFragment.TagType.OPENING, "i", "<i>");
        tf1.append("w5 w6");
        tf1.append(TextFragment.TagType.CLOSING, "i", "</i>");
        tf1.append(" w7");
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(false), (Object)"w1 <1>w2 w3</1> w4 <2>w5 w6</2> w7");
        tf1.annotate(5, 10, "a1", null);
        Assert.assertTrue((boolean)tf1.hasAnnotation("a1"));
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(false), (Object)"w1 <1>w2 w3</1> w4 <2>w5 w6</2> w7");
        tf1.annotate(3, 12, "a2", null);
        Assert.assertTrue((boolean)tf1.hasAnnotation("a2"));
        tf1.annotate(5, 7, "a3", null);
        Assert.assertTrue((boolean)tf1.hasAnnotation("a3"));
        tf1.annotate(12, 14, "a4", null);
        Assert.assertTrue((boolean)tf1.hasAnnotation("a4"));
        tf1.removeAnnotations();
        Assert.assertFalse((boolean)tf1.hasAnnotation());
        tf1.annotate(0, 7, "a5", null);
        spans = tf1.getAnnotatedSpans("a5");
    }

    @Test(expected=InvalidPositionException.class)
    public void testGetCodedTextWithBadRange() {
        TextFragment tf = this.makeFragment1();
        tf.getCodedText(1, 3);
    }

    @Test
    public void testCompareToSameString() {
        TextFragment tf = new TextFragment("text of the fragment");
        Assert.assertEquals((long)0L, (long)tf.compareTo("text of the fragment"));
    }

    @Test
    public void testCompareToDifferentString() {
        TextFragment tf = new TextFragment("text of the fragment");
        Assert.assertFalse((0 == tf.compareTo("Text Of The Fragment") ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToSameFragment() {
        TextFragment tf1 = new TextFragment("text of the fragment");
        TextFragment tf2 = new TextFragment("text of the fragment");
        Assert.assertEquals((long)0L, (long)tf1.compareTo(tf2));
        Assert.assertEquals((long)0L, (long)tf1.compareTo(tf2, true));
    }

    @Test
    public void testCompareToDifferentFragment() {
        TextFragment tf1 = new TextFragment("text of the fragment");
        TextFragment tf2 = new TextFragment("text Of The Fragment");
        Assert.assertFalse((0 == tf1.compareTo(tf2) ? 1 : 0) != 0);
        Assert.assertFalse((0 == tf1.compareTo(tf2, true) ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToSameFragmentWithSameCodes() {
        TextFragment tf1 = this.makeFragment1();
        TextFragment tf2 = this.makeFragment1();
        Assert.assertEquals((long)0L, (long)tf1.compareTo(tf2, true));
    }

    @Test
    public void testCompareToWithNoCodesAndCodes() {
        TextFragment tf1 = this.makeFragment1();
        TextFragment tf2 = new TextFragment("ABC");
        Assert.assertEquals((long)0L, (long)tf1.compareTo(tf2, false));
        Assert.assertTrue((0 != tf1.compareTo(tf2, true) ? 1 : 0) != 0);
    }

    @Test
    public void testCloneCodes() {
        TextFragment tf = this.makeFragment3();
        List<Code> list1 = tf.getCodes();
        List<Code> list2 = tf.getClonedCodes();
        Assert.assertEquals((long)list1.size(), (long)list2.size());
        for (int i = 0; i < list1.size(); ++i) {
            Code c1 = list1.get(i);
            Code c2 = list2.get(i);
            Assert.assertNotSame((Object)c1, (Object)c2);
            Assert.assertEquals((long)c1.getId(), (long)c2.getId());
            Assert.assertEquals((Object)c1.getData(), (Object)c2.getData());
            Assert.assertEquals((Object)c1.type, (Object)c2.getType());
        }
    }

    @Test
    public void testCompareToSameFragmentWithDifferentCodes() {
        TextFragment tf1 = this.makeFragment1();
        tf1.getCodes().get(0).setData("[zzz]");
        TextFragment tf2 = this.makeFragment1();
        Assert.assertTrue((0 == tf1.compareTo(tf2, false) ? 1 : 0) != 0);
        Assert.assertFalse((0 == tf1.compareTo(tf2, true) ? 1 : 0) != 0);
    }

    @Test
    public void testCompareWithSamePrefix() {
        TextFragment tf1 = new TextFragment("Message for ID name200");
        TextFragment tf2 = new TextFragment("Message for ID name200 (a nonmatch during diff)");
        Assert.assertFalse((0 == tf1.compareTo(tf2) ? 1 : 0) != 0);
        Assert.assertFalse((0 == tf1.compareTo(tf2, true) ? 1 : 0) != 0);
    }

    @Test
    public void testSynchronizeCodeIdentifiers() {
        TextFragment tf1 = this.makeFragment1();
        TextFragment tf2 = this.makeFragment2();
        tf2.alignCodeIds(tf1);
        FilterTestDriver.checkCodeData(tf1, tf2);
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(false), (Object)"<1>A<2/>B</1>C");
        Assert.assertEquals((Object)this.fmt.setContent(tf2).toString(false), (Object)"<2/>A<1>B</1>C");
    }

    @Test
    public void testSynchronizeCodeIdentifiersComplex() {
        TextFragment tf1 = this.makeFragment1();
        TextFragment tf2 = this.makeFragment3();
        tf2.alignCodeIds(tf1);
        FilterTestDriver.checkCodeData(tf1, tf2);
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(false), (Object)"<1>A<2/>B</1>C");
        Assert.assertEquals((Object)this.fmt.setContent(tf2).toString(false), (Object)"<3><2/>A</3>B<1>C</1>D<4/>");
    }

    @Test
    public void testSynchronizeCodeIdentifiersMoreComplex() {
        TextFragment tf1 = this.makeFragment1();
        TextFragment tf2 = this.makeFragment4();
        tf2.alignCodeIds(tf1);
        FilterTestDriver.checkCodeData(tf1, tf2);
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(false), (Object)"<1>A<2/>B</1>C");
        Assert.assertEquals((Object)this.fmt.setContent(tf2).toString(false), (Object)"<2/>A<3>B</3>C");
    }

    @Test
    public void testSynchronizeCodeIdentifiersMoreComplex2() {
        TextFragment tf1 = this.makeFragment1();
        TextFragment tf2 = this.makeFragment3();
        tf2.alignCodeIds(tf1);
        FilterTestDriver.checkCodeData(tf1, tf2);
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(false), (Object)"<1>A<2/>B</1>C");
        Assert.assertEquals((Object)this.fmt.setContent(tf2).toString(false), (Object)"<3><2/>A</3>B<1>C</1>D<4/>");
    }

    @Test
    public void testSynchronizeCodeIdentifiersPlaceholderOnly() {
        TextFragment tf1 = this.makeFragment5();
        TextFragment tf2 = this.makeFragment6();
        tf2.alignCodeIds(tf1);
        FilterTestDriver.checkCodeData(tf1, tf2);
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(false), (Object)"<1/>A<2/>B<3/>C");
        Assert.assertEquals((Object)this.fmt.setContent(tf2).toString(false), (Object)"<2/>A<1/>B<3/>C<4/>");
    }

    @Test
    public void testIndexOfNonWSEmpty() {
        Assert.assertEquals((long)-1L, (long)TextFragment.indexOfLastNonWhitespace("", -1, 0, true, true, true, true));
        Assert.assertEquals((long)-1L, (long)TextFragment.indexOfFirstNonWhitespace("", 0, -1, true, true, true, true));
    }

    @Test
    public void testIndexOfFirstNonWSSimple() {
        String text = " 12 4   ";
        Assert.assertEquals((long)1L, (long)TextFragment.indexOfFirstNonWhitespace(text, 0, -1, true, true, true, true));
        Assert.assertEquals((long)1L, (long)TextFragment.indexOfFirstNonWhitespace(text, 0, -1, true, true, true, true));
        Assert.assertEquals((long)1L, (long)TextFragment.indexOfFirstNonWhitespace(text, 1, -1, true, true, true, true));
        Assert.assertEquals((long)2L, (long)TextFragment.indexOfFirstNonWhitespace(text, 2, -1, true, true, true, true));
        Assert.assertEquals((long)4L, (long)TextFragment.indexOfFirstNonWhitespace(text, 3, -1, true, true, true, true));
        Assert.assertEquals((long)-1L, (long)TextFragment.indexOfFirstNonWhitespace(text, 5, -1, true, true, true, true));
        Assert.assertEquals((long)-1L, (long)TextFragment.indexOfFirstNonWhitespace(text, 5, 6, true, true, true, true));
    }

    @Test
    public void testIndexOfLastNonWSSimple() {
        String text = "  23 5  8";
        Assert.assertEquals((long)8L, (long)TextFragment.indexOfLastNonWhitespace(text, -1, 5, true, true, true, true));
        Assert.assertEquals((long)8L, (long)TextFragment.indexOfLastNonWhitespace(text, 8, 0, true, true, true, true));
        Assert.assertEquals((long)5L, (long)TextFragment.indexOfLastNonWhitespace(text, 7, 0, true, true, true, true));
        Assert.assertEquals((long)3L, (long)TextFragment.indexOfLastNonWhitespace(text, 4, 0, true, true, true, true));
        Assert.assertEquals((long)3L, (long)TextFragment.indexOfLastNonWhitespace(text, 3, 0, true, true, true, true));
        Assert.assertEquals((long)2L, (long)TextFragment.indexOfLastNonWhitespace(text, 2, 0, true, true, true, true));
        Assert.assertEquals((long)-1L, (long)TextFragment.indexOfLastNonWhitespace(text, 7, 6, true, true, true, true));
        Assert.assertEquals((long)-1L, (long)TextFragment.indexOfLastNonWhitespace(text, 1, 0, true, true, true, true));
    }

    @Test
    public void textIndexOfFirstNonWSEmpty() {
        TextFragment tf = new TextFragment("  ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf.append(" ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf.append(" ");
        String text = tf.getCodedText();
        Assert.assertEquals((long)-1L, (long)TextFragment.indexOfFirstNonWhitespace(text, 0, 0, true, true, true, true));
        Assert.assertEquals((long)-1L, (long)TextFragment.indexOfFirstNonWhitespace(text, 0, -1, true, true, true, true));
        Assert.assertEquals((long)4L, (long)TextFragment.indexOfFirstNonWhitespace(text, 2, 0, true, true, true, false));
    }

    @Test
    public void testIndexOfLastNonWSEmpty() {
        TextFragment tf = new TextFragment("  ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf.append(" ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf.append(" ");
        String text = tf.getCodedText();
        Assert.assertEquals((long)-1L, (long)TextFragment.indexOfLastNonWhitespace(text, -1, 0, true, true, true, true));
        Assert.assertEquals((long)-1L, (long)TextFragment.indexOfLastNonWhitespace(text, 6, 0, true, true, true, true));
        Assert.assertEquals((long)-1L, (long)TextFragment.indexOfLastNonWhitespace(text, 7, 0, true, true, true, true));
        Assert.assertEquals((long)7L, (long)TextFragment.indexOfLastNonWhitespace(text, -1, 0, true, true, true, false));
    }

    @Test
    public void testIndexOfFirstNonWSWithCodes() {
        TextFragment tf = new TextFragment("  ab");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf.append("c");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf.append(" ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        String text = tf.getCodedText();
        Assert.assertEquals((long)2L, (long)TextFragment.indexOfFirstNonWhitespace(text, 0, -1, true, true, true, true));
        Assert.assertEquals((long)2L, (long)TextFragment.indexOfFirstNonWhitespace(text, 0, -1, true, true, true, true));
        Assert.assertEquals((long)6L, (long)TextFragment.indexOfFirstNonWhitespace(text, 4, -1, true, true, true, true));
        Assert.assertEquals((long)-1L, (long)TextFragment.indexOfFirstNonWhitespace(text, 7, -1, true, true, true, true));
        Assert.assertEquals((long)9L, (long)TextFragment.indexOfFirstNonWhitespace(text, 7, -1, true, true, true, false));
        Assert.assertEquals((long)7L, (long)TextFragment.indexOfFirstNonWhitespace(text, 7, -1, true, true, false, true));
        Assert.assertEquals((long)10L, (long)TextFragment.indexOfFirstNonWhitespace(text, 9, -1, true, true, false, true));
    }

    @Test
    public void testIndexOfLastNonWSWithCodes() {
        TextFragment tf = new TextFragment("  ab");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf.append("c");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf.append(" d");
        String text = tf.getCodedText();
        Assert.assertEquals((long)10L, (long)TextFragment.indexOfLastNonWhitespace(text, -1, 0, true, true, true, true));
        Assert.assertEquals((long)6L, (long)TextFragment.indexOfLastNonWhitespace(text, 9, 0, true, true, true, true));
        Assert.assertEquals((long)3L, (long)TextFragment.indexOfLastNonWhitespace(text, 5, 0, true, true, true, true));
        Assert.assertEquals((long)9L, (long)TextFragment.indexOfLastNonWhitespace(text, 9, 0, true, true, true, false));
        Assert.assertEquals((long)8L, (long)TextFragment.indexOfLastNonWhitespace(text, 9, 0, true, true, false, true));
    }

    @Test
    public void testRemoveCode() {
        TextFragment f = this.makeFragment1();
        Code c = f.getCode(1);
        f.removeCode(c);
        Assert.assertEquals((Object)"[b]AB[/b]C", (Object)f.toText());
    }

    @Test
    public void testRenumberCodes() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "(1", "[(1]", 1);
        tf.append("A");
        tf.append(TextFragment.TagType.CLOSING, "1)", "[1)]", 1);
        tf.append(TextFragment.TagType.OPENING, "(2", "[(2]", 2);
        tf.append("AA");
        tf.append(TextFragment.TagType.CLOSING, "2)", "[2)]", 2);
        tf.append(TextFragment.TagType.OPENING, "(3", "[(3]", 3);
        tf.append("B");
        tf.append(TextFragment.TagType.CLOSING, "3)", "[3)]", 3);
        tf.append(TextFragment.TagType.OPENING, "(4", "[(4]", 4);
        tf.append("BB");
        tf.append(TextFragment.TagType.CLOSING, "4)", "[4)]", 4);
        tf.changeToCode(7, 9, TextFragment.TagType.PLACEHOLDER, "x");
        tf.changeToCode(18, 20, TextFragment.TagType.PLACEHOLDER, "x");
        GenericContent fmt = new GenericContent();
        fmt.setContent(tf);
        Assert.assertEquals((Object)"<b1/>A<e1/><b2/><5/><e2/><b3/>B<e3/><b4/><6/><e4/>", (Object)fmt.toString());
        tf.renumberCodes();
        Assert.assertEquals((Object)"[(1]A[1)][(2]AA[2)][(3]B[3)][(4]BB[4)]", (Object)tf.toText());
        Assert.assertEquals((Object)"<b1/>A<e1/><b2/><3/><e2/><b4/>B<e4/><b5/><6/><e5/>", (Object)fmt.toString());
        Assert.assertEquals((long)10L, (long)tf.codes.size());
        Assert.assertEquals((long)1L, (long)tf.codes.get((int)0).id);
        Assert.assertEquals((long)1L, (long)tf.codes.get((int)1).id);
        Assert.assertEquals((long)2L, (long)tf.codes.get((int)2).id);
        Assert.assertEquals((long)3L, (long)tf.codes.get((int)3).id);
        Assert.assertEquals((long)2L, (long)tf.codes.get((int)4).id);
        Assert.assertEquals((long)4L, (long)tf.codes.get((int)5).id);
        Assert.assertEquals((long)4L, (long)tf.codes.get((int)6).id);
        Assert.assertEquals((long)5L, (long)tf.codes.get((int)7).id);
        Assert.assertEquals((long)5L, (long)tf.codes.get((int)8).id);
        Assert.assertEquals((long)6L, (long)tf.codes.get((int)9).id);
        fmt = new GenericContent();
        fmt.setContent(tf);
        Assert.assertEquals((Object)"<b1/>A<e1/><b2/><3/><e2/><b4/>B<e4/><b5/><6/><e5/>", (Object)fmt.toString());
        Assert.assertEquals((Object)"<b1/>A<e1/><b2/><x3/><e2/><b4/>B<e4/><b5/><x6/><e5/>", (Object)fmt.fromFragmentToLetterCoded(tf));
        tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "(4", "[(4]", 4);
        tf.append("A");
        tf.append(TextFragment.TagType.CLOSING, "4)", "[4)]", 4);
        tf.append(TextFragment.TagType.OPENING, "(2", "[(2]", 2);
        tf.append("AA");
        tf.append(TextFragment.TagType.CLOSING, "2)", "[2)]", 2);
        tf.append(TextFragment.TagType.OPENING, "(1", "[(1]", 1);
        tf.append("B");
        tf.append(TextFragment.TagType.CLOSING, "1)", "[1)]", 1);
        tf.append(TextFragment.TagType.OPENING, "(3", "[(3]", 3);
        tf.append("BB");
        tf.append(TextFragment.TagType.CLOSING, "3)", "[3)]", 3);
        tf.changeToCode(7, 9, TextFragment.TagType.PLACEHOLDER, "x");
        tf.changeToCode(18, 20, TextFragment.TagType.PLACEHOLDER, "x");
        fmt = new GenericContent();
        fmt.setContent(tf);
        Assert.assertEquals((Object)"<b4/>A<e4/><b2/><5/><e2/><b1/>B<e1/><b3/><6/><e3/>", (Object)fmt.toString());
        tf.renumberCodes();
        Assert.assertEquals((Object)"[(4]A[4)][(2]AA[2)][(1]B[1)][(3]BB[3)]", (Object)tf.toText());
        Assert.assertEquals((Object)"<b1/>A<e1/><b2/><3/><e2/><b4/>B<e4/><b5/><6/><e5/>", (Object)fmt.toString());
        Assert.assertEquals((long)10L, (long)tf.codes.size());
        Assert.assertEquals((long)1L, (long)tf.codes.get((int)0).id);
        Assert.assertEquals((long)1L, (long)tf.codes.get((int)1).id);
        Assert.assertEquals((long)2L, (long)tf.codes.get((int)2).id);
        Assert.assertEquals((long)3L, (long)tf.codes.get((int)3).id);
        Assert.assertEquals((long)2L, (long)tf.codes.get((int)4).id);
        Assert.assertEquals((long)4L, (long)tf.codes.get((int)5).id);
        Assert.assertEquals((long)4L, (long)tf.codes.get((int)6).id);
        Assert.assertEquals((long)5L, (long)tf.codes.get((int)7).id);
        Assert.assertEquals((long)5L, (long)tf.codes.get((int)8).id);
        Assert.assertEquals((long)6L, (long)tf.codes.get((int)9).id);
        fmt = new GenericContent();
        fmt.setContent(tf);
        Assert.assertEquals((Object)"<b1/>A<e1/><b2/><3/><e2/><b4/>B<e4/><b5/><6/><e5/>", (Object)fmt.toString());
        Assert.assertEquals((Object)"<b1/>A<e1/><b2/><x3/><e2/><b4/>B<e4/><b5/><x6/><e5/>", (Object)fmt.fromFragmentToLetterCoded(tf));
    }

    private TextFragment makeFragment1() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "b", "[b]");
        tf.append("A");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "[br/]");
        tf.append("B");
        tf.append(TextFragment.TagType.CLOSING, "b", "[/b]");
        tf.append("C");
        return tf;
    }

    private TextFragment makeFragment2() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "[br/]");
        tf.append("A");
        tf.append(TextFragment.TagType.OPENING, "b", "[b]");
        tf.append("B");
        tf.append(TextFragment.TagType.CLOSING, "b", "[/b]");
        tf.append("C");
        return tf;
    }

    private TextFragment makeFragment3() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "u", "[u]");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "[br/]");
        tf.append("A");
        tf.append(TextFragment.TagType.CLOSING, "u", "[/u]");
        tf.append("B");
        tf.append(TextFragment.TagType.OPENING, "b", "[b]");
        tf.append("C");
        tf.append(TextFragment.TagType.CLOSING, "b", "[/b]");
        tf.append("D");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "[br/]");
        return tf;
    }

    private TextFragment makeFragment4() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "[br/]");
        tf.append("A");
        tf.append(TextFragment.TagType.OPENING, "u", "[u]");
        tf.append("B");
        tf.append(TextFragment.TagType.CLOSING, "u", "[/u]");
        tf.append("C");
        return tf;
    }

    private TextFragment makeFragment5() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "1", "{1}");
        tf.append("A");
        tf.append(TextFragment.TagType.PLACEHOLDER, "2", "{2}");
        tf.append("B");
        tf.append(TextFragment.TagType.PLACEHOLDER, "3", "{3}");
        tf.append("C");
        return tf;
    }

    private TextFragment makeFragment6() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "2", "{2}");
        tf.append("A");
        tf.append(TextFragment.TagType.PLACEHOLDER, "1", "{1}");
        tf.append("B");
        tf.append(TextFragment.TagType.PLACEHOLDER, "3", "{3}");
        tf.append("C");
        tf.append(TextFragment.TagType.PLACEHOLDER, "4", "{4}");
        return tf;
    }
}

