/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.google;

import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.google.GoogleMTv2Parameters;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.QueryUtil;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class GoogleMTv2Connector
extends BaseConnector {
    private static final int QUERY_LIMIT = 20000;
    private static final int QUERY_BLIMIT = 2048;
    private static final String BASE_URL = "https://www.googleapis.com/language/translate/v2";
    private static final String BASE_QUERY = "?key=%s&source=%s&target=%s";
    private static final String QPARAM = "&q=";
    private GoogleMTv2Parameters params = new GoogleMTv2Parameters();
    private JSONParser parser;
    private QueryUtil util = new QueryUtil();

    public GoogleMTv2Connector() {
        this.parser = new JSONParser();
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (GoogleMTv2Parameters)params;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return "Google-MTv2";
    }

    @Override
    public String getSettingsDisplay() {
        return "Server: https://www.googleapis.com/language/translate/v2";
    }

    @Override
    public void open() {
    }

    @Override
    public int query(String plainText) {
        return this.query(new TextFragment(plainText));
    }

    @Override
    public int query(TextFragment frag) {
        this.current = -1;
        try {
            JSONObject object;
            if (!frag.hasText(false)) {
                return 0;
            }
            if (Util.isEmpty(this.params.getApiKey())) {
                throw new RuntimeException("You must have a Google API Key to use this connector.");
            }
            String qtext = this.util.toCodedHTML(frag);
            String urlString = BASE_URL + String.format(BASE_QUERY, this.params.getApiKey(), this.srcCode, this.trgCode);
            int left = 20000 - (urlString.length() + QPARAM.length());
            if (left < qtext.length()) {
                throw new RuntimeException(String.format("Query too long: Characters available: %d, characters in query: %d.", left, qtext.length()));
            }
            URL url = new URL(urlString + QPARAM + URLEncoder.encode(qtext, "UTF-8"));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            int code = conn.getResponseCode();
            if (code != 200) {
                throw new RuntimeException(String.format("Error: response code %d\n" + conn.getResponseMessage(), code));
            }
            JSONObject map = object = (JSONObject)this.parser.parse(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            Map data = (Map)map.get("data");
            JSONArray translations = (JSONArray)data.get("translations");
            Map resp = (Map)translations.get(0);
            String res = (String)resp.get("translatedText");
            this.result = new QueryResult();
            this.result.weight = this.getWeight();
            this.result.source = frag;
            this.result.target = frag.hasCode() ? new TextFragment(this.util.fromCodedHTML(res, frag, true), frag.getClonedCodes()) : new TextFragment(this.util.fromCodedHTML(res, frag, true));
            this.result.setFuzzyScore(95);
            this.result.origin = this.getName();
            this.result.matchType = MatchType.MT;
            this.current = 0;
        }
        catch (Throwable e) {
            throw new RuntimeException("Error querying the server.\n" + e.getMessage(), e);
        }
        return this.current == 0 ? 1 : 0;
    }

    @Override
    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        this.current = -1;
        ArrayList<List<QueryResult>> allResults = new ArrayList<List<QueryResult>>();
        try {
            boolean doAnotherQuery;
            if (Util.isEmpty(this.params.getApiKey())) {
                throw new RuntimeException("You must have a Google API Key to use this connector.");
            }
            int nextStart = 0;
            do {
                doAnotherQuery = false;
                int start = nextStart;
                int end = fragments.size();
                String urlString = BASE_URL + String.format(BASE_QUERY, this.params.getApiKey(), this.srcCode, this.trgCode);
                int count = 0;
                for (int index = start; index < fragments.size() && !doAnotherQuery; ++index) {
                    TextFragment frag = fragments.get(index);
                    if (!frag.hasText(false)) continue;
                    ++count;
                    String qtext = this.util.toCodedHTML(frag);
                    int left = 2048 - (urlString.length() + QPARAM.length());
                    if (left < qtext.length()) {
                        if (index == start) {
                            throw new RuntimeException(String.format("Query too long: Characters available: %d, characters in query: %d.", left, qtext.length()));
                        }
                        nextStart = index;
                        end = index;
                        doAnotherQuery = true;
                    }
                    if (doAnotherQuery) continue;
                    urlString = urlString + QPARAM + URLEncoder.encode(qtext, "UTF-8");
                }
                ArrayList translations = null;
                if (count > 0) {
                    JSONObject object;
                    URL url = new URL(urlString);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    int code = conn.getResponseCode();
                    if (code != 200) {
                        throw new RuntimeException(String.format("Error: response code %d\n" + conn.getResponseMessage(), code));
                    }
                    JSONObject map = object = (JSONObject)this.parser.parse(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                    Map data = (Map)map.get("data");
                    translations = (JSONArray)data.get("translations");
                }
                int transIndex = -1;
                for (int index = start; index < end; ++index) {
                    ArrayList<QueryResult> list = new ArrayList<QueryResult>();
                    TextFragment frag = fragments.get(index);
                    if (!frag.hasText(false)) {
                        this.result = new QueryResult();
                        this.result.weight = this.getWeight();
                        this.result.source = frag;
                        this.result.target = frag.clone();
                        this.result.setFuzzyScore(95);
                        this.result.origin = this.getName();
                        this.result.matchType = MatchType.MT;
                        list.add(this.result);
                        allResults.add(list);
                        continue;
                    }
                    Map resp = (Map)translations.get(++transIndex);
                    String res = (String)resp.get("translatedText");
                    this.result = new QueryResult();
                    this.result.weight = this.getWeight();
                    this.result.source = frag;
                    this.result.target = frag.hasCode() ? new TextFragment(this.util.fromCodedHTML(res, frag, true), frag.getClonedCodes()) : new TextFragment(this.util.fromCodedHTML(res, frag, true));
                    this.result.setFuzzyScore(95);
                    this.result.origin = this.getName();
                    this.result.matchType = MatchType.MT;
                    list.add(this.result);
                    allResults.add(list);
                }
            } while (doAnotherQuery);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error querying the server.\n" + e.getMessage(), e);
        }
        return allResults;
    }

    @Override
    public void leverage(ITextUnit tu) {
        this.leverageUsingBatchQuery(tu);
    }

    @Override
    public void batchLeverage(List<ITextUnit> tuList) {
        this.batchLeverageUsingBatchQuery(tuList);
    }

    @Override
    protected String toInternalCode(LocaleId locale) {
        String code = locale.toBCP47();
        if (!code.startsWith("zh") && code.length() > 2) {
            code = code.substring(0, 2);
        }
        return code;
    }
}

