/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mif;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.IEncoder;
import net.sf.okapi.filters.mif.FrameRomanCharsetProvider;

public class MIFEncoder
implements IEncoder {
    private CharsetEncoder chsEnc;
    private CharBuffer tmpBuf = CharBuffer.allocate(1);
    private StringBuilder outBuf = new StringBuilder();
    private ByteBuffer encBuf;

    @Override
    public String encode(String text, int context) {
        StringBuilder escaped = new StringBuilder();
        block9: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (text.charAt(i)) {
                case '\t': {
                    escaped.append(this.tryCharStatment(ch));
                    continue block9;
                }
                case '>': {
                    escaped.append("\\>");
                    continue block9;
                }
                case '\'': {
                    escaped.append("\\q");
                    continue block9;
                }
                case '`': {
                    escaped.append("\\Q");
                    continue block9;
                }
                case '\\': {
                    escaped.append("\\\\");
                    continue block9;
                }
                default: {
                    if (ch > '\u007f') {
                        String res = this.tryCharStatment(ch);
                        if (res != null) {
                            escaped.append(res);
                            continue block9;
                        }
                        if (this.chsEnc == null) {
                            escaped.append(String.valueOf(ch));
                            continue block9;
                        }
                        this.tmpBuf.put(0, ch);
                        this.tmpBuf.position(0);
                        try {
                            this.encBuf = this.chsEnc.encode(this.tmpBuf);
                        }
                        catch (CharacterCodingException e) {
                            return "?";
                        }
                        if (this.encBuf.limit() > 1) {
                            for (int j = 0; j < this.encBuf.limit(); ++j) {
                                escaped.append(String.format("\\x%x ", this.encBuf.get(j)));
                            }
                            continue block9;
                        }
                        escaped.append(String.format("\\x%x ", this.encBuf.get(0)));
                        continue block9;
                    }
                    escaped.append(ch);
                }
            }
        }
        return escaped.toString();
    }

    @Override
    public String encode(char value, int context) {
        switch (value) {
            case '\t': {
                return this.tryCharStatment(value);
            }
            case '>': {
                return "\\>";
            }
            case '\'': {
                return "\\q";
            }
            case '`': {
                return "\\Q";
            }
            case '\\': {
                return "\\\\";
            }
        }
        if (value > '\u007f') {
            String res = this.tryCharStatment(value);
            if (res != null) {
                return res;
            }
            if (this.chsEnc == null) {
                return String.valueOf(value);
            }
            this.tmpBuf.put(0, value);
            this.tmpBuf.position(0);
            try {
                this.encBuf = this.chsEnc.encode(this.tmpBuf);
            }
            catch (CharacterCodingException e) {
                return "?";
            }
            if (this.encBuf.limit() > 1) {
                this.outBuf.setLength(0);
                for (int j = 0; j < this.encBuf.limit(); ++j) {
                    this.outBuf.append(String.format("\\x%x ", this.encBuf.get(j)));
                }
                return this.outBuf.toString();
            }
            return String.format("\\x%x ", this.encBuf.get(0));
        }
        return String.valueOf(value);
    }

    @Override
    public String encode(int value, int context) {
        switch (value) {
            case 9: {
                return this.tryCharStatment(value);
            }
            case 62: {
                return "\\>";
            }
            case 39: {
                return "\\q";
            }
            case 96: {
                return "\\Q";
            }
            case 92: {
                return "\\\\";
            }
        }
        if (value > 127) {
            String res = this.tryCharStatment(value);
            if (res != null) {
                return res;
            }
            if (this.chsEnc == null) {
                return String.valueOf((char)value);
            }
            this.tmpBuf.put(0, (char)value);
            this.tmpBuf.position(0);
            try {
                this.encBuf = this.chsEnc.encode(this.tmpBuf);
            }
            catch (CharacterCodingException e) {
                return "?";
            }
            if (this.encBuf.limit() > 1) {
                this.outBuf.setLength(0);
                for (int j = 0; j < this.encBuf.limit(); ++j) {
                    this.outBuf.append(String.format("\\x%x ", this.encBuf.get(j)));
                }
                return this.outBuf.toString();
            }
            return String.format("\\x%x ", this.encBuf.get(0));
        }
        return String.valueOf((char)value);
    }

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
        if (encoding == null) {
            return;
        }
        this.chsEnc = "utf-8".equalsIgnoreCase(encoding) || "utf-16".equalsIgnoreCase(encoding) ? null : (encoding.equals("x-FrameRoman") ? new FrameRomanCharsetProvider().charsetForName(encoding).newEncoder() : Charset.forName(encoding).newEncoder());
    }

    @Override
    public String toNative(String propertyName, String value) {
        return value;
    }

    @Override
    public String getLineBreak() {
        return "\n";
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        return this.chsEnc;
    }

    private String tryCharStatment(int value) {
        String token = "";
        switch (value) {
            case 9: {
                token = "Tab";
                break;
            }
            case 160: {
                token = "HardSpace";
                break;
            }
            case 8208: {
                token = "SoftHyphen";
                break;
            }
            case 8209: {
                token = "HardHyphen";
                break;
            }
            case 173: {
                token = "DiscHyphen";
                break;
            }
            case 8205: {
                token = "NoHyphen";
                break;
            }
            case 162: {
                token = "Cent";
                break;
            }
            case 163: {
                token = "Pound";
                break;
            }
            case 165: {
                token = "Yen";
                break;
            }
            case 8211: {
                token = "EnDash";
                break;
            }
            case 8212: {
                token = "EmDash";
                break;
            }
            case 8224: {
                token = "Dagger";
                break;
            }
            case 8225: {
                token = "DoubleDagger";
                break;
            }
            case 8226: {
                token = "Bullet";
                break;
            }
            case 10: {
                token = "HardReturn";
                break;
            }
            case 8199: {
                token = "NumberSpace";
                break;
            }
            case 8201: {
                token = "ThinSpace";
                break;
            }
            case 8194: {
                token = "EnSpace";
                break;
            }
            case 8195: {
                token = "EmSpace";
                break;
            }
            default: {
                return null;
            }
        }
        return "'><Char " + token + "><String `";
    }
}

