/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.po;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiIllegalFilterOperationException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.po.Parameters;
import net.sf.okapi.filters.po.Res;

@UsingParameters(value=Parameters.class)
public class POFilter
implements IFilter {
    public static final String PROPERTY_PLURALFORMS = "pluralforms";
    public static final String PROPERTY_REFERENCES = "references";
    public static final String PROPERTY_CONTEXT = "context";
    private static final String DOMAIN_SEP = "::";
    private static final String DOMAIN_NONE = "messages";
    private static final String DOMAIN_DEFAULT = "default";
    private static final String TMPMARKER = "\u001e";
    private static final int DEFAULT_NPLURALS = 2;
    private static final int PLURALFORMS_VALUEGROUP = 3;
    private static final Pattern pluralformsPattern = Pattern.compile("(plural-forms:)(\\s*)(.*?)(\\\\n|\\z)", 2);
    private static final int NPLURALS_VALUEGROUP = 4;
    private static final Pattern npluralsPattern = Pattern.compile("nplurals(\\s*)(=)(\\s*)(\\d*)(;|\\\\n|\\z)", 2);
    private static final int CHARSET_VALUEGROUP = 6;
    private static final Pattern charsetPattern = Pattern.compile("(content-type)(\\s*):(.*?)charset(\\s*)=(\\s*)(.*?)([\\\\|;|\\n])", 2);
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private Parameters params = new Parameters();
    private BufferedReader reader;
    private boolean canceled;
    private String encoding;
    private boolean autoDetected;
    private String textLine;
    private int tuId;
    private IdGenerator otherId;
    private String lineBreak;
    private int parseState = 0;
    private GenericSkeleton skel;
    private ITextUnit tu;
    private String docName;
    private LocaleId srcLang;
    private LocaleId trgLang;
    private boolean hasUTF8BOM;
    private int nPlurals;
    private int level;
    private int pluralMode;
    private int pluralCount;
    private boolean readLine;
    private int lineNumber;
    private String msgID;
    private String locNote;
    private String transNote;
    private String references;
    private String msgIDPlural;
    private String domain;
    private boolean hasFuzzyFlag;
    private EncoderManager encoderManager;
    private String msgContext;
    private String originalTuId;
    private GenericContent fmt;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
                this.docName = null;
            }
            this.parseState = 0;
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public String getName() {
        return "okf_po";
    }

    @Override
    public String getDisplayName() {
        return "PO Filter";
    }

    @Override
    public String getMimeType() {
        return "application/x-gettext";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "application/x-gettext", this.getClass().getName(), "PO (Standard)", "Standard bilingual PO files", null, ".po;"));
        list.add(new FilterConfiguration(this.getName() + "-monolingual", "application/x-gettext", this.getClass().getName(), "PO (Monolingual)", "Monolingual PO files (msgid is a real ID, not the source text).", "monolingual.fprm", ".po;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("application/x-gettext", "net.sf.okapi.common.encoder.POEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.parseState > 0;
    }

    @Override
    public Event next() {
        if (this.canceled) {
            this.parseState = 0;
            return new Event(EventType.CANCELED);
        }
        if (this.parseState == 1) {
            return this.start();
        }
        return this.readItem();
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.close();
        this.parseState = 1;
        this.canceled = false;
        this.nPlurals = 2;
        this.tuId = 0;
        this.otherId = new IdGenerator(null, "o");
        this.pluralMode = 0;
        this.pluralCount = 0;
        this.readLine = true;
        this.msgIDPlural = "";
        this.level = 0;
        this.lineNumber = 0;
        this.domain = DOMAIN_NONE;
        if (this.params.getUseCodeFinder()) {
            this.params.getCodeFinder().compile();
        }
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        detector.detectAndRemoveBom();
        input.setEncoding(detector.getEncoding());
        this.encoding = input.getEncoding();
        try {
            this.reader = new BufferedReader(new InputStreamReader(detector.getInputStream(), input.getEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiUnsupportedEncodingException(this.msg(String.format("The encoding '%s' is not supported.", this.encoding)), e);
        }
        this.srcLang = input.getSourceLocale();
        this.trgLang = input.getTargetLocale();
        this.hasUTF8BOM = detector.hasUtf8Bom();
        this.lineBreak = detector.getNewlineType().toString();
        if (input.getInputURI() != null) {
            this.docName = input.getInputURI().getPath();
        }
        if (this.detectInformation()) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new OkapiIOException("Error re-opening the input.", e);
            }
            input.setEncoding(this.encoding);
            this.reader = new BufferedReader(input.getReader());
        }
    }

    private Event start() {
        this.parseState = 2;
        StartDocument startDoc = new StartDocument(this.otherId.createId());
        startDoc.setName(this.docName);
        startDoc.setEncoding(this.encoding, this.hasUTF8BOM);
        startDoc.setLocale(this.srcLang);
        startDoc.setFilterParameters(this.params);
        startDoc.setFilterWriter(this.createFilterWriter());
        startDoc.setLineBreak(this.lineBreak);
        startDoc.setType("application/x-gettext");
        startDoc.setMimeType(this.getMimeType());
        startDoc.setMultilingual(this.params.getBilingualMode());
        return new Event(EventType.START_DOCUMENT, startDoc);
    }

    private Event readItem() {
        this.skel = new GenericSkeleton();
        this.tu = null;
        this.originalTuId = null;
        if (this.pluralMode == 0) {
            this.msgID = "";
            this.locNote = "";
            this.transNote = "";
            this.references = "";
            this.hasFuzzyFlag = false;
            this.msgContext = "";
        } else {
            if (this.pluralMode == 2) {
                this.hasFuzzyFlag = false;
                this.pluralMode = 0;
                this.msgIDPlural = "";
                this.pluralCount = 0;
                --this.level;
                Ending ending = new Ending(this.otherId.createId());
                ending.setSkeleton(this.skel);
                return new Event(EventType.END_GROUP, ending);
            }
            if (this.pluralMode == 1 && this.hasFuzzyFlag) {
                this.tu = new TextUnit(null);
                this.tu.setTargetProperty(this.trgLang, new Property("approved", "no", false));
            }
        }
        while (true) {
            if (this.readLine) {
                try {
                    this.textLine = this.reader.readLine();
                    ++this.lineNumber;
                }
                catch (IOException e) {
                    throw new OkapiIOException(e);
                }
                if (this.textLine == null) {
                    if (this.level > 0) {
                        --this.level;
                        Ending ending = new Ending(this.otherId.createId());
                        ending.setSkeleton(this.skel);
                        return new Event(EventType.END_GROUP, ending);
                    }
                    Ending ending = new Ending("ed");
                    ending.setSkeleton(this.skel);
                    this.close();
                    return new Event(EventType.END_DOCUMENT, ending);
                }
            } else {
                this.readLine = true;
            }
            if (this.textLine.trim().length() == 0) {
                this.skel.append(this.textLine + this.lineBreak);
                continue;
            }
            if (this.textLine.startsWith("#.")) {
                this.skel.append(this.textLine + this.lineBreak);
                if (this.locNote.length() > 0) {
                    this.locNote = this.locNote + this.lineBreak;
                }
                this.locNote = this.locNote + this.textLine.substring(2).trim();
                continue;
            }
            if (this.textLine.startsWith("#:")) {
                this.skel.append(this.textLine + this.lineBreak);
                if (this.references.length() > 0) {
                    this.references = this.references + this.lineBreak;
                }
                this.references = this.references + this.textLine.substring(2).trim();
                continue;
            }
            if (this.textLine.startsWith("#~")) {
                this.skel.append(this.textLine + this.lineBreak);
                continue;
            }
            if (this.textLine.startsWith("# ") || this.textLine.startsWith("#\t")) {
                this.skel.append(this.textLine + this.lineBreak);
                if (this.transNote.length() > 0) {
                    this.transNote = this.transNote + this.lineBreak;
                }
                this.transNote = this.transNote + this.textLine.substring(2).trim();
                continue;
            }
            if (this.textLine.startsWith("msgctxt")) {
                this.msgContext = this.getQuotedString(true);
                this.parseCrumbs(this.msgContext);
                continue;
            }
            if (this.textLine.startsWith("#,")) {
                if (this.tu == null) {
                    this.tu = new TextUnit(null);
                }
                int pos = this.textLine.indexOf("fuzzy");
                if (this.params.getBilingualMode() && pos > -1) {
                    this.skel.append(this.textLine.substring(0, pos));
                    this.skel.addValuePlaceholder(this.tu, "approved", this.trgLang);
                    this.tu.setTargetProperty(this.trgLang, new Property("approved", "no", false));
                    this.hasFuzzyFlag = true;
                    this.skel.append(this.textLine.substring(pos + 5));
                } else {
                    this.skel.append(this.textLine);
                }
                this.skel.append(this.lineBreak);
                continue;
            }
            if (this.textLine.startsWith("domain")) {
                if (this.level > 0) {
                    this.readLine = false;
                    --this.level;
                    this.domain = DOMAIN_NONE;
                    Ending ending = new Ending(this.otherId.createId());
                    ending.setSkeleton(this.skel);
                    return new Event(EventType.END_GROUP, ending);
                }
                this.skel.append(this.textLine);
                StartGroup startGroup = new StartGroup(null, this.otherId.createId());
                startGroup.setSkeleton(this.skel);
                this.skel.append(this.lineBreak);
                startGroup.setType("x-gettext-domain");
                this.setDomainName(startGroup);
                ++this.level;
                return new Event(EventType.START_GROUP, startGroup);
            }
            if (this.textLine.startsWith("msgid_plural")) {
                this.pluralMode = 1;
                this.msgIDPlural = this.getQuotedString(true);
                StartGroup startGroup = new StartGroup(null, this.otherId.createId());
                if (this.tu != null) {
                    Property prop = this.tu.getTargetProperty(this.trgLang, "approved");
                    if (prop != null) {
                        startGroup.setTargetProperty(this.trgLang, prop);
                    }
                    this.skel.changeSelfReferents(startGroup);
                }
                startGroup.setSkeleton(this.skel);
                ++this.level;
                startGroup.setType("x-gettext-plurals");
                startGroup.setMimeType(this.getMimeType());
                return new Event(EventType.START_GROUP, startGroup);
            }
            if (this.textLine.startsWith("msgid")) {
                this.msgID = this.getQuotedString(true);
                continue;
            }
            if (this.textLine.indexOf("msgstr") == 0) {
                Event event = this.processMsgStr();
                if (event == null) continue;
                return event;
            }
            this.skel.append(this.textLine + this.lineBreak);
        }
    }

    private void parseCrumbs(String text) {
        if (!text.startsWith("okpCtx")) {
            return;
        }
        int n = text.indexOf("tu=");
        if (n == -1) {
            return;
        }
        this.originalTuId = text.substring(n + "tu=".length()).trim();
        if (this.originalTuId.isEmpty()) {
            this.originalTuId = null;
        }
    }

    private Event processMsgStr() {
        StringBuilder tmp;
        boolean trgIsEmpty;
        block31: {
            block30: {
                if (this.textLine.indexOf("msgstr[") != 0) break block30;
                if (this.pluralMode == 0) {
                    throw new OkapiIllegalFilterOperationException(this.msg(Res.getString("extraPluralMsgStr")));
                }
                ++this.pluralCount;
                switch (this.nPlurals) {
                    case 1: 
                    case 2: {
                        if (this.pluralCount == 2) {
                            this.pluralMode = 2;
                            break;
                        }
                        break block31;
                    }
                    default: {
                        if (this.pluralCount == this.nPlurals) {
                            this.pluralMode = 2;
                            break;
                        }
                        break block31;
                    }
                }
                break block31;
            }
            if (this.pluralMode != 0) {
                throw new OkapiIllegalFilterOperationException(this.msg(Res.getString("missingPluralMsgStr")));
            }
        }
        boolean bl = trgIsEmpty = (tmp = new StringBuilder(this.getQuotedString(false))).length() == 0;
        if (this.msgID.length() == 0) {
            int n1;
            String id = this.otherId.createId();
            DocumentPart dp = new DocumentPart(id, false, this.skel);
            dp.setMimeType(this.getMimeType());
            tmp.insert(0, "\"" + this.lineBreak + "\"");
            tmp.append("\"" + this.lineBreak);
            Matcher m = charsetPattern.matcher(tmp.toString());
            if (m.find()) {
                tmp.replace(m.start(6), m.end(6), "\u001eencoding=" + this.encoding + TMPMARKER);
            }
            if ((m = pluralformsPattern.matcher(tmp.toString())).find()) {
                tmp.replace(m.start(3), m.end(3), "\u001epluralforms=" + m.group(3) + TMPMARKER);
            }
            int start = 0;
            while ((n1 = tmp.indexOf(TMPMARKER, start)) > -1) {
                int n2 = tmp.indexOf(TMPMARKER, n1 + 1);
                this.skel.append(tmp.substring(start, n1).replace("\\n", "\\n\"" + this.lineBreak + "\""));
                String data = tmp.substring(n1 + 1, n2);
                int mid = data.indexOf(61);
                Property prop = new Property(data.substring(0, mid), data.substring(mid + 1), false);
                dp.setProperty(prop);
                this.skel.addValuePlaceholder(dp, prop.getName(), LocaleId.EMPTY);
                start = n2 + 1;
            }
            String end = tmp.substring(start).replace("\\n", "\\n\"" + this.lineBreak + "\"");
            if (end.endsWith("\"\"" + this.lineBreak)) {
                end = end.substring(0, end.length() - (2 + this.lineBreak.length()));
            }
            this.skel.append(end);
            return new Event(EventType.DOCUMENT_PART, dp);
        }
        if (this.tu == null) {
            this.tu = new TextUnit(null);
        }
        this.tu.setId(this.originalTuId != null ? this.originalTuId : String.valueOf(++this.tuId));
        this.tu.setPreserveWhitespaces(true);
        this.tu.setSkeleton(this.skel);
        this.tu.setMimeType(this.getMimeType());
        if (this.locNote.length() > 0) {
            this.tu.setProperty(new Property("note", this.locNote));
        }
        if (this.transNote.length() > 0) {
            this.tu.setProperty(new Property("transNote", this.transNote));
        }
        if (this.references.length() > 0) {
            this.tu.setProperty(new Property(PROPERTY_REFERENCES, this.references));
        }
        if (!Util.isEmpty(this.msgContext)) {
            this.tu.setProperty(new Property(PROPERTY_CONTEXT, this.msgContext));
        }
        if (this.params.getBilingualMode()) {
            String sID = this.msgID;
            if (this.pluralMode != 0 && this.pluralCount - 1 > 0) {
                sID = this.msgIDPlural;
            }
            this.toAbstract(this.tu.setSourceContent(new TextFragment(sID)));
            if (this.params.getMakeID()) {
                String base = this.domain + DOMAIN_SEP + this.msgContext + this.msgID;
                if (this.pluralMode == 0) {
                    this.tu.setName(Util.makeId(base));
                } else {
                    this.tu.setName(Util.makeId(base) + String.format("-%d", this.pluralCount - 1));
                }
            }
            if (tmp.length() > 0) {
                TextContainer tc = this.tu.createTarget(this.trgLang, false, 0);
                tc.setContent(this.toAbstract(new TextFragment(tmp.toString())));
                if (!this.hasFuzzyFlag) {
                    this.tu.setTargetProperty(this.trgLang, new Property("approved", "yes", true));
                }
                TextFragment tf = tc.getFirstContent();
                tf.alignCodeIds(this.tu.getSource().getFirstContent());
            }
        } else {
            if (this.pluralMode == 0) {
                this.tu.setName(this.domain + DOMAIN_SEP + this.msgID);
            } else {
                this.tu.setName(this.domain + DOMAIN_SEP + this.msgID + String.format("-%d", this.pluralCount - 1));
            }
            this.toAbstract(this.tu.setSourceContent(new TextFragment(tmp.toString())));
        }
        if (this.pluralMode != 0 && this.nPlurals == 1 && this.pluralCount - 1 > 0) {
            this.tu.setIsTranslatable(false);
        } else if (!this.hasFuzzyFlag && this.params.getProtectApproved()) {
            this.tu.setIsTranslatable(trgIsEmpty);
        }
        this.skel.addContentPlaceholder(this.tu, this.trgLang);
        this.skel.append("\"" + this.lineBreak);
        return new Event(EventType.TEXT_UNIT, this.tu);
    }

    private String getQuotedString(boolean addLinebreak) {
        StringBuilder sbTmp = new StringBuilder();
        boolean quotedTextStarted = false;
        try {
            int nPos2;
            int nPos1 = this.textLine.indexOf(34);
            if (nPos1 > -1) {
                quotedTextStarted = true;
                nPos2 = this.textLine.lastIndexOf(34);
                if (nPos2 == -1 || nPos2 == nPos1) {
                    throw new Exception(this.msg(Res.getString("missingEndQuote")));
                }
                if (addLinebreak) {
                    this.skel.append(this.textLine + this.lineBreak);
                } else {
                    this.skel.append(this.textLine.substring(0, nPos1 + 1));
                }
                sbTmp.append(this.textLine.substring(nPos1 + 1, nPos2));
            } else {
                this.skel.append(this.textLine.trim() + " \"\"" + this.lineBreak);
                if (!addLinebreak) {
                    this.skel.append("\"");
                }
            }
            while (true) {
                this.textLine = this.reader.readLine();
                ++this.lineNumber;
                if (this.textLine == null) {
                    if (!quotedTextStarted) {
                        throw new Exception(this.msg(Res.getString("missingStartQuote")));
                    }
                    return sbTmp.toString();
                }
                String sTmp = this.textLine.trim();
                if (!sTmp.startsWith("\"")) break;
                quotedTextStarted = true;
                nPos1 = this.textLine.indexOf(34);
                if (nPos1 == -1) {
                    throw new Exception(this.msg(Res.getString("missingStartQuote")));
                }
                nPos2 = this.textLine.lastIndexOf(34);
                if (nPos2 == -1 || nPos2 == nPos1) {
                    throw new Exception(this.msg(Res.getString("missingEndQuote")));
                }
                if (addLinebreak) {
                    this.skel.append(this.textLine + this.lineBreak);
                }
                sbTmp.append(this.textLine.substring(nPos1 + 1, nPos2));
            }
            if (!quotedTextStarted) {
                throw new Exception(this.msg(Res.getString("missingStartQuote")));
            }
            this.readLine = false;
            return sbTmp.toString();
        }
        catch (Throwable e) {
            throw new OkapiIllegalFilterOperationException(Res.getString("problemWithQuotes") + "\n" + e.getMessage());
        }
    }

    private TextFragment toAbstract(TextFragment frag) {
        if (this.originalTuId != null) {
            if (this.fmt == null) {
                this.fmt = new GenericContent();
            }
            this.fmt.fromLetterCodedToFragment(frag.getCodedText(), frag, false);
        } else if (this.params.getUseCodeFinder()) {
            this.params.getCodeFinder().process(frag);
        }
        return frag;
    }

    private void setDomainName(INameable res) {
        String[] aTokens = this.textLine.split("\\s");
        if (aTokens.length < 2) {
            this.domain = DOMAIN_DEFAULT;
        } else {
            this.domain = aTokens[1];
            res.setName(this.domain);
        }
    }

    private boolean detectInformation() {
        char[] buffer;
        try {
            this.reader.mark(1024);
            buffer = new char[1024];
            this.reader.read(buffer, 0, 1024);
            this.reader.reset();
            String tmp = new String(buffer);
            Matcher m = pluralformsPattern.matcher(tmp);
            if (m.find()) {
                String data = m.group(3);
                if ((m = npluralsPattern.matcher(data)).find()) {
                    try {
                        this.nPlurals = Integer.valueOf(m.group(4));
                    }
                    catch (NumberFormatException e) {
                        this.nPlurals = 2;
                    }
                    if (this.nPlurals < 0) {
                        this.nPlurals = 2;
                        this.logger.warning(String.format(Res.getString("npluralsInvalid"), data, this.nPlurals));
                    }
                } else {
                    this.nPlurals = 2;
                    this.logger.warning(String.format(Res.getString("npluralsNotDetected"), data, this.nPlurals));
                }
            }
            if ((m = charsetPattern.matcher(tmp)).find()) {
                if (m.group(6).equalsIgnoreCase("charset")) {
                    boolean bl = false;
                    return bl;
                }
                if (this.autoDetected) {
                    if (!this.encoding.equalsIgnoreCase(m.group(6))) {
                        // empty if block
                    }
                } else if (!this.encoding.equalsIgnoreCase(m.group(6))) {
                    this.encoding = m.group(6);
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        finally {
            buffer = null;
        }
    }

    private String msg(String text) {
        return String.format(Res.getString("lineNumber"), this.lineNumber) + text;
    }
}

