/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.regex;

import java.util.ArrayList;
import java.util.regex.Pattern;
import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.filters.LocalizationDirectives;
import net.sf.okapi.filters.regex.Rule;

public class Parameters
extends BaseParameters {
    private static final String EXTRACTOUTERSTRINGS = "extractOuterStrings";
    private static final String STARTSTRING = "startString";
    private static final String ENDSTRING = "endString";
    private static final String USEBSLASHESCAPE = "useBSlashEscape";
    private static final String USEDOUBLECHARESCAPE = "useDoubleCharEscape";
    private static final String ONELEVELGROUP = "oneLevelGroups";
    private static final String USELD = "useLd";
    private static final String LOCALIZEOUTSIDE = "localizeOutside";
    private static final String REGEXOPTIONS = "regexOptions";
    private static final String MIMETYPE = "mimeType";
    private boolean extractOuterStrings;
    private String startString;
    private String endString;
    private boolean useBSlashEscape;
    private boolean useDoubleCharEscape;
    private int regexOptions;
    private LocalizationDirectives localizationDirectives = new LocalizationDirectives();
    private String mimeType;
    private boolean oneLevelGroups;
    private ArrayList<Rule> rules;

    public Parameters() {
        this.reset();
        this.toString();
    }

    @Override
    public void reset() {
        this.rules = new ArrayList();
        this.regexOptions = 40;
        this.startString = "\"";
        this.endString = "\"";
        this.extractOuterStrings = false;
        this.useBSlashEscape = true;
        this.useDoubleCharEscape = false;
        this.localizationDirectives.reset();
        this.mimeType = "text/plain";
        this.oneLevelGroups = false;
    }

    public boolean getExtractOuterStrings() {
        return this.extractOuterStrings;
    }

    public void setExtractOuterStrings(boolean extractOuterStrings) {
        this.extractOuterStrings = extractOuterStrings;
    }

    public String getStartString() {
        return this.startString;
    }

    public void setStartString(String startString) {
        this.startString = startString;
    }

    public String getEndString() {
        return this.endString;
    }

    public void setEndString(String endString) {
        this.endString = endString;
    }

    public boolean getUseBSlashEscape() {
        return this.useBSlashEscape;
    }

    public void setUseBSlashEscape(boolean useBSlashEscape) {
        this.useBSlashEscape = useBSlashEscape;
    }

    public boolean getUseDoubleCharEscape() {
        return this.useDoubleCharEscape;
    }

    public void setUseDoubleCharEscape(boolean useDoubleCharEscape) {
        this.useDoubleCharEscape = useDoubleCharEscape;
    }

    public int getRegexOptions() {
        return this.regexOptions;
    }

    public void setRegexOptions(int regexOptions) {
        this.regexOptions = regexOptions;
    }

    public LocalizationDirectives getLocalizationDirectives() {
        return this.localizationDirectives;
    }

    public void setLocalizationDirectives(LocalizationDirectives localizationDirectives) {
        this.localizationDirectives = localizationDirectives;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public boolean getOneLevelGroups() {
        return this.oneLevelGroups;
    }

    public void setOneLevelGroups(boolean oneLevelGroups) {
        this.oneLevelGroups = oneLevelGroups;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        boolean tmpBool1 = this.buffer.getBoolean(USELD, this.localizationDirectives.useLD());
        boolean tmpBool2 = this.buffer.getBoolean(LOCALIZEOUTSIDE, this.localizationDirectives.localizeOutside());
        this.localizationDirectives.setOptions(tmpBool1, tmpBool2);
        this.startString = this.buffer.getString(STARTSTRING, this.startString);
        this.endString = this.buffer.getString(ENDSTRING, this.endString);
        this.extractOuterStrings = this.buffer.getBoolean(EXTRACTOUTERSTRINGS, this.extractOuterStrings);
        this.useBSlashEscape = this.buffer.getBoolean(USEBSLASHESCAPE, this.useBSlashEscape);
        this.useDoubleCharEscape = this.buffer.getBoolean(USEDOUBLECHARESCAPE, this.useDoubleCharEscape);
        this.oneLevelGroups = this.buffer.getBoolean(ONELEVELGROUP, this.oneLevelGroups);
        this.regexOptions = this.buffer.getInteger(REGEXOPTIONS, this.regexOptions);
        this.mimeType = this.buffer.getString(MIMETYPE, this.mimeType);
        int count = this.buffer.getInteger("ruleCount", 0);
        for (int i = 0; i < count; ++i) {
            Rule rule = new Rule();
            rule.fromString(this.buffer.getGroup(String.format("rule%d", i), null));
            this.rules.add(rule);
        }
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(USELD, this.localizationDirectives.useLD());
        this.buffer.setBoolean(LOCALIZEOUTSIDE, this.localizationDirectives.localizeOutside());
        this.buffer.setString(STARTSTRING, this.startString);
        this.buffer.setString(ENDSTRING, this.endString);
        this.buffer.setBoolean(EXTRACTOUTERSTRINGS, this.extractOuterStrings);
        this.buffer.setBoolean(USEBSLASHESCAPE, this.useBSlashEscape);
        this.buffer.setBoolean(USEDOUBLECHARESCAPE, this.useDoubleCharEscape);
        this.buffer.setBoolean(ONELEVELGROUP, this.oneLevelGroups);
        this.buffer.setInteger(REGEXOPTIONS, this.regexOptions);
        this.buffer.setString(MIMETYPE, this.mimeType);
        this.buffer.setInteger("ruleCount", this.rules.size());
        for (int i = 0; i < this.rules.size(); ++i) {
            this.buffer.setGroup(String.format("rule%d", i), this.rules.get(i).toString());
        }
        return this.buffer.toString();
    }

    public void compileRules() {
        for (Rule rule : this.rules) {
            rule.pattern = Pattern.compile(rule.expr, this.regexOptions);
            if (!rule.useCodeFinder) continue;
            rule.codeFinder.compile();
        }
    }

    public ArrayList<Rule> getRules() {
        return this.rules;
    }
}

