/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.txml;

import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.filters.txml.TXMLSegAnnotation;

public class TXMLSkeletonWriter
extends GenericSkeletonWriter {
    private boolean allowEmptyOutputTarget;

    public TXMLSkeletonWriter(boolean allowEmptyOutputTarget) {
        this.allowEmptyOutputTarget = allowEmptyOutputTarget;
    }

    @Override
    public String processTextUnit(ITextUnit tu) {
        if (tu == null) {
            return "";
        }
        if (this.encoderManager != null) {
            this.encoderManager.updateEncoder(tu.getMimeType());
        }
        StringBuilder tmp = new StringBuilder();
        GenericSkeleton skel = (GenericSkeleton)tu.getSkeleton();
        tmp.append(this.getString(skel.getParts().get(0), 1));
        TextContainer srcCont = tu.getSource();
        this.ensureTxmlPattern(srcCont);
        TextContainer trgCont = null;
        if (tu.hasTarget(this.outputLoc)) {
            trgCont = tu.getTarget(this.outputLoc);
            this.ensureTxmlPattern(srcCont);
        } else if (!this.allowEmptyOutputTarget) {
            trgCont = srcCont;
        }
        for (int i = 0; i < srcCont.count(); ++i) {
            TextPart part = srcCont.get(i);
            if (!part.isSegment()) continue;
            Segment srcSeg = (Segment)part;
            TXMLSegAnnotation segAnn = srcSeg.getAnnotation(TXMLSegAnnotation.class);
            AltTranslation altTrans = null;
            Segment trgSeg = null;
            if (trgCont != null) {
                AltTranslationsAnnotation ann;
                trgSeg = trgCont.getSegments().get(srcSeg.id);
                if (trgSeg == null && !this.allowEmptyOutputTarget) {
                    trgSeg = srcSeg;
                }
                if (trgSeg != null && (ann = trgSeg.getAnnotation(AltTranslationsAnnotation.class)) != null) {
                    altTrans = ann.getFirst();
                }
            }
            tmp.append("<segment segmentId=\"" + srcSeg.getId() + "\"");
            boolean gtmt = false;
            if (altTrans != null) {
                gtmt = altTrans.getFromOriginal();
            }
            tmp.append(" gtmt=\"" + (gtmt ? "true" : "false") + "\"");
            tmp.append(">");
            if (i > 0 && !(part = srcCont.get(i - 1)).isSegment() && (segAnn == null && i == 1 || segAnn != null && segAnn.hasWSBefore())) {
                tmp.append("<ws>");
                tmp.append(this.processFragment(part.getContent(), 1));
                tmp.append("</ws>");
            }
            tmp.append("<source>");
            tmp.append(this.processFragment(srcSeg.getContent(), 1));
            tmp.append("</source>");
            if (i + 1 < srcCont.count() && !(part = srcCont.get(i + 1)).isSegment()) {
                if (segAnn == null || segAnn != null && segAnn.hasWSAfter()) {
                    tmp.append("<ws>");
                    tmp.append(this.processFragment(part.getContent(), 1));
                    tmp.append("</ws>");
                }
                ++i;
            }
            if (trgSeg != null) {
                tmp.append("<target>");
                tmp.append(this.processFragment(trgSeg.getContent(), 0));
                tmp.append("</target>");
            }
            tmp.append("</segment>");
        }
        tmp.append(this.getString(skel.getParts().get(2), 1));
        return tmp.toString();
    }

    private int fetchNextSegmentIndex(TextContainer tc, int fromIndex) {
        for (int i = fromIndex; i < tc.count(); ++i) {
            TextPart part = tc.get(i);
            if (!part.isSegment()) continue;
            return i;
        }
        return -1;
    }

    protected void ensureTxmlPattern(TextContainer tc) {
        int i = 0;
        while (i < tc.count()) {
            if (tc.get(i).isSegment()) {
                ++i;
                continue;
            }
            int nextSegIndex = this.fetchNextSegmentIndex(tc, i);
            int diff = nextSegIndex == -1 ? tc.count() - i - 1 : (i == 0 ? nextSegIndex - i - 1 : nextSegIndex - i - 2);
            if (diff > 0) {
                tc.joinWithNext(i, diff);
            }
            ++i;
        }
    }

    protected String processFragment(TextFragment frag, int context) {
        StringBuilder tmp = new StringBuilder();
        String text = frag.getCodedText();
        block3: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    tmp.append(this.expandCode(frag.getCode(text.charAt(++i)), context));
                    continue block3;
                }
                default: {
                    tmp.append(this.encoderManager.encode(ch, context));
                    continue block3;
                }
            }
        }
        return tmp.toString();
    }

    private String expandCode(Code code, int context) {
        if (this.layer != null) {
            if (context == 0) {
                return this.layer.startInline() + this.layer.encode(code.getOuterData(), 2) + this.layer.endInline();
            }
            return this.layer.encode(code.getOuterData(), 1);
        }
        return code.getOuterData();
    }
}

