/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.vignette;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    static final String PARTSCONFIGURATIONS = "partsConfigurations";
    static final String PARTSNAMES = "partsNames";
    static final String SOURCEID = "sourceId";
    static final String LOCALEID = "localeId";
    static final String QUOTEMODEDEFINED = "quoteModeDefined";
    static final String QUOTEMODE = "quoteMode";
    static final String MONOLINGUAL = "monolingual";
    private String partsConfigurations;
    private String partsNames;
    private String sourceId;
    private String localeId;
    private boolean monolingual;

    public String getPartsNames() {
        return this.partsNames;
    }

    public String[] getPartsNamesAsList() {
        return ListUtil.stringAsArray(this.partsNames);
    }

    public void setPartsNames(String partsNames) {
        this.partsNames = partsNames;
    }

    public String getPartsConfigurations() {
        return this.partsConfigurations;
    }

    public String[] getPartsConfigurationsAsList() {
        return ListUtil.stringAsArray(this.partsConfigurations);
    }

    public void setPartsConfigurations(String partsConfigurations) {
        this.partsConfigurations = partsConfigurations;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getLocaleId() {
        return this.localeId;
    }

    public void setLocaleId(String localeId) {
        this.localeId = localeId;
    }

    public boolean getMonolingual() {
        return this.monolingual;
    }

    public void setMonolingual(boolean monolingual) {
        this.monolingual = monolingual;
    }

    public boolean checkData() {
        String[] tmp1 = ListUtil.stringAsArray(this.partsNames);
        String[] tmp2 = ListUtil.stringAsArray(this.partsConfigurations);
        return tmp1.length > 0 && tmp1.length == tmp2.length;
    }

    public Parameters() {
        this.reset();
        this.toString();
    }

    @Override
    public void reset() {
        this.partsNames = "SMCCONTENT-TITLE, SMCCONTENT-ABSTRACT, SMCCONTENT-BODY, SMCCONTENT-ALT, SMCCHANNELDESCRIPTOR-TITLE, SMCCHANNELDESCRIPTOR-ABSTRACT, SMCCHANNELDESCRIPTOR-ALT, SMCLINKCOLLECTIONS-LINKCOLLECTION-TITLE, SMCLINKCOLLECTIONS-LINKCOLLECTION-DESCRIPTION, SMCLINKS-TITLE, SMCLINKS-ABSTRACT, SMCLINKS-BODY, SMCLINKS-ALT";
        this.partsConfigurations = "default, okf_html, okf_html, default, default, okf_html, default, default, okf_html, default, okf_html, okf_html, default";
        this.sourceId = "SOURCE_ID";
        this.localeId = "LOCALE_ID";
        this.monolingual = false;
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString(PARTSNAMES, this.partsNames);
        this.buffer.setString(PARTSCONFIGURATIONS, this.partsConfigurations);
        this.buffer.setString(SOURCEID, this.sourceId);
        this.buffer.setString(LOCALEID, this.localeId);
        this.buffer.setBoolean(MONOLINGUAL, this.monolingual);
        this.buffer.setBoolean(QUOTEMODEDEFINED, true);
        this.buffer.setInteger(QUOTEMODE, 0);
        return this.buffer.toString();
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.partsNames = this.buffer.getString(PARTSNAMES, this.partsNames);
        this.partsConfigurations = this.buffer.getString(PARTSCONFIGURATIONS, this.partsConfigurations);
        this.sourceId = this.buffer.getString(SOURCEID, this.sourceId);
        this.localeId = this.buffer.getString(LOCALEID, this.localeId);
        this.monolingual = this.buffer.getBoolean(MONOLINGUAL, this.monolingual);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(PARTSNAMES, "Names of the <attribute> elements to extract", "Comma-separated list of the names of the <attribute> elements to extract.");
        desc.add(PARTSCONFIGURATIONS, "Corresponding filter configurations (or 'default')", "Comma-separated list of the filter configurations to use, use 'default' for none");
        desc.add(MONOLINGUAL, "Monolingual mode", null);
        desc.add(SOURCEID, "Name for source ID element", "Name of the <attribute> element containing the source ID");
        desc.add(LOCALEID, "Name for locale ID element", "Name of the <attribute> element containing the locale ID");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Vignette Filter Parameters", true, false);
        TextInputPart tip = desc.addTextInputPart(paramDesc.get(PARTSNAMES));
        tip.setHeight(60);
        tip = desc.addTextInputPart(paramDesc.get(PARTSCONFIGURATIONS));
        tip.setHeight(60);
        CheckboxPart mono = desc.addCheckboxPart(paramDesc.get(MONOLINGUAL));
        tip = desc.addTextInputPart(paramDesc.get(SOURCEID));
        tip.setVertical(false);
        tip.setMasterPart(mono, false);
        tip = desc.addTextInputPart(paramDesc.get(LOCALEID));
        tip.setVertical(false);
        tip.setMasterPart(mono, false);
        return desc;
    }
}

