/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xini.rainbowkit;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.filters.xini.InlineCodeTransformer;
import net.sf.okapi.filters.xini.jaxb.Element;
import net.sf.okapi.filters.xini.jaxb.Field;
import net.sf.okapi.filters.xini.jaxb.Fields;
import net.sf.okapi.filters.xini.jaxb.Main;
import net.sf.okapi.filters.xini.jaxb.ObjectFactory;
import net.sf.okapi.filters.xini.jaxb.Page;
import net.sf.okapi.filters.xini.jaxb.Seg;
import net.sf.okapi.filters.xini.jaxb.Trans;
import net.sf.okapi.filters.xini.jaxb.Xini;

public class FilterEventToXiniTransformer {
    private static final Pattern ALL_WHITESPACE_PATTERN = Pattern.compile("[\\s\\u0009\\u000A\\u000B\\u000C\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000]+");
    private static ObjectFactory objectFactory = new ObjectFactory();
    private Marshaller m;
    private JAXBContext jc;
    private InlineCodeTransformer transformer;
    private Xini xini;
    private Main main;
    private Page currentPage;
    private int currentPageId;
    private int currentElementId;
    private int currentFieldId;

    public void init() {
        this.transformer = new InlineCodeTransformer();
        try {
            this.jc = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            this.m = this.jc.createMarshaller();
            this.m.setProperty("jaxb.noNamespaceSchemaLocation", (Object)"http://www.ontram.com/xsd/xini.xsd");
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        this.currentPageId = 0;
        this.currentElementId = 10;
        this.currentFieldId = 0;
        this.xini = objectFactory.createXini();
        this.xini.setSchemaVersion("1.0");
        this.main = objectFactory.createMain();
        this.xini.setMain(this.main);
    }

    public void startPage(String name) {
        this.currentPage = new Page();
        ++this.currentPageId;
        this.currentElementId = 10;
        this.currentFieldId = 0;
        this.currentPage.setPageID(this.currentPageId);
        this.currentPage.setPageName(name);
        this.currentPage.setElements(new Page.Elements());
        this.xini.getMain().getPage().add(this.currentPage);
    }

    public void transformTextUnit(ITextUnit tu) {
        TextContainer textContainer = tu.getSource();
        if (!tu.isTranslatable()) {
            return;
        }
        Field field = this.prepareXiniStructure(tu);
        int currentSegmentId = 0;
        StringBuilder emptySegsFlags = new StringBuilder();
        Seg xiniSegment = null;
        String whitespaces = null;
        for (TextPart part : textContainer) {
            if (part.isSegment()) {
                Segment okapiSegment = (Segment)part;
                TextFragment textFragment = okapiSegment.getContent();
                if (!FilterEventToXiniTransformer.textFragmentIsEmpty(textFragment)) {
                    xiniSegment = objectFactory.createSeg();
                    xiniSegment.setSegID(currentSegmentId);
                    field.getSegAndTrans().add(xiniSegment);
                    List<Code> codes = textFragment.getCodes();
                    if (codes.size() > 0) {
                        xiniSegment.getContent().addAll(this.transformer.codesToJAXBForTKit(textFragment.getCodedText(), codes));
                    } else {
                        xiniSegment.getContent().add((Serializable)((Object)textFragment.getText()));
                    }
                    emptySegsFlags.append("0");
                } else if (FilterEventToXiniTransformer.containsOnlyWhitespace(textFragment.getCodedText())) {
                    xiniSegment = objectFactory.createSeg();
                    xiniSegment.setSegID(currentSegmentId);
                    field.getSegAndTrans().add(xiniSegment);
                    xiniSegment.setEmptyTranslation(true);
                    xiniSegment.setTrailingSpacer(textFragment.getText());
                    emptySegsFlags.append("0");
                } else {
                    emptySegsFlags.append("1");
                }
                if (whitespaces != null && xiniSegment != null) {
                    xiniSegment.setLeadingSpacer(whitespaces);
                    whitespaces = null;
                }
                this.addTransElements(tu, field, currentSegmentId, okapiSegment);
                ++currentSegmentId;
                continue;
            }
            String whitespacePart = part.getContent().getText();
            if (xiniSegment == null) {
                whitespaces = whitespacePart;
                continue;
            }
            xiniSegment.setTrailingSpacer(whitespacePart);
        }
        field.setEmptySegmentsFlags(emptySegsFlags.toString());
        this.currentElementId += 10;
    }

    private void addTransElements(ITextUnit tu, Field field, int currentSegmentId, Segment okapiSegment) {
        Set<LocaleId> targetLocals = tu.getTargetLocales();
        for (LocaleId trgLoc : targetLocals) {
            Segment trgSegment = tu.getTargetSegment(trgLoc, okapiSegment.id, false);
            TextFragment trgTextFragment = trgSegment.getContent();
            if (trgTextFragment.isEmpty()) continue;
            Trans xiniTrans = objectFactory.createTrans();
            xiniTrans.setSegID(currentSegmentId);
            xiniTrans.setLanguage(trgLoc.toBCP47());
            field.getSegAndTrans().add(xiniTrans);
            List<Code> codes = trgTextFragment.getCodes();
            if (codes.size() > 0) {
                xiniTrans.getContent().addAll(this.transformer.codesToJAXBForTKit(trgTextFragment.getCodedText(), codes));
                continue;
            }
            xiniTrans.getContent().add((Serializable)((Object)trgTextFragment.getText()));
        }
    }

    private static boolean textFragmentIsEmpty(TextFragment textFragment) {
        if (textFragment.isEmpty()) {
            return true;
        }
        return FilterEventToXiniTransformer.containsOnlyWhitespace(textFragment.getCodedText());
    }

    private static boolean containsOnlyWhitespace(String text) {
        return ALL_WHITESPACE_PATTERN.matcher(text).matches();
    }

    private Field prepareXiniStructure(ITextUnit tu) {
        Element element = objectFactory.createElement();
        Element.ElementContent elementContent = objectFactory.createElementElementContent();
        Fields fields = objectFactory.createFields();
        Field field = objectFactory.createField();
        this.currentPage.getElements().getElement().add(element);
        element.setElementContent(elementContent);
        elementContent.setFields(fields);
        fields.getField().add(field);
        element.setElementID(this.currentElementId);
        field.setFieldID(this.currentFieldId);
        field.setExternalID(tu.getId());
        field.setLabel(tu.getName());
        return field;
    }

    public void marshall(OutputStream os) {
        try {
            this.m.marshal((Object)this.xini, os);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

