/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import net.sf.okapi.lib.xliff.Util;
import org.oasisopen.xliff.v2.ICode;
import org.oasisopen.xliff.v2.IMarker;
import org.oasisopen.xliff.v2.InlineType;

public class Code
implements ICode {
    private static final long serialVersionUID = 64L;
    public static final int CANDELETE = 1;
    public static final int CANCOPY = 2;
    public static final int CANREORDER = 4;
    private String internalId;
    private InlineType inlineType;
    private String id;
    private String originalData;
    private int hints = 7;
    private String disp;
    private String equiv;
    private String type;
    private String subFlows;
    private String nid;

    public Code(InlineType inlineType, String id, String originalData) {
        if (inlineType == null) {
            throw new RuntimeException("Inline type cannot be null.");
        }
        if (id == null) {
            throw new RuntimeException("Code id cannot be null.");
        }
        this.inlineType = inlineType;
        this.id = id;
        this.internalId = Util.toInternalId(id, inlineType);
        this.originalData = originalData;
    }

    @Override
    public String getOriginalData() {
        return this.originalData;
    }

    @Override
    public void setOriginalData(String originalData) {
        this.originalData = originalData;
    }

    @Override
    public boolean hasOriginalData() {
        return !Util.isNullOrEmpty(this.originalData);
    }

    @Override
    public String getNid() {
        return this.nid;
    }

    @Override
    public void setNid(String nid) {
        this.nid = nid;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getInternalId() {
        return this.internalId;
    }

    @Override
    public InlineType getInlineType() {
        return this.inlineType;
    }

    @Override
    public void setInlineType(InlineType inlineType) {
        this.inlineType = inlineType;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getDisp() {
        return this.disp;
    }

    @Override
    public void setDisp(String disp) {
        this.disp = disp;
    }

    @Override
    public String getEquiv() {
        return this.equiv;
    }

    @Override
    public void setEquiv(String equiv) {
        this.equiv = equiv;
    }

    @Override
    public String getSubFlows() {
        return this.subFlows;
    }

    @Override
    public void setSubFlows(String subFlows) {
        this.subFlows = subFlows;
    }

    @Override
    public int getHints() {
        return this.hints;
    }

    @Override
    public void setHints(int hints) {
        this.hints = hints;
    }

    @Override
    public boolean canDelete() {
        return (this.hints & 1) == 1;
    }

    @Override
    public void setCanDelete(boolean canDelete) {
        this.hints = canDelete ? (this.hints |= 1) : (this.hints &= 0xFFFFFFFE);
    }

    @Override
    public boolean canCopy() {
        return (this.hints & 2) == 2;
    }

    @Override
    public void setCanCopy(boolean canCopy) {
        this.hints = canCopy ? (this.hints |= 2) : (this.hints &= 0xFFFFFFFD);
    }

    @Override
    public boolean canReorder() {
        return (this.hints & 4) == 4;
    }

    @Override
    public void setCanReorder(boolean canReorder) {
        this.hints = canReorder ? (this.hints |= 4) : (this.hints &= 0xFFFFFFFB);
    }

    @Override
    public boolean equals(IMarker marker) {
        if (marker == null) {
            throw new NullPointerException("The parameter of Code.equals() must not be null.");
        }
        if (this == marker) {
            return true;
        }
        if (!(marker instanceof ICode)) {
            return false;
        }
        ICode code = (ICode)marker;
        if (this.inlineType.compareTo(code.getInlineType()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.id, code.getId()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.type, code.getType()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.subFlows, code.getSubFlows()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.originalData, code.getOriginalData()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.disp, code.getDisp()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.equiv, code.getEquiv()) != 0) {
            return false;
        }
        if (this.hints != code.getHints()) {
            return false;
        }
        return Util.compareAllowingNull(this.internalId, code.getInternalId()) == 0;
    }

    @Override
    public boolean isAnnotation() {
        return false;
    }
}

