/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.okapi.lib.xliff.Markers;
import net.sf.okapi.lib.xliff.XLIFFReaderException;
import org.oasisopen.xliff.v2.ICode;
import org.oasisopen.xliff.v2.IDataStore;
import org.oasisopen.xliff.v2.IMarkers;

public class DataStore
implements IDataStore {
    private static final long serialVersionUID = 64L;
    private Markers srcMarkers;
    private Markers trgMarkers;
    private transient Map<String, String> map;

    @Override
    public boolean hasCodeWithOriginalData() {
        if (this.srcMarkers != null && this.srcMarkers.hasCodeWithOriginalData()) {
            return true;
        }
        return this.trgMarkers != null && this.trgMarkers.hasCodeWithOriginalData();
    }

    @Override
    public boolean hasSourceMarker() {
        return this.srcMarkers != null && this.srcMarkers.size() > 0;
    }

    @Override
    public boolean hasTargetMarker() {
        return this.trgMarkers != null && this.trgMarkers.size() > 0;
    }

    @Override
    public IMarkers getSourceMarkers() {
        if (this.srcMarkers == null) {
            this.srcMarkers = new Markers(this);
        }
        return this.srcMarkers;
    }

    @Override
    public IMarkers getTargetMarkers() {
        if (this.trgMarkers == null) {
            this.trgMarkers = new Markers(this);
        }
        return this.trgMarkers;
    }

    @Override
    public void calculateOriginalDataToIdsMap() {
        String tmp;
        ICode code;
        int i;
        this.map = new LinkedHashMap<String, String>();
        int mapId = 0;
        if (this.srcMarkers != null) {
            for (i = 0; i < this.srcMarkers.size(); ++i) {
                if (this.srcMarkers.get(i).isAnnotation()) continue;
                code = (ICode)this.srcMarkers.get(i);
                tmp = code.getOriginalData();
                if (tmp == null) {
                    tmp = "";
                }
                if (this.map.containsKey(tmp)) continue;
                this.map.put(code.getOriginalData(), "d" + String.valueOf(++mapId));
            }
        }
        if (this.trgMarkers != null) {
            for (i = 0; i < this.trgMarkers.size(); ++i) {
                if (this.trgMarkers.get(i).isAnnotation()) continue;
                code = (ICode)this.trgMarkers.get(i);
                tmp = code.getOriginalData();
                if (tmp == null) {
                    tmp = "";
                }
                if (this.map.containsKey(tmp)) continue;
                this.map.put(code.getOriginalData(), "d" + String.valueOf(++mapId));
            }
        }
    }

    @Override
    public void setOutsideRepresentationMap(Map<String, String> map) {
        this.map = map;
    }

    @Override
    public Map<String, String> getOutsideRepresentationMap() {
        return this.map;
    }

    @Override
    public String getIdForOriginalData(String originalData) {
        if (this.map == null) {
            throw new XLIFFReaderException("No original data map defined for this object.");
        }
        if (!this.map.containsKey(originalData)) {
            throw new XLIFFReaderException(String.format("No id found for the original data '%s'.", originalData));
        }
        return this.map.get(originalData);
    }

    @Override
    public String getOriginalDataForId(String id) {
        if (this.map == null) {
            throw new XLIFFReaderException("No original data map defined for this object.");
        }
        if (!this.map.containsKey(id)) {
            throw new XLIFFReaderException(String.format("No original data found for the id '%s'.", id));
        }
        return this.map.get(id);
    }
}

