/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import net.sf.okapi.lib.xliff.DataStore;
import net.sf.okapi.lib.xliff.Fragment;
import org.oasisopen.xliff.v2.IExtendedAttributes;
import org.oasisopen.xliff.v2.IFragment;
import org.oasisopen.xliff.v2.IPart;

public class Part
implements IPart {
    private static final long serialVersionUID = 64L;
    private DataStore store;
    private IFragment source;
    private IFragment target;
    private int targetOrder;
    private IExtendedAttributes xattrs;

    public Part(DataStore store) {
        this.store = store;
        this.source = new Fragment(store);
    }

    public Part(DataStore store, String sourceContent) {
        this.store = store;
        this.source = new Fragment(store, false, sourceContent);
    }

    @Override
    public IFragment getSource() {
        return this.source;
    }

    @Override
    public void setSource(IFragment fragment) {
        if (this.store != fragment.getDataStore()) {
            throw new RuntimeException("The fragment passed in setSource must use the same codes store.");
        }
        this.source = fragment;
    }

    @Override
    public void setSource(String plainText) {
        this.source = new Fragment(this.store, false, plainText);
    }

    @Override
    public boolean hasTarget() {
        return this.target != null;
    }

    @Override
    public IFragment getTarget(boolean createIfNeeded) {
        if (this.target == null && createIfNeeded) {
            this.target = new Fragment(this.store, true);
        }
        return this.target;
    }

    @Override
    public void setTarget(IFragment fragment) {
        if (this.store != fragment.getDataStore()) {
            throw new RuntimeException("The fragment passed in setTarget must use the same codes store.");
        }
        this.target = fragment;
    }

    @Override
    public void setTarget(String plainText) {
        this.target = new Fragment(this.store, true, plainText);
    }

    @Override
    public void setTargetOrder(int targetOrder) {
        this.targetOrder = targetOrder;
    }

    @Override
    public int getTargetOrder() {
        return this.targetOrder;
    }

    @Override
    public DataStore getDataStore() {
        return this.store;
    }

    @Override
    public void setExtendedAttributes(IExtendedAttributes attributes) {
        this.xattrs = attributes;
    }

    @Override
    public IExtendedAttributes getExtendedAttributes() {
        return this.xattrs;
    }

    @Override
    public boolean hasExtendedAttribute() {
        if (this.xattrs == null) {
            return false;
        }
        return this.xattrs.size() > 0;
    }
}

