/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.okapi.lib.xliff.DataStore;
import net.sf.okapi.lib.xliff.EventData;
import net.sf.okapi.lib.xliff.Fragment;
import net.sf.okapi.lib.xliff.Part;
import net.sf.okapi.lib.xliff.Segment;
import org.oasisopen.xliff.v2.ICandidate;
import org.oasisopen.xliff.v2.IFragment;
import org.oasisopen.xliff.v2.INote;
import org.oasisopen.xliff.v2.IPart;
import org.oasisopen.xliff.v2.ISegment;
import org.oasisopen.xliff.v2.IWithCandidates;
import org.oasisopen.xliff.v2.IWithNotes;

public class Unit
extends EventData
implements Iterable<IPart>,
IWithCandidates,
IWithNotes {
    private static final long serialVersionUID = 64L;
    private ArrayList<IPart> list;
    private DataStore store;
    private ArrayList<ICandidate> candidates;
    private ArrayList<INote> notes;

    public Unit(String id) {
        this.setId(id);
        this.list = new ArrayList();
        this.store = new DataStore();
    }

    @Override
    public Iterator<IPart> iterator() {
        return new Iterator<IPart>(){
            int current = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The method remove() not supported.");
            }

            @Override
            public IPart next() {
                return (IPart)Unit.this.list.get(++this.current - 1);
            }

            @Override
            public boolean hasNext() {
                return !Unit.this.list.isEmpty() && this.current < Unit.this.list.size();
            }
        };
    }

    public int getPartCount() {
        return this.list.size();
    }

    public ISegment appendNewSegment() {
        Segment seg = new Segment(this.store);
        this.list.add(seg);
        return seg;
    }

    public Part appendNewIgnorable() {
        Part part = new Part(this.store);
        this.list.add(part);
        return part;
    }

    public IPart getPart(int partIndex) {
        return this.list.get(partIndex);
    }

    public DataStore getDataStore() {
        return this.store;
    }

    @Override
    public void addCandidate(ICandidate candidate) {
        if (this.candidates == null) {
            this.candidates = new ArrayList();
        }
        this.candidates.add(candidate);
    }

    @Override
    public List<ICandidate> getCandidates() {
        if (this.candidates == null) {
            return Collections.emptyList();
        }
        return this.candidates;
    }

    @Override
    public int getCandidateCount() {
        if (this.candidates == null) {
            return 0;
        }
        return this.candidates.size();
    }

    @Override
    public void addNote(INote note) {
        if (this.notes == null) {
            this.notes = new ArrayList();
        }
        this.notes.add(note);
    }

    @Override
    public List<INote> getNotes() {
        if (this.notes == null) {
            return Collections.emptyList();
        }
        return this.notes;
    }

    @Override
    public int getNoteCount() {
        if (this.notes == null) {
            return 0;
        }
        return this.notes.size();
    }

    public void split(int partIndex, int srcStart, int srcEnd, int trgStart, int trgEnd) {
        Segment seg;
        IPart part = this.getPart(partIndex);
        IFragment src = part.getSource();
        String ctext = src.getCodedText();
        if (srcEnd == -1) {
            srcEnd = ctext.length() - 1;
        }
        if (srcStart > srcEnd) {
            throw new RuntimeException("Bad range.");
        }
        if (ctext.length() < srcEnd) {
            throw new RuntimeException("Range out of bounds.");
        }
        if (srcStart >= ctext.length() || Fragment.isMarker(ctext.charAt(srcStart + 1))) {
            // empty if block
        }
        String left = "";
        left = ctext.substring(0, srcStart);
        String mid = "";
        mid = ctext.substring(srcStart, srcEnd);
        String right = "";
        right = ctext.substring(srcEnd);
        if (!right.isEmpty()) {
            seg = new Segment(this.store);
            seg.getSource().setCodedText(right);
            this.list.add(partIndex + 1, seg);
        }
        if (!left.isEmpty()) {
            seg = new Segment(this.store);
            seg.getSource().setCodedText(left);
            this.list.add(partIndex, seg);
        }
        if (mid.isEmpty()) {
            this.list.remove(part);
        } else if (mid.length() != ctext.length()) {
            part.getSource().setCodedText(mid);
        }
    }
}

