/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.persistence.json.jackson;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.lib.persistence.IPersistenceBean;
import net.sf.okapi.lib.persistence.PersistenceSession;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public abstract class JSONPersistenceSession
extends PersistenceSession {
    public static final String MSG_JSON_READ_EX = "JSONPersistenceSession: error reading.";
    public static final String MSG_JSON_WRITE_EX = "JSONPersistenceSession: error writing.";
    private static final String JSON_HEADER = "header";
    private static final String JSON_BODY = "body";
    private static final String JSON_VER = "version";
    private static final String JSON_DESCR = "description";
    private static final String JSON_CLASS = "itemClass";
    private static final String JSON_MIME = "mimeType";
    private static final String JSON_FRAMES = "frames";
    private static final String MIME_TYPE = "application/json";
    private ObjectMapper mapper = new ObjectMapper();
    private JsonFactory jsonFactory;
    private JsonParser parser;
    private JsonGenerator headerGen;
    private JsonGenerator bodyGen;
    private OutputStream bodyOut;
    private File headerTemp;
    private File bodyTemp;

    public JSONPersistenceSession() {
        this.mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        this.mapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(DeserializationConfig.Feature.USE_ANNOTATIONS, true);
        this.mapper.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        this.mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        this.jsonFactory = this.mapper.getJsonFactory();
    }

    @Override
    public <T extends IPersistenceBean<?>> T convert(Object object, Class<T> expectedClass) {
        return (T)((IPersistenceBean)this.mapper.convertValue(object, expectedClass));
    }

    @Override
    protected <T extends IPersistenceBean<?>> T readBean(Class<T> beanClass, String name) {
        IPersistenceBean bean = null;
        try {
            JsonToken token = this.parser.nextToken();
            if (token == JsonToken.END_OBJECT) {
                return null;
            }
            String fieldName = this.parser.getCurrentName();
            if (fieldName != null && name != null && !fieldName.startsWith(name)) {
                throw new OkapiIOException(String.format("JSONPersistenceSession: input stream is broken. Item label should start with \"%s\", but was \"%s\"", name, fieldName));
            }
            this.parser.nextToken();
            bean = (IPersistenceBean)this.mapper.readValue(this.parser, beanClass);
        }
        catch (JsonParseException e) {
            throw new RuntimeException(MSG_JSON_READ_EX, e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(MSG_JSON_READ_EX, e);
        }
        catch (EOFException e) {
            throw new OkapiIOException("JSONPersistenceSession: input stream is broken -- unexpected EOF.", e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        return (T)bean;
    }

    @Override
    protected void writeBean(IPersistenceBean<?> bean, String name) {
        try {
            this.bodyGen.writeFieldName(name);
            this.mapper.writeValue(this.bodyGen, bean);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(MSG_JSON_WRITE_EX, e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    private String readFieldValue(String fieldName) {
        String res = "";
        try {
            this.parser.nextToken();
            if (!Util.isEmpty(fieldName) && !fieldName.equalsIgnoreCase(this.parser.getCurrentName())) {
                throw new OkapiIOException("JSONPersistenceSession: input stream is broken");
            }
            this.parser.nextToken();
            res = this.parser.getText();
        }
        catch (JsonParseException e) {
            throw new RuntimeException(MSG_JSON_READ_EX, e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        return res;
    }

    @Override
    protected void startReading(InputStream inStream) {
        try {
            this.parser = this.jsonFactory.createJsonParser(inStream);
            JsonToken token = this.parser.nextToken();
            if (token != JsonToken.START_OBJECT) {
                throw new OkapiIOException("JSONPersistenceSession: input stream is broken");
            }
            this.parser.nextToken();
            if (!JSON_HEADER.equalsIgnoreCase(this.parser.getCurrentName())) {
                throw new OkapiIOException("JSONPersistenceSession: input stream is broken");
            }
            token = this.parser.nextToken();
            if (token != JsonToken.START_OBJECT) {
                throw new OkapiIOException("JSONPersistenceSession: input stream is broken");
            }
            String version = this.readFieldValue(JSON_VER);
            this.setVersion(version);
            String description = this.readFieldValue(JSON_DESCR);
            String itemClass = this.readFieldValue(JSON_CLASS);
            String mimeType = this.readFieldValue(JSON_MIME);
            this.parser.nextToken();
            if (!JSON_FRAMES.equalsIgnoreCase(this.parser.getCurrentName())) {
                throw new OkapiIOException("JSONPersistenceSession: input stream is broken");
            }
            this.parser.nextToken();
            this.setFrames(this.mapper.readValue(this.parser, List.class));
            this.parser.nextToken();
            this.parser.nextToken();
            if (!JSON_BODY.equalsIgnoreCase(this.parser.getCurrentName())) {
                throw new OkapiIOException("JSONPersistenceSession: input stream is broken");
            }
            this.parser.nextToken();
            if (token != JsonToken.START_OBJECT) {
                throw new OkapiIOException("JSONPersistenceSession: input stream is broken");
            }
        }
        catch (JsonParseException e) {
            throw new OkapiIOException("JSONPersistenceSession: input stream is broken. ", e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    protected void endReading(InputStream inStream) {
        try {
            this.parser.close();
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    protected void startWriting(OutputStream outStream) {
        try {
            this.bodyTemp = File.createTempFile("~temp", null);
            this.bodyTemp.deleteOnExit();
            this.bodyOut = new FileOutputStream(this.bodyTemp);
            this.bodyGen = this.jsonFactory.createJsonGenerator(this.bodyOut, JsonEncoding.UTF8);
            this.bodyGen.useDefaultPrettyPrinter();
            this.bodyGen.writeStartObject();
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    protected void endWriting(OutputStream outStream) {
        try {
            this.bodyGen.writeRaw('}');
            this.bodyGen.close();
            this.bodyOut.close();
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(MSG_JSON_WRITE_EX, e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        try {
            this.headerTemp = File.createTempFile("~temp", null);
            this.headerTemp.deleteOnExit();
            FileOutputStream headerOut = new FileOutputStream(this.headerTemp);
            this.headerGen = this.jsonFactory.createJsonGenerator(headerOut, JsonEncoding.UTF8);
            this.headerGen.useDefaultPrettyPrinter();
            this.headerGen.writeStartObject();
            this.headerGen.writeFieldName(JSON_HEADER);
            this.headerGen.writeStartObject();
            this.headerGen.writeStringField(JSON_VER, this.getVersion());
            this.headerGen.writeStringField(JSON_DESCR, this.getDescription());
            this.headerGen.writeStringField(JSON_CLASS, this.getItemClass());
            this.headerGen.writeStringField(JSON_MIME, this.getMimeType());
            this.headerGen.writeObjectField(JSON_FRAMES, this.getFrames());
            this.headerGen.writeEndObject();
            this.headerGen.writeFieldName(JSON_BODY);
            this.headerGen.writeRaw(" : ");
            this.headerGen.flush();
            ((OutputStream)headerOut).close();
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(MSG_JSON_WRITE_EX, e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        try {
            FileInputStream headerIn = new FileInputStream(this.headerTemp);
            FileInputStream bodyIn = new FileInputStream(this.bodyTemp);
            StreamUtil.copy((InputStream)headerIn, outStream);
            StreamUtil.copy((InputStream)bodyIn, outStream);
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException(e);
        }
    }

    @Override
    protected String writeBeanToString(IPersistenceBean<?> bean) {
        try {
            return this.mapper.writeValueAsString(bean);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(MSG_JSON_WRITE_EX, e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    protected <T extends IPersistenceBean<?>> T readBeanFromString(String content, Class<T> beanClass) {
        try {
            return (T)((IPersistenceBean)this.mapper.readValue(content, beanClass));
        }
        catch (JsonParseException e) {
            throw new RuntimeException(MSG_JSON_READ_EX, e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(MSG_JSON_READ_EX, e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }
}

