/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.skeleton.ResourceSimplifier;

@UsingParameters
public class ResourceSimplifierStep
extends BasePipelineStep {
    private ResourceSimplifier simplifier;
    private LocaleId targetLocale;
    private boolean resolveCodeRefs = true;

    public ResourceSimplifierStep() {
    }

    public ResourceSimplifierStep(boolean resolveCodeRefs) {
        this();
        this.resolveCodeRefs = resolveCodeRefs;
    }

    @Override
    public String getDescription() {
        return "Simplify resources by converting references in generic skeleton parts. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "Resource Simplifier";
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.simplifier = new ResourceSimplifier(null, this.targetLocale);
                this.simplifier.setResolveCodeRefs(this.resolveCodeRefs);
            }
            case END_DOCUMENT: 
            case START_SUBDOCUMENT: 
            case END_SUBDOCUMENT: 
            case START_GROUP: 
            case END_GROUP: 
            case TEXT_UNIT: 
            case DOCUMENT_PART: {
                return this.simplifier.convert(event);
            }
        }
        return event;
    }
}

