/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common.tufiltering;

import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.steps.common.tufiltering.ITextUnitFilter;
import net.sf.okapi.steps.common.tufiltering.Parameters;

public class TuFilteringStep
extends BasePipelineStep {
    private ITextUnitFilter tuFilter;
    private Parameters params = new Parameters();

    public TuFilteringStep() {
    }

    public TuFilteringStep(ITextUnitFilter tuFilter) {
        this();
        this.tuFilter = tuFilter;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public String getName() {
        return "Text Unit Filtering";
    }

    @Override
    public String getDescription() {
        return "Set the non-translatable flag to the text units accepted by the text unit filter specified in step's parameters. Expects: filter events. Sends back: filter events.";
    }

    private void initFilter() {
        if (this.tuFilter == null) {
            if (Util.isEmpty(this.params.getTuFilterClassName())) {
                throw new RuntimeException("Text Unit filter class is not specified in step parameters.");
            }
            try {
                this.tuFilter = (ITextUnitFilter)ClassUtil.instantiateClass(this.params.getTuFilterClassName());
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Cannot instantiate the specified Text Unit filter (%s)", e.toString()));
            }
        }
    }

    protected Event processFiltered(Event tuEvent) {
        ITextUnit tu = tuEvent.getTextUnit();
        if (tu != null) {
            tu.setIsTranslatable(false);
        }
        return tuEvent;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.initFilter();
        return super.handleStartBatch(event);
    }

    @Override
    protected Event handleTextUnit(Event event) {
        this.initFilter();
        if (this.tuFilter.accept(event.getTextUnit())) {
            return this.processFiltered(event);
        }
        return event;
    }
}

