/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.desegmentation;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.steps.desegmentation.Parameters;

@UsingParameters(value=Parameters.class)
public class DesegmentationStep
extends BasePipelineStep {
    private Parameters params = new Parameters();
    private LocaleId targetLocale;

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @Override
    public String getName() {
        return "Desegmentation";
    }

    @Override
    public String getDescription() {
        return "Joins all segments into a single content. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        TextContainer cont;
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return event;
        }
        if (this.params.getDesegmentSource() && tu.getSource().hasBeenSegmented()) {
            tu.getSource().getSegments().joinAll();
        }
        if (this.params.getDesegmentTarget() && (cont = tu.getTarget(this.targetLocale)) != null && cont.hasBeenSegmented()) {
            cont.getSegments().joinAll();
        }
        return event;
    }
}

